/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jfree.chart.internal.Args;
import org.jfree.chart.internal.CloneUtils;
import org.jfree.data.gantt.Task;
import org.jfree.data.general.Series;

public class TaskSeries<K extends Comparable<K>>
extends Series<K> {
    private List<Task> tasks = new ArrayList<Task>();

    public TaskSeries(K name) {
        super(name);
    }

    public void add(Task task) {
        Args.nullNotPermitted(task, "task");
        this.tasks.add(task);
        this.fireSeriesChanged();
    }

    public void remove(Task task) {
        this.tasks.remove(task);
        this.fireSeriesChanged();
    }

    public void removeAll() {
        this.tasks.clear();
        this.fireSeriesChanged();
    }

    @Override
    public int getItemCount() {
        return this.tasks.size();
    }

    public Task get(int index) {
        return this.tasks.get(index);
    }

    public Task get(String description) {
        Task result = null;
        int count = this.tasks.size();
        for (int i = 0; i < count; ++i) {
            Task t = this.tasks.get(i);
            if (!t.getDescription().equals(description)) continue;
            result = t;
            break;
        }
        return result;
    }

    public List<Task> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TaskSeries)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TaskSeries that = (TaskSeries)obj;
        return this.tasks.equals(that.tasks);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.tasks);
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TaskSeries clone = (TaskSeries)super.clone();
        clone.tasks = CloneUtils.cloneList(this.tasks);
        return clone;
    }
}

