/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.category;

import java.io.Serializable;
import java.util.List;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.data.DefaultKeyedValues2D;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;

public class DefaultCategoryDataset<R extends Comparable<R>, C extends Comparable<C>>
extends AbstractDataset
implements CategoryDataset<R, C>,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8168173757291644622L;
    private DefaultKeyedValues2D<R, C> data = new DefaultKeyedValues2D();

    @Override
    public int getRowCount() {
        return this.data.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    @Override
    public Number getValue(int row, int column) {
        return this.data.getValue(row, column);
    }

    @Override
    public R getRowKey(int row) {
        return this.data.getRowKey(row);
    }

    @Override
    public int getRowIndex(R key) {
        return this.data.getRowIndex(key);
    }

    @Override
    public List<R> getRowKeys() {
        return this.data.getRowKeys();
    }

    @Override
    public C getColumnKey(int column) {
        return this.data.getColumnKey(column);
    }

    @Override
    public int getColumnIndex(C key) {
        return this.data.getColumnIndex(key);
    }

    @Override
    public List<C> getColumnKeys() {
        return this.data.getColumnKeys();
    }

    @Override
    public Number getValue(R rowKey, C columnKey) {
        return this.data.getValue(rowKey, columnKey);
    }

    public void addValue(Number value, R rowKey, C columnKey) {
        this.data.addValue(value, rowKey, columnKey);
        this.fireDatasetChanged();
    }

    public void addValue(double value, R rowKey, C columnKey) {
        this.addValue((Number)value, rowKey, columnKey);
    }

    public void setValue(Number value, R rowKey, C columnKey) {
        this.data.setValue(value, rowKey, columnKey);
        this.fireDatasetChanged();
    }

    public void setValue(double value, R rowKey, C columnKey) {
        this.setValue((Number)value, rowKey, columnKey);
    }

    public void incrementValue(double value, R rowKey, C columnKey) {
        double existing = 0.0;
        Number n = this.getValue(rowKey, columnKey);
        if (n != null) {
            existing = n.doubleValue();
        }
        this.setValue(existing + value, rowKey, columnKey);
    }

    public void removeValue(R rowKey, C columnKey) {
        this.data.removeValue(rowKey, columnKey);
        this.fireDatasetChanged();
    }

    public void removeRow(int rowIndex) {
        this.data.removeRow(rowIndex);
        this.fireDatasetChanged();
    }

    public void removeRow(R rowKey) {
        this.data.removeRow(rowKey);
        this.fireDatasetChanged();
    }

    public void removeColumn(int columnIndex) {
        this.data.removeColumn(columnIndex);
        this.fireDatasetChanged();
    }

    public void removeColumn(C columnKey) {
        this.data.removeColumn(columnKey);
        this.fireDatasetChanged();
    }

    public void clear() {
        this.data.clear();
        this.fireDatasetChanged();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CategoryDataset)) {
            return false;
        }
        CategoryDataset that = (CategoryDataset)obj;
        if (!this.getRowKeys().equals(that.getRowKeys())) {
            return false;
        }
        if (!this.getColumnKeys().equals(that.getColumnKeys())) {
            return false;
        }
        int rowCount = this.getRowCount();
        int colCount = this.getColumnCount();
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < colCount; ++c) {
                Number v1 = this.getValue(r, c);
                Number v2 = that.getValue(r, c);
                if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultCategoryDataset clone = (DefaultCategoryDataset)super.clone();
        clone.data = (DefaultKeyedValues2D)this.data.clone();
        return clone;
    }
}

