/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.internal.Args;
import org.jfree.data.KeyedObjects;
import org.jfree.data.UnknownKeyException;

public class KeyedObjects2D<R extends Comparable<R>, C extends Comparable<C>>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1015873563138522374L;
    private List<R> rowKeys = new ArrayList<R>();
    private List<C> columnKeys = new ArrayList<C>();
    private List<KeyedObjects> rows = new ArrayList<KeyedObjects>();

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public Object getObject(int row, int column) {
        int index;
        Comparable columnKey;
        Object result = null;
        KeyedObjects rowData = this.rows.get(row);
        if (rowData != null && (columnKey = (Comparable)this.columnKeys.get(column)) != null && (index = rowData.getIndex(columnKey)) >= 0) {
            result = rowData.getObject(columnKey);
        }
        return result;
    }

    public R getRowKey(int row) {
        return (R)((Comparable)this.rowKeys.get(row));
    }

    public int getRowIndex(R key) {
        Args.nullNotPermitted(key, "key");
        return this.rowKeys.indexOf(key);
    }

    public List<R> getRowKeys() {
        return Collections.unmodifiableList(this.rowKeys);
    }

    public C getColumnKey(int column) {
        return (C)((Comparable)this.columnKeys.get(column));
    }

    public int getColumnIndex(C key) {
        Args.nullNotPermitted(key, "key");
        return this.columnKeys.indexOf(key);
    }

    public List<C> getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }

    public Object getObject(R rowKey, C columnKey) {
        Args.nullNotPermitted(rowKey, "rowKey");
        Args.nullNotPermitted(columnKey, "columnKey");
        int row = this.rowKeys.indexOf(rowKey);
        if (row < 0) {
            throw new UnknownKeyException("Row key (" + rowKey + ") not recognised.");
        }
        int column = this.columnKeys.indexOf(columnKey);
        if (column < 0) {
            throw new UnknownKeyException("Column key (" + columnKey + ") not recognised.");
        }
        KeyedObjects rowData = this.rows.get(row);
        int index = rowData.getIndex(columnKey);
        if (index >= 0) {
            return rowData.getObject(index);
        }
        return null;
    }

    public void addObject(Object object, R rowKey, C columnKey) {
        this.setObject(object, rowKey, columnKey);
    }

    public void setObject(Object object, R rowKey, C columnKey) {
        KeyedObjects<C> row;
        Args.nullNotPermitted(rowKey, "rowKey");
        Args.nullNotPermitted(columnKey, "columnKey");
        int rowIndex = this.rowKeys.indexOf(rowKey);
        if (rowIndex >= 0) {
            row = this.rows.get(rowIndex);
        } else {
            this.rowKeys.add(rowKey);
            row = new KeyedObjects<C>();
            this.rows.add(row);
        }
        row.setObject(columnKey, object);
        int columnIndex = this.columnKeys.indexOf(columnKey);
        if (columnIndex < 0) {
            this.columnKeys.add(columnKey);
        }
    }

    public void removeObject(R rowKey, C columnKey) {
        int colIndex;
        int item;
        int rowIndex = this.getRowIndex(rowKey);
        if (rowIndex < 0) {
            throw new UnknownKeyException("Row key (" + rowKey + ") not recognised.");
        }
        int columnIndex = this.getColumnIndex(columnKey);
        if (columnIndex < 0) {
            throw new UnknownKeyException("Column key (" + columnKey + ") not recognised.");
        }
        this.setObject(null, rowKey, columnKey);
        boolean allNull = true;
        KeyedObjects row = this.rows.get(rowIndex);
        int itemCount = row.getItemCount();
        for (item = 0; item < itemCount; ++item) {
            if (row.getObject(item) == null) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            this.rowKeys.remove(rowIndex);
            this.rows.remove(rowIndex);
        }
        allNull = true;
        itemCount = this.rows.size();
        for (item = 0; item < itemCount; ++item) {
            row = this.rows.get(item);
            colIndex = row.getIndex(columnKey);
            if (colIndex < 0 || row.getObject(colIndex) == null) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            itemCount = this.rows.size();
            for (item = 0; item < itemCount; ++item) {
                row = this.rows.get(item);
                colIndex = row.getIndex(columnKey);
                if (colIndex < 0) continue;
                row.removeValue(colIndex);
            }
            this.columnKeys.remove(columnKey);
        }
    }

    public void removeRow(int rowIndex) {
        this.rowKeys.remove(rowIndex);
        this.rows.remove(rowIndex);
    }

    public void removeRow(R rowKey) {
        int index = this.getRowIndex(rowKey);
        if (index < 0) {
            throw new UnknownKeyException("Row key (" + rowKey + ") not recognised.");
        }
        this.removeRow(index);
    }

    public void removeColumn(int columnIndex) {
        C columnKey = this.getColumnKey(columnIndex);
        this.removeColumn(columnKey);
    }

    public void removeColumn(C columnKey) {
        int index = this.getColumnIndex(columnKey);
        if (index < 0) {
            throw new UnknownKeyException("Column key (" + columnKey + ") not recognised.");
        }
        for (KeyedObjects rowData : this.rows) {
            int i = rowData.getIndex(columnKey);
            if (i < 0) continue;
            rowData.removeValue(i);
        }
        this.columnKeys.remove(columnKey);
    }

    public void clear() {
        this.rowKeys.clear();
        this.columnKeys.clear();
        this.rows.clear();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KeyedObjects2D)) {
            return false;
        }
        KeyedObjects2D that = (KeyedObjects2D)obj;
        if (!this.getRowKeys().equals(that.getRowKeys())) {
            return false;
        }
        if (!this.getColumnKeys().equals(that.getColumnKeys())) {
            return false;
        }
        int rowCount = this.getRowCount();
        if (rowCount != that.getRowCount()) {
            return false;
        }
        int colCount = this.getColumnCount();
        if (colCount != that.getColumnCount()) {
            return false;
        }
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < colCount; ++c) {
                Object v1 = this.getObject(r, c);
                Object v2 = that.getObject(r, c);
                if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.rowKeys.hashCode();
        result = 29 * result + this.columnKeys.hashCode();
        result = 29 * result + this.rows.hashCode();
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        KeyedObjects2D clone = (KeyedObjects2D)super.clone();
        clone.columnKeys = new ArrayList<C>(this.columnKeys);
        clone.rowKeys = new ArrayList<R>(this.rowKeys);
        clone.rows = new ArrayList<KeyedObjects>(this.rows.size());
        for (KeyedObjects row : this.rows) {
            clone.rows.add((KeyedObjects)row.clone());
        }
        return clone;
    }
}

