/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.chart.internal.Args;

public class KeyToGroupMap<K extends Comparable<K>, G extends Comparable<G>>
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2228169345475318082L;
    private G defaultGroup;
    private List<G> groups;
    private Map<K, G> keyToGroupMap;

    public KeyToGroupMap() {
        this("Default Group");
    }

    public KeyToGroupMap(G defaultGroup) {
        Args.nullNotPermitted(defaultGroup, "defaultGroup");
        this.defaultGroup = defaultGroup;
        this.groups = new ArrayList<G>();
        this.keyToGroupMap = new HashMap<K, G>();
    }

    public int getGroupCount() {
        return this.groups.size() + 1;
    }

    public List<G> getGroups() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.defaultGroup);
        for (Comparable group : this.groups) {
            if (result.contains(group)) continue;
            result.add(group);
        }
        return result;
    }

    public int getGroupIndex(G group) {
        int result = this.groups.indexOf(group);
        if (result < 0) {
            if (this.defaultGroup.equals(group)) {
                result = 0;
            }
        } else {
            ++result;
        }
        return result;
    }

    public G getGroup(K key) {
        Args.nullNotPermitted(key, "key");
        Object result = this.defaultGroup;
        Comparable group = (Comparable)this.keyToGroupMap.get(key);
        if (group != null) {
            result = group;
        }
        return result;
    }

    public void mapKeyToGroup(K key, G group) {
        int count;
        Args.nullNotPermitted(key, "key");
        G currentGroup = this.getGroup(key);
        if (!currentGroup.equals(this.defaultGroup) && !currentGroup.equals(group) && (count = this.getKeyCount(currentGroup)) == 1) {
            this.groups.remove(currentGroup);
        }
        if (group == null) {
            this.keyToGroupMap.remove(key);
        } else {
            if (!this.groups.contains(group) && !this.defaultGroup.equals(group)) {
                this.groups.add(group);
            }
            this.keyToGroupMap.put(key, group);
        }
    }

    public int getKeyCount(G group) {
        Args.nullNotPermitted(group, "group");
        int result = 0;
        for (Comparable g : this.keyToGroupMap.values()) {
            if (!group.equals(g)) continue;
            ++result;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KeyToGroupMap)) {
            return false;
        }
        KeyToGroupMap that = (KeyToGroupMap)obj;
        if (!Objects.equals(this.defaultGroup, that.defaultGroup)) {
            return false;
        }
        return this.keyToGroupMap.equals(that.keyToGroupMap);
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + Objects.hashCode(this.defaultGroup);
        hash = 83 * hash + Objects.hashCode(this.keyToGroupMap);
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        KeyToGroupMap result = (KeyToGroupMap)super.clone();
        result.defaultGroup = (Comparable)KeyToGroupMap.clone(this.defaultGroup);
        result.groups = (List)KeyToGroupMap.clone(this.groups);
        result.keyToGroupMap = (Map)KeyToGroupMap.clone(this.keyToGroupMap);
        return result;
    }

    private static Object clone(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> c = object.getClass();
        Object result = null;
        try {
            Method m = c.getMethod("clone", null);
            if (Modifier.isPublic(m.getModifiers())) {
                try {
                    result = m.invoke(object, (Object[])null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (NoSuchMethodException e) {
            result = object;
        }
        return result;
    }

    private static Collection clone(Collection list) throws CloneNotSupportedException {
        Collection result = null;
        if (list != null) {
            try {
                Collection clone = (Collection)list.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Object o : list) {
                    clone.add(KeyToGroupMap.clone(o));
                }
                result = clone;
            }
            catch (Exception e) {
                throw new CloneNotSupportedException("Exception.");
            }
        }
        return result;
    }
}

