/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.chart.internal.Args;
import org.jfree.chart.internal.CloneUtils;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues2D;
import org.jfree.data.UnknownKeyException;

public class DefaultKeyedValues2D<R extends Comparable<R>, C extends Comparable<C>>
implements KeyedValues2D<R, C>,
PublicCloneable,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5514169970951994748L;
    private List<R> rowKeys = new ArrayList<R>();
    private List<C> columnKeys = new ArrayList<C>();
    private List<DefaultKeyedValues<C>> rows = new ArrayList<DefaultKeyedValues<C>>();
    private final boolean sortRowKeys;

    public DefaultKeyedValues2D() {
        this(false);
    }

    public DefaultKeyedValues2D(boolean sortRowKeys) {
        this.sortRowKeys = sortRowKeys;
    }

    @Override
    public int getRowCount() {
        return this.rowKeys.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnKeys.size();
    }

    @Override
    public Number getValue(int row, int column) {
        Comparable columnKey;
        int index;
        Number result = null;
        DefaultKeyedValues<C> rowData = this.rows.get(row);
        if (rowData != null && (index = rowData.getIndex(columnKey = (Comparable)this.columnKeys.get(column))) >= 0) {
            result = rowData.getValue(index);
        }
        return result;
    }

    @Override
    public R getRowKey(int row) {
        return (R)((Comparable)this.rowKeys.get(row));
    }

    @Override
    public int getRowIndex(R key) {
        Args.nullNotPermitted(key, "key");
        if (this.sortRowKeys) {
            return Collections.binarySearch(this.rowKeys, key);
        }
        return this.rowKeys.indexOf(key);
    }

    @Override
    public List<R> getRowKeys() {
        return Collections.unmodifiableList(this.rowKeys);
    }

    @Override
    public C getColumnKey(int column) {
        return (C)((Comparable)this.columnKeys.get(column));
    }

    @Override
    public int getColumnIndex(C key) {
        Args.nullNotPermitted(key, "key");
        return this.columnKeys.indexOf(key);
    }

    @Override
    public List<C> getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }

    @Override
    public Number getValue(R rowKey, C columnKey) {
        Args.nullNotPermitted(rowKey, "rowKey");
        Args.nullNotPermitted(columnKey, "columnKey");
        if (!this.columnKeys.contains(columnKey)) {
            throw new UnknownKeyException("Unrecognised columnKey: " + columnKey);
        }
        int row = this.getRowIndex(rowKey);
        if (row >= 0) {
            DefaultKeyedValues<C> rowData = this.rows.get(row);
            int col = rowData.getIndex(columnKey);
            return col >= 0 ? (Number)rowData.getValue(col) : (Number)null;
        }
        throw new UnknownKeyException("Unrecognised rowKey: " + rowKey);
    }

    public void addValue(Number value, R rowKey, C columnKey) {
        this.setValue(value, rowKey, columnKey);
    }

    public void setValue(Number value, R rowKey, C columnKey) {
        DefaultKeyedValues<Object> row;
        int rowIndex = this.getRowIndex(rowKey);
        if (rowIndex >= 0) {
            row = this.rows.get(rowIndex);
        } else {
            row = new DefaultKeyedValues();
            if (this.sortRowKeys) {
                rowIndex = -rowIndex - 1;
                this.rowKeys.add(rowIndex, rowKey);
                this.rows.add(rowIndex, row);
            } else {
                this.rowKeys.add(rowKey);
                this.rows.add(row);
            }
        }
        row.setValue(columnKey, value);
        int columnIndex = this.columnKeys.indexOf(columnKey);
        if (columnIndex < 0) {
            this.columnKeys.add(columnKey);
        }
    }

    public void removeValue(R rowKey, C columnKey) {
        int columnIndex;
        int item;
        this.setValue(null, rowKey, columnKey);
        boolean allNull = true;
        int rowIndex = this.getRowIndex(rowKey);
        DefaultKeyedValues<C> row = this.rows.get(rowIndex);
        int itemCount = row.getItemCount();
        for (item = 0; item < itemCount; ++item) {
            if (row.getValue(item) == null) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            this.rowKeys.remove(rowIndex);
            this.rows.remove(rowIndex);
        }
        allNull = true;
        itemCount = this.rows.size();
        for (item = 0; item < itemCount; ++item) {
            row = this.rows.get(item);
            columnIndex = row.getIndex(columnKey);
            if (columnIndex < 0 || row.getValue(columnIndex) == null) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            itemCount = this.rows.size();
            for (item = 0; item < itemCount; ++item) {
                row = this.rows.get(item);
                columnIndex = row.getIndex(columnKey);
                if (columnIndex < 0) continue;
                row.removeValue(columnIndex);
            }
            this.columnKeys.remove(columnKey);
        }
    }

    public void removeRow(int rowIndex) {
        this.rowKeys.remove(rowIndex);
        this.rows.remove(rowIndex);
    }

    public void removeRow(R rowKey) {
        Args.nullNotPermitted(rowKey, "rowKey");
        int index = this.getRowIndex(rowKey);
        if (index < 0) {
            throw new UnknownKeyException("Unknown key: " + rowKey);
        }
        this.removeRow(index);
    }

    public void removeColumn(int columnIndex) {
        C columnKey = this.getColumnKey(columnIndex);
        this.removeColumn(columnKey);
    }

    public void removeColumn(C columnKey) {
        Args.nullNotPermitted(columnKey, "columnKey");
        if (!this.columnKeys.contains(columnKey)) {
            throw new UnknownKeyException("Unknown key: " + columnKey);
        }
        for (DefaultKeyedValues<C> rowData : this.rows) {
            int index = rowData.getIndex(columnKey);
            if (index < 0) continue;
            rowData.removeValue(columnKey);
        }
        this.columnKeys.remove(columnKey);
    }

    public void clear() {
        this.rowKeys.clear();
        this.columnKeys.clear();
        this.rows.clear();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyedValues2D)) {
            return false;
        }
        KeyedValues2D kv2D = (KeyedValues2D)o;
        if (!this.getRowKeys().equals(kv2D.getRowKeys())) {
            return false;
        }
        if (!this.getColumnKeys().equals(kv2D.getColumnKeys())) {
            return false;
        }
        int rowCount = this.getRowCount();
        if (rowCount != kv2D.getRowCount()) {
            return false;
        }
        int colCount = this.getColumnCount();
        if (colCount != kv2D.getColumnCount()) {
            return false;
        }
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < colCount; ++c) {
                Number v1 = this.getValue(r, c);
                Number v2 = kv2D.getValue(r, c);
                if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.rowKeys.hashCode();
        result = 29 * result + this.columnKeys.hashCode();
        result = 29 * result + this.rows.hashCode();
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultKeyedValues2D clone = (DefaultKeyedValues2D)super.clone();
        clone.columnKeys = new ArrayList<C>(this.columnKeys);
        clone.rowKeys = new ArrayList<R>(this.rowKeys);
        clone.rows = CloneUtils.cloneList(this.rows);
        return clone;
    }
}

