/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.chart.api.SortOrder;
import org.jfree.chart.internal.Args;
import org.jfree.data.DefaultKeyedValue;
import org.jfree.data.KeyedValueComparator;
import org.jfree.data.KeyedValueComparatorType;
import org.jfree.data.KeyedValues;
import org.jfree.data.UnknownKeyException;

public class DefaultKeyedValues<K extends Comparable<K>>
implements KeyedValues<K>,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 8468154364608194797L;
    private List<K> keys = new ArrayList<K>();
    private List<Number> values = new ArrayList<Number>();
    private Map<K, Integer> indexMap = new HashMap<K, Integer>();

    @Override
    public int getItemCount() {
        return this.indexMap.size();
    }

    @Override
    public Number getValue(int item) {
        return this.values.get(item);
    }

    @Override
    public K getKey(int index) {
        return (K)((Comparable)this.keys.get(index));
    }

    @Override
    public int getIndex(K key) {
        Args.nullNotPermitted(key, "key");
        Integer i = this.indexMap.get(key);
        if (i == null) {
            return -1;
        }
        return i;
    }

    @Override
    public List<K> getKeys() {
        return new ArrayList<K>(this.keys);
    }

    @Override
    public Number getValue(K key) {
        int index = this.getIndex(key);
        if (index < 0) {
            throw new UnknownKeyException("Key not found: " + key);
        }
        return this.getValue(index);
    }

    public void addValue(K key, double value) {
        this.addValue(key, (Number)value);
    }

    public void addValue(K key, Number value) {
        this.setValue(key, value);
    }

    public void setValue(K key, double value) {
        this.setValue(key, (Number)value);
    }

    public void setValue(K key, Number value) {
        Args.nullNotPermitted(key, "key");
        int keyIndex = this.getIndex(key);
        if (keyIndex >= 0) {
            this.keys.set(keyIndex, key);
            this.values.set(keyIndex, value);
        } else {
            this.keys.add(key);
            this.values.add(value);
            this.indexMap.put(key, this.keys.size() - 1);
        }
    }

    public void insertValue(int position, K key, double value) {
        this.insertValue(position, key, (Number)value);
    }

    public void insertValue(int position, K key, Number value) {
        if (position < 0 || position > this.getItemCount()) {
            throw new IllegalArgumentException("'position' out of bounds.");
        }
        Args.nullNotPermitted(key, "key");
        int pos = this.getIndex(key);
        if (pos == position) {
            this.keys.set(pos, key);
            this.values.set(pos, value);
        } else {
            if (pos >= 0) {
                this.keys.remove(pos);
                this.values.remove(pos);
            }
            this.keys.add(position, key);
            this.values.add(position, value);
            this.rebuildIndex();
        }
    }

    private void rebuildIndex() {
        this.indexMap.clear();
        for (int i = 0; i < this.keys.size(); ++i) {
            Comparable key = (Comparable)this.keys.get(i);
            this.indexMap.put(key, i);
        }
    }

    public void removeValue(int index) {
        this.keys.remove(index);
        this.values.remove(index);
        this.rebuildIndex();
    }

    public void removeValue(K key) {
        int index = this.getIndex(key);
        if (index < 0) {
            throw new UnknownKeyException("The key (" + key + ") is not recognised.");
        }
        this.removeValue(index);
    }

    public void clear() {
        this.keys.clear();
        this.values.clear();
        this.indexMap.clear();
    }

    public void sortByKeys(SortOrder order) {
        int size = this.keys.size();
        DefaultKeyedValue[] data = new DefaultKeyedValue[size];
        for (int i = 0; i < size; ++i) {
            data[i] = new DefaultKeyedValue<Comparable>((Comparable)this.keys.get(i), this.values.get(i));
        }
        KeyedValueComparator comparator = new KeyedValueComparator(KeyedValueComparatorType.BY_KEY, order);
        Arrays.sort(data, comparator);
        this.clear();
        for (int i = 0; i < data.length; ++i) {
            DefaultKeyedValue value = data[i];
            this.addValue(value.getKey(), value.getValue());
        }
    }

    public void sortByValues(SortOrder order) {
        int size = this.keys.size();
        DefaultKeyedValue[] data = new DefaultKeyedValue[size];
        for (int i = 0; i < size; ++i) {
            data[i] = new DefaultKeyedValue<Comparable>((Comparable)this.keys.get(i), this.values.get(i));
        }
        KeyedValueComparator comparator = new KeyedValueComparator(KeyedValueComparatorType.BY_VALUE, order);
        Arrays.sort(data, comparator);
        this.clear();
        for (int i = 0; i < data.length; ++i) {
            DefaultKeyedValue value = data[i];
            this.addValue(value.getKey(), value.getValue());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KeyedValues)) {
            return false;
        }
        KeyedValues that = (KeyedValues)obj;
        int count = this.getItemCount();
        if (count != that.getItemCount()) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            Object k2;
            K k1 = this.getKey(i);
            if (!k1.equals(k2 = that.getKey(i))) {
                return false;
            }
            Number v1 = this.getValue(i);
            Number v2 = that.getValue(i);
            if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.keys != null ? this.keys.hashCode() : 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultKeyedValues clone = (DefaultKeyedValues)super.clone();
        clone.keys = new ArrayList<K>(this.keys);
        clone.values = new ArrayList<Number>(this.values);
        clone.indexMap = new HashMap<K, Integer>(this.indexMap);
        return clone;
    }
}

