/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import org.jfree.chart.internal.Args;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.general.PieDataset;

public class StandardPieURLGenerator
implements PieURLGenerator,
Serializable {
    private static final long serialVersionUID = 1626966402065883419L;
    private String prefix = "index.html";
    private String categoryParamName = "category";
    private String indexParamName = "pieIndex";

    public StandardPieURLGenerator() {
        this("index.html");
    }

    public StandardPieURLGenerator(String prefix) {
        this(prefix, "category");
    }

    public StandardPieURLGenerator(String prefix, String categoryParamName) {
        this(prefix, categoryParamName, "pieIndex");
    }

    public StandardPieURLGenerator(String prefix, String categoryParamName, String indexParamName) {
        Args.nullNotPermitted(prefix, "prefix");
        Args.nullNotPermitted(categoryParamName, "categoryParamName");
        this.prefix = prefix;
        this.categoryParamName = categoryParamName;
        this.indexParamName = indexParamName;
    }

    public String generateURL(PieDataset dataset, Comparable key, int pieIndex) {
        Object url = this.prefix;
        try {
            url = ((String)url).contains("?") ? (String)url + "&amp;" + this.categoryParamName + "=" + URLEncoder.encode(key.toString(), "UTF-8") : (String)url + "?" + this.categoryParamName + "=" + URLEncoder.encode(key.toString(), "UTF-8");
            if (this.indexParamName != null) {
                url = (String)url + "&amp;" + this.indexParamName + "=" + pieIndex;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return url;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardPieURLGenerator)) {
            return false;
        }
        StandardPieURLGenerator that = (StandardPieURLGenerator)obj;
        if (!this.prefix.equals(that.prefix)) {
            return false;
        }
        if (!this.categoryParamName.equals(that.categoryParamName)) {
            return false;
        }
        return Objects.equals(this.indexParamName, that.indexParamName);
    }
}

