/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.general.PieDataset;

public class CustomPieURLGenerator
implements PieURLGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 7100607670144900503L;
    private final List<Map<Comparable<?>, String>> urlMaps = new ArrayList();

    @Override
    public String generateURL(PieDataset dataset, Comparable<?> key, int plotIndex) {
        return this.getURL(key, plotIndex);
    }

    public int getListCount() {
        return this.urlMaps.size();
    }

    public int getURLCount(int plotIndex) {
        int result = 0;
        Map<Comparable<?>, String> urlMap = this.urlMaps.get(plotIndex);
        if (urlMap != null) {
            result = urlMap.size();
        }
        return result;
    }

    public String getURL(Comparable<?> key, int plotIndex) {
        Map<Comparable<?>, String> urlMap;
        String result = null;
        if (plotIndex < this.getListCount() && (urlMap = this.urlMaps.get(plotIndex)) != null) {
            result = urlMap.get(key);
        }
        return result;
    }

    public void addURLs(Map urlMap) {
        this.urlMaps.add(urlMap);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomPieURLGenerator) {
            CustomPieURLGenerator generator = (CustomPieURLGenerator)o;
            if (this.getListCount() != generator.getListCount()) {
                return false;
            }
            for (int pieItem = 0; pieItem < this.getListCount(); ++pieItem) {
                if (this.getURLCount(pieItem) != generator.getURLCount(pieItem)) {
                    return false;
                }
                Set<Comparable<?>> keySet = this.urlMaps.get(pieItem).keySet();
                for (String string : keySet) {
                    if (this.getURL((Comparable<?>)((Object)string), pieItem).equals(generator.getURL((Comparable<?>)((Object)string), pieItem))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CustomPieURLGenerator urlGen = new CustomPieURLGenerator();
        for (Map<Comparable<?>, String> map : this.urlMaps) {
            HashMap<String, String> newMap = new HashMap<String, String>();
            for (String string : map.keySet()) {
                newMap.put(string, map.get(string));
            }
            urlGen.addURLs(newMap);
        }
        return urlGen;
    }
}

