/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.internal.SerialUtils;
import org.jfree.chart.swing.SelectionZoomStrategy;

public class DefaultSelectionZoomStrategy
implements SelectionZoomStrategy {
    private static final long serialVersionUID = -8042265475645652131L;
    public static final int DEFAULT_ZOOM_TRIGGER_DISTANCE = 10;
    protected Point2D zoomPoint = null;
    protected transient Rectangle2D zoomRectangle = null;
    private boolean fillZoomRectangle = true;
    private int zoomTriggerDistance = 10;
    private transient Paint zoomOutlinePaint = Color.BLUE;
    private transient Paint zoomFillPaint = new Color(0, 0, 255, 63);

    @Override
    public boolean isActivated() {
        return this.zoomRectangle != null;
    }

    @Override
    public Point2D getZoomPoint() {
        return this.zoomPoint;
    }

    @Override
    public void setZoomPoint(Point2D zoomPoint) {
        this.zoomPoint = zoomPoint;
    }

    @Override
    public void setZoomTriggerDistance(int distance) {
        this.zoomTriggerDistance = distance;
    }

    @Override
    public int getZoomTriggerDistance() {
        return this.zoomTriggerDistance;
    }

    @Override
    public Paint getZoomOutlinePaint() {
        return this.zoomOutlinePaint;
    }

    @Override
    public void setZoomOutlinePaint(Paint paint) {
        this.zoomOutlinePaint = paint;
    }

    @Override
    public Paint getZoomFillPaint() {
        return this.zoomFillPaint;
    }

    @Override
    public void setZoomFillPaint(Paint paint) {
        this.zoomFillPaint = paint;
    }

    @Override
    public boolean getFillZoomRectangle() {
        return this.fillZoomRectangle;
    }

    @Override
    public void setFillZoomRectangle(boolean flag) {
        this.fillZoomRectangle = flag;
    }

    @Override
    public void updateZoomRectangleSelection(MouseEvent e, boolean hZoom, boolean vZoom, Rectangle2D scaledDataArea) {
        if (hZoom && vZoom) {
            double xMax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
            double yMax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), xMax - this.zoomPoint.getX(), yMax - this.zoomPoint.getY());
        } else if (hZoom) {
            double xMax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), scaledDataArea.getMinY(), xMax - this.zoomPoint.getX(), scaledDataArea.getHeight());
        } else if (vZoom) {
            double yMax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(scaledDataArea.getMinX(), this.zoomPoint.getY(), scaledDataArea.getWidth(), yMax - this.zoomPoint.getY());
        }
    }

    @Override
    public Rectangle2D getZoomRectangle(boolean hZoom, boolean vZoom, Rectangle2D screenDataArea) {
        double h;
        double w;
        double y;
        double x;
        double maxX = screenDataArea.getMaxX();
        double maxY = screenDataArea.getMaxY();
        if (!vZoom) {
            x = this.zoomPoint.getX();
            y = screenDataArea.getMinY();
            w = Math.min(this.zoomRectangle.getWidth(), maxX - this.zoomPoint.getX());
            h = screenDataArea.getHeight();
        } else if (!hZoom) {
            x = screenDataArea.getMinX();
            y = this.zoomPoint.getY();
            w = screenDataArea.getWidth();
            h = Math.min(this.zoomRectangle.getHeight(), maxY - this.zoomPoint.getY());
        } else {
            x = this.zoomPoint.getX();
            y = this.zoomPoint.getY();
            w = Math.min(this.zoomRectangle.getWidth(), maxX - this.zoomPoint.getX());
            h = Math.min(this.zoomRectangle.getHeight(), maxY - this.zoomPoint.getY());
        }
        return new Rectangle2D.Double(x, y, w, h);
    }

    @Override
    public void reset() {
        this.zoomPoint = null;
        this.zoomRectangle = null;
    }

    @Override
    public void drawZoomRectangle(Graphics2D g2, boolean xor) {
        if (this.zoomRectangle != null) {
            if (xor) {
                g2.setXORMode(Color.GRAY);
            }
            if (this.fillZoomRectangle) {
                g2.setPaint(this.zoomFillPaint);
                g2.fill(this.zoomRectangle);
            } else {
                g2.setPaint(this.zoomOutlinePaint);
                g2.draw(this.zoomRectangle);
            }
            if (xor) {
                g2.setPaintMode();
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writePaint(this.zoomFillPaint, stream);
        SerialUtils.writePaint(this.zoomOutlinePaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.zoomFillPaint = SerialUtils.readPaint(stream);
        this.zoomOutlinePaint = SerialUtils.readPaint(stream);
    }
}

