/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.swing;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.chart.api.RectangleAnchor;
import org.jfree.chart.api.RectangleEdge;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.internal.Args;
import org.jfree.chart.internal.CloneUtils;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.swing.AbstractOverlay;
import org.jfree.chart.swing.ChartPanel;
import org.jfree.chart.swing.Overlay;
import org.jfree.chart.text.TextAnchor;
import org.jfree.chart.text.TextUtils;

public class CrosshairOverlay
extends AbstractOverlay
implements Overlay,
PropertyChangeListener,
PublicCloneable,
Cloneable,
Serializable {
    protected List<Crosshair> xCrosshairs = new ArrayList<Crosshair>();
    protected List<Crosshair> yCrosshairs = new ArrayList<Crosshair>();

    public void addDomainCrosshair(Crosshair crosshair) {
        Args.nullNotPermitted(crosshair, "crosshair");
        this.xCrosshairs.add(crosshair);
        crosshair.addPropertyChangeListener(this);
        this.fireOverlayChanged();
    }

    public void removeDomainCrosshair(Crosshair crosshair) {
        Args.nullNotPermitted(crosshair, "crosshair");
        if (this.xCrosshairs.remove(crosshair)) {
            crosshair.removePropertyChangeListener(this);
            this.fireOverlayChanged();
        }
    }

    public void clearDomainCrosshairs() {
        if (this.xCrosshairs.isEmpty()) {
            return;
        }
        for (Crosshair c : this.getDomainCrosshairs()) {
            this.xCrosshairs.remove(c);
            c.removePropertyChangeListener(this);
        }
        this.fireOverlayChanged();
    }

    public List<Crosshair> getDomainCrosshairs() {
        return new ArrayList<Crosshair>(this.xCrosshairs);
    }

    public void addRangeCrosshair(Crosshair crosshair) {
        Args.nullNotPermitted(crosshair, "crosshair");
        this.yCrosshairs.add(crosshair);
        crosshair.addPropertyChangeListener(this);
        this.fireOverlayChanged();
    }

    public void removeRangeCrosshair(Crosshair crosshair) {
        Args.nullNotPermitted(crosshair, "crosshair");
        if (this.yCrosshairs.remove(crosshair)) {
            crosshair.removePropertyChangeListener(this);
            this.fireOverlayChanged();
        }
    }

    public void clearRangeCrosshairs() {
        if (this.yCrosshairs.isEmpty()) {
            return;
        }
        for (Crosshair c : this.getRangeCrosshairs()) {
            this.yCrosshairs.remove(c);
            c.removePropertyChangeListener(this);
        }
        this.fireOverlayChanged();
    }

    public List<Crosshair> getRangeCrosshairs() {
        return new ArrayList<Crosshair>(this.yCrosshairs);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.fireOverlayChanged();
    }

    @Override
    public void paintOverlay(Graphics2D g2, ChartPanel chartPanel) {
        Shape savedClip = g2.getClip();
        Rectangle2D dataArea = chartPanel.getScreenDataArea();
        g2.clip(dataArea);
        JFreeChart chart = chartPanel.getChart();
        XYPlot plot = (XYPlot)chart.getPlot();
        ValueAxis xAxis = plot.getDomainAxis();
        RectangleEdge xAxisEdge = plot.getDomainAxisEdge();
        for (Crosshair ch : this.getDomainCrosshairs()) {
            if (!ch.isVisible()) continue;
            double x = ch.getValue();
            double xx = xAxis.valueToJava2D(x, dataArea, xAxisEdge);
            if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawVerticalCrosshair(g2, dataArea, xx, ch);
                continue;
            }
            this.drawHorizontalCrosshair(g2, dataArea, xx, ch);
        }
        ValueAxis yAxis = plot.getRangeAxis();
        RectangleEdge yAxisEdge = plot.getRangeAxisEdge();
        for (Crosshair ch : this.getRangeCrosshairs()) {
            if (!ch.isVisible()) continue;
            double y = ch.getValue();
            double yy = yAxis.valueToJava2D(y, dataArea, yAxisEdge);
            if (plot.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawHorizontalCrosshair(g2, dataArea, yy, ch);
                continue;
            }
            this.drawVerticalCrosshair(g2, dataArea, yy, ch);
        }
        g2.setClip(savedClip);
    }

    protected void drawHorizontalCrosshair(Graphics2D g2, Rectangle2D dataArea, double y, Crosshair crosshair) {
        if (y >= dataArea.getMinY() && y <= dataArea.getMaxY()) {
            String label;
            Line2D.Double line = new Line2D.Double(dataArea.getMinX(), y, dataArea.getMaxX(), y);
            Paint savedPaint = g2.getPaint();
            Stroke savedStroke = g2.getStroke();
            g2.setPaint(crosshair.getPaint());
            g2.setStroke(crosshair.getStroke());
            g2.draw(line);
            if (crosshair.isLabelVisible() && (label = crosshair.getLabelGenerator().generateLabel(crosshair)) != null && !label.isEmpty()) {
                Font savedFont = g2.getFont();
                g2.setFont(crosshair.getLabelFont());
                RectangleAnchor anchor = crosshair.getLabelAnchor();
                Point2D pt = this.calculateLabelPoint(line, anchor, crosshair.getLabelXOffset(), crosshair.getLabelYOffset());
                float xx = (float)pt.getX();
                float yy = (float)pt.getY();
                TextAnchor alignPt = this.textAlignPtForLabelAnchorH(anchor);
                Shape hotspot = TextUtils.calculateRotatedStringBounds(label, g2, xx, yy, alignPt, 0.0, TextAnchor.CENTER);
                if (!dataArea.contains(hotspot.getBounds2D())) {
                    anchor = this.flipAnchorV(anchor);
                    pt = this.calculateLabelPoint(line, anchor, crosshair.getLabelXOffset(), crosshair.getLabelYOffset());
                    xx = (float)pt.getX();
                    yy = (float)pt.getY();
                    alignPt = this.textAlignPtForLabelAnchorH(anchor);
                    hotspot = TextUtils.calculateRotatedStringBounds(label, g2, xx, yy, alignPt, 0.0, TextAnchor.CENTER);
                }
                g2.setPaint(crosshair.getLabelBackgroundPaint());
                g2.fill(hotspot);
                if (crosshair.isLabelOutlineVisible()) {
                    g2.setPaint(crosshair.getLabelOutlinePaint());
                    g2.setStroke(crosshair.getLabelOutlineStroke());
                    g2.draw(hotspot);
                }
                g2.setPaint(crosshair.getLabelPaint());
                TextUtils.drawAlignedString(label, g2, xx, yy, alignPt);
                g2.setFont(savedFont);
            }
            g2.setPaint(savedPaint);
            g2.setStroke(savedStroke);
        }
    }

    protected void drawVerticalCrosshair(Graphics2D g2, Rectangle2D dataArea, double x, Crosshair crosshair) {
        if (x >= dataArea.getMinX() && x <= dataArea.getMaxX()) {
            String label;
            Line2D.Double line = new Line2D.Double(x, dataArea.getMinY(), x, dataArea.getMaxY());
            Paint savedPaint = g2.getPaint();
            Stroke savedStroke = g2.getStroke();
            g2.setPaint(crosshair.getPaint());
            g2.setStroke(crosshair.getStroke());
            g2.draw(line);
            if (crosshair.isLabelVisible() && (label = crosshair.getLabelGenerator().generateLabel(crosshair)) != null && !label.isEmpty()) {
                Font savedFont = g2.getFont();
                g2.setFont(crosshair.getLabelFont());
                RectangleAnchor anchor = crosshair.getLabelAnchor();
                Point2D pt = this.calculateLabelPoint(line, anchor, crosshair.getLabelXOffset(), crosshair.getLabelYOffset());
                float xx = (float)pt.getX();
                float yy = (float)pt.getY();
                TextAnchor alignPt = this.textAlignPtForLabelAnchorV(anchor);
                Shape hotspot = TextUtils.calculateRotatedStringBounds(label, g2, xx, yy, alignPt, 0.0, TextAnchor.CENTER);
                if (!dataArea.contains(hotspot.getBounds2D())) {
                    anchor = this.flipAnchorH(anchor);
                    pt = this.calculateLabelPoint(line, anchor, crosshair.getLabelXOffset(), crosshair.getLabelYOffset());
                    xx = (float)pt.getX();
                    yy = (float)pt.getY();
                    alignPt = this.textAlignPtForLabelAnchorV(anchor);
                    hotspot = TextUtils.calculateRotatedStringBounds(label, g2, xx, yy, alignPt, 0.0, TextAnchor.CENTER);
                }
                g2.setPaint(crosshair.getLabelBackgroundPaint());
                g2.fill(hotspot);
                if (crosshair.isLabelOutlineVisible()) {
                    g2.setPaint(crosshair.getLabelOutlinePaint());
                    g2.setStroke(crosshair.getLabelOutlineStroke());
                    g2.draw(hotspot);
                }
                g2.setPaint(crosshair.getLabelPaint());
                TextUtils.drawAlignedString(label, g2, xx, yy, alignPt);
                g2.setFont(savedFont);
            }
            g2.setPaint(savedPaint);
            g2.setStroke(savedStroke);
        }
    }

    private Point2D calculateLabelPoint(Line2D line, RectangleAnchor anchor, double deltaX, double deltaY) {
        double y;
        double x;
        boolean left = anchor == RectangleAnchor.BOTTOM_LEFT || anchor == RectangleAnchor.LEFT || anchor == RectangleAnchor.TOP_LEFT;
        boolean right = anchor == RectangleAnchor.BOTTOM_RIGHT || anchor == RectangleAnchor.RIGHT || anchor == RectangleAnchor.TOP_RIGHT;
        boolean top = anchor == RectangleAnchor.TOP_LEFT || anchor == RectangleAnchor.TOP || anchor == RectangleAnchor.TOP_RIGHT;
        boolean bottom = anchor == RectangleAnchor.BOTTOM_LEFT || anchor == RectangleAnchor.BOTTOM || anchor == RectangleAnchor.BOTTOM_RIGHT;
        Rectangle rect = line.getBounds();
        if (line.getX1() == line.getX2()) {
            x = line.getX1();
            y = (line.getY1() + line.getY2()) / 2.0;
            if (left) {
                x -= deltaX;
            }
            if (right) {
                x += deltaX;
            }
            if (top) {
                y = Math.min(line.getY1(), line.getY2()) + deltaY;
            }
            if (bottom) {
                y = Math.max(line.getY1(), line.getY2()) - deltaY;
            }
        } else {
            x = (line.getX1() + line.getX2()) / 2.0;
            y = line.getY1();
            if (left) {
                x = Math.min(line.getX1(), line.getX2()) + deltaX;
            }
            if (right) {
                x = Math.max(line.getX1(), line.getX2()) - deltaX;
            }
            if (top) {
                y -= deltaY;
            }
            if (bottom) {
                y += deltaY;
            }
        }
        return new Point2D.Double(x, y);
    }

    private TextAnchor textAlignPtForLabelAnchorV(RectangleAnchor anchor) {
        TextAnchor result = TextAnchor.CENTER;
        if (anchor.equals((Object)RectangleAnchor.TOP_LEFT)) {
            result = TextAnchor.TOP_RIGHT;
        } else if (anchor.equals((Object)RectangleAnchor.TOP)) {
            result = TextAnchor.TOP_CENTER;
        } else if (anchor.equals((Object)RectangleAnchor.TOP_RIGHT)) {
            result = TextAnchor.TOP_LEFT;
        } else if (anchor.equals((Object)RectangleAnchor.LEFT)) {
            result = TextAnchor.HALF_ASCENT_RIGHT;
        } else if (anchor.equals((Object)RectangleAnchor.RIGHT)) {
            result = TextAnchor.HALF_ASCENT_LEFT;
        } else if (anchor.equals((Object)RectangleAnchor.BOTTOM_LEFT)) {
            result = TextAnchor.BOTTOM_RIGHT;
        } else if (anchor.equals((Object)RectangleAnchor.BOTTOM)) {
            result = TextAnchor.BOTTOM_CENTER;
        } else if (anchor.equals((Object)RectangleAnchor.BOTTOM_RIGHT)) {
            result = TextAnchor.BOTTOM_LEFT;
        }
        return result;
    }

    private TextAnchor textAlignPtForLabelAnchorH(RectangleAnchor anchor) {
        TextAnchor result = TextAnchor.CENTER;
        if (anchor.equals((Object)RectangleAnchor.TOP_LEFT)) {
            result = TextAnchor.BOTTOM_LEFT;
        } else if (anchor.equals((Object)RectangleAnchor.TOP)) {
            result = TextAnchor.BOTTOM_CENTER;
        } else if (anchor.equals((Object)RectangleAnchor.TOP_RIGHT)) {
            result = TextAnchor.BOTTOM_RIGHT;
        } else if (anchor.equals((Object)RectangleAnchor.LEFT)) {
            result = TextAnchor.HALF_ASCENT_LEFT;
        } else if (anchor.equals((Object)RectangleAnchor.RIGHT)) {
            result = TextAnchor.HALF_ASCENT_RIGHT;
        } else if (anchor.equals((Object)RectangleAnchor.BOTTOM_LEFT)) {
            result = TextAnchor.TOP_LEFT;
        } else if (anchor.equals((Object)RectangleAnchor.BOTTOM)) {
            result = TextAnchor.TOP_CENTER;
        } else if (anchor.equals((Object)RectangleAnchor.BOTTOM_RIGHT)) {
            result = TextAnchor.TOP_RIGHT;
        }
        return result;
    }

    private RectangleAnchor flipAnchorH(RectangleAnchor anchor) {
        RectangleAnchor result = anchor;
        if (anchor.equals((Object)RectangleAnchor.TOP_LEFT)) {
            result = RectangleAnchor.TOP_RIGHT;
        } else if (anchor.equals((Object)RectangleAnchor.TOP_RIGHT)) {
            result = RectangleAnchor.TOP_LEFT;
        } else if (anchor.equals((Object)RectangleAnchor.LEFT)) {
            result = RectangleAnchor.RIGHT;
        } else if (anchor.equals((Object)RectangleAnchor.RIGHT)) {
            result = RectangleAnchor.LEFT;
        } else if (anchor.equals((Object)RectangleAnchor.BOTTOM_LEFT)) {
            result = RectangleAnchor.BOTTOM_RIGHT;
        } else if (anchor.equals((Object)RectangleAnchor.BOTTOM_RIGHT)) {
            result = RectangleAnchor.BOTTOM_LEFT;
        }
        return result;
    }

    private RectangleAnchor flipAnchorV(RectangleAnchor anchor) {
        RectangleAnchor result = anchor;
        if (anchor.equals((Object)RectangleAnchor.TOP_LEFT)) {
            result = RectangleAnchor.BOTTOM_LEFT;
        } else if (anchor.equals((Object)RectangleAnchor.TOP_RIGHT)) {
            result = RectangleAnchor.BOTTOM_RIGHT;
        } else if (anchor.equals((Object)RectangleAnchor.TOP)) {
            result = RectangleAnchor.BOTTOM;
        } else if (anchor.equals((Object)RectangleAnchor.BOTTOM)) {
            result = RectangleAnchor.TOP;
        } else if (anchor.equals((Object)RectangleAnchor.BOTTOM_LEFT)) {
            result = RectangleAnchor.TOP_LEFT;
        } else if (anchor.equals((Object)RectangleAnchor.BOTTOM_RIGHT)) {
            result = RectangleAnchor.TOP_RIGHT;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CrosshairOverlay)) {
            return false;
        }
        CrosshairOverlay that = (CrosshairOverlay)obj;
        if (!this.xCrosshairs.equals(that.xCrosshairs)) {
            return false;
        }
        return this.yCrosshairs.equals(that.yCrosshairs);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CrosshairOverlay clone = (CrosshairOverlay)super.clone();
        clone.xCrosshairs = CloneUtils.cloneList(this.xCrosshairs);
        clone.yCrosshairs = CloneUtils.cloneList(this.yCrosshairs);
        return clone;
    }
}

