/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.swing;

import javax.swing.event.EventListenerList;
import org.jfree.chart.internal.Args;
import org.jfree.chart.swing.OverlayChangeEvent;
import org.jfree.chart.swing.OverlayChangeListener;

public class AbstractOverlay {
    private final transient EventListenerList changeListeners = new EventListenerList();

    public void addChangeListener(OverlayChangeListener listener) {
        Args.nullNotPermitted(listener, "listener");
        this.changeListeners.add(OverlayChangeListener.class, listener);
    }

    public void removeChangeListener(OverlayChangeListener listener) {
        Args.nullNotPermitted(listener, "listener");
        this.changeListeners.remove(OverlayChangeListener.class, listener);
    }

    public void fireOverlayChanged() {
        OverlayChangeEvent event = new OverlayChangeEvent(this);
        this.notifyListeners(event);
    }

    protected void notifyListeners(OverlayChangeEvent event) {
        Object[] listeners = this.changeListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != OverlayChangeListener.class) continue;
            ((OverlayChangeListener)listeners[i + 1]).overlayChanged(event);
        }
    }
}

