/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.event.EventListenerList;
import org.jfree.chart.ChartElement;
import org.jfree.chart.ChartElementVisitor;
import org.jfree.chart.ChartHints;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.internal.Args;
import org.jfree.chart.internal.CloneUtils;
import org.jfree.chart.internal.HashUtils;
import org.jfree.chart.internal.PaintUtils;
import org.jfree.chart.internal.SerialUtils;
import org.jfree.chart.internal.ShapeUtils;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.text.TextAnchor;
import org.jfree.data.ItemKey;

public abstract class AbstractRenderer
implements ChartElement,
Cloneable,
Serializable {
    private static final long serialVersionUID = -828267569428206075L;
    public static final Double ZERO = 0.0;
    public static final Paint DEFAULT_PAINT = Color.BLUE;
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.GRAY;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    public static final Shape DEFAULT_SHAPE = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_VALUE_LABEL_PAINT = Color.BLACK;
    private Map<Integer, Boolean> seriesVisibleMap = new HashMap<Integer, Boolean>();
    private boolean defaultSeriesVisible = true;
    private Map<Integer, Boolean> seriesVisibleInLegendMap = new HashMap<Integer, Boolean>();
    private boolean defaultSeriesVisibleInLegend = true;
    private transient Map<Integer, Paint> seriesPaintMap = new HashMap<Integer, Paint>();
    private boolean autoPopulateSeriesPaint = true;
    private transient Paint defaultPaint = DEFAULT_PAINT;
    private transient Map<Integer, Paint> seriesFillPaintMap = new HashMap<Integer, Paint>();
    private boolean autoPopulateSeriesFillPaint = false;
    private transient Paint defaultFillPaint = Color.WHITE;
    private transient Map<Integer, Paint> seriesOutlinePaintMap = new HashMap<Integer, Paint>();
    private boolean autoPopulateSeriesOutlinePaint = false;
    private transient Paint defaultOutlinePaint = DEFAULT_OUTLINE_PAINT;
    private transient Map<Integer, Stroke> seriesStrokeMap = new HashMap<Integer, Stroke>();
    private boolean autoPopulateSeriesStroke = true;
    private transient Stroke defaultStroke = DEFAULT_STROKE;
    private transient Map<Integer, Stroke> seriesOutlineStrokeMap = new HashMap<Integer, Stroke>();
    private transient Stroke defaultOutlineStroke = DEFAULT_OUTLINE_STROKE;
    private boolean autoPopulateSeriesOutlineStroke = false;
    private Map<Integer, Shape> seriesShapeMap = new HashMap<Integer, Shape>();
    private boolean autoPopulateSeriesShape = true;
    private transient Shape defaultShape = DEFAULT_SHAPE;
    private Map<Integer, Boolean> seriesItemLabelsVisibleMap = new HashMap<Integer, Boolean>();
    private boolean defaultItemLabelsVisible = false;
    private Map<Integer, Font> itemLabelFontMap = new HashMap<Integer, Font>();
    private Font defaultItemLabelFont = new Font("SansSerif", 0, 10);
    private transient Map<Integer, Paint> itemLabelPaints = new HashMap<Integer, Paint>();
    private transient Paint defaultItemLabelPaint = Color.BLACK;
    private Map<Integer, ItemLabelPosition> positiveItemLabelPositionMap = new HashMap<Integer, ItemLabelPosition>();
    private ItemLabelPosition defaultPositiveItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
    private Map<Integer, ItemLabelPosition> negativeItemLabelPositionMap = new HashMap<Integer, ItemLabelPosition>();
    private ItemLabelPosition defaultNegativeItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
    private double itemLabelAnchorOffset = 2.0;
    private Map<Integer, Boolean> seriesCreateEntitiesMap = new HashMap<Integer, Boolean>();
    private boolean defaultCreateEntities = true;
    private Map<Integer, Shape> seriesLegendShapes = new HashMap<Integer, Shape>();
    private transient Shape defaultLegendShape = null;
    private boolean treatLegendShapeAsLine = false;
    private Map<Integer, Font> legendTextFontMap = new HashMap<Integer, Font>();
    private Font defaultLegendTextFont = null;
    private transient Map<Integer, Paint> legendTextPaints = new HashMap<Integer, Paint>();
    private transient Paint defaultLegendTextPaint = null;
    private boolean dataBoundsIncludesVisibleSeriesOnly = true;
    private int defaultEntityRadius = 3;
    private transient EventListenerList listenerList = new EventListenerList();
    private transient RendererChangeEvent event;
    private static final double ADJ = Math.cos(0.5235987755982988);
    private static final double OPP = Math.sin(0.5235987755982988);

    @Override
    public void receive(ChartElementVisitor visitor) {
        visitor.visit(this);
    }

    public abstract DrawingSupplier getDrawingSupplier();

    protected void beginElementGroup(Graphics2D g2, ItemKey key) {
        Args.nullNotPermitted(key, "key");
        HashMap<String, String> m = new HashMap<String, String>(1);
        m.put("ref", key.toJSONString());
        g2.setRenderingHint(ChartHints.KEY_BEGIN_ELEMENT, m);
    }

    protected void endElementGroup(Graphics2D g2) {
        g2.setRenderingHint(ChartHints.KEY_END_ELEMENT, Boolean.TRUE);
    }

    public boolean getItemVisible(int series, int item) {
        return this.isSeriesVisible(series);
    }

    public boolean isSeriesVisible(int series) {
        boolean result = this.defaultSeriesVisible;
        Boolean b = this.seriesVisibleMap.get(series);
        if (b != null) {
            result = b;
        }
        return result;
    }

    public Boolean getSeriesVisible(int series) {
        return this.seriesVisibleMap.get(series);
    }

    public void setSeriesVisible(int series, Boolean visible) {
        this.setSeriesVisible(series, visible, true);
    }

    public void setSeriesVisible(int series, Boolean visible, boolean notify) {
        this.seriesVisibleMap.put(series, visible);
        if (notify) {
            RendererChangeEvent e = new RendererChangeEvent((Object)this, true);
            this.notifyListeners(e);
        }
    }

    public boolean getDefaultSeriesVisible() {
        return this.defaultSeriesVisible;
    }

    public void setDefaultSeriesVisible(boolean visible) {
        this.setDefaultSeriesVisible(visible, true);
    }

    public void setDefaultSeriesVisible(boolean visible, boolean notify) {
        this.defaultSeriesVisible = visible;
        if (notify) {
            RendererChangeEvent e = new RendererChangeEvent((Object)this, true);
            this.notifyListeners(e);
        }
    }

    public boolean isSeriesVisibleInLegend(int series) {
        boolean result = this.defaultSeriesVisibleInLegend;
        Boolean b = this.seriesVisibleInLegendMap.get(series);
        if (b != null) {
            result = b;
        }
        return result;
    }

    public Boolean getSeriesVisibleInLegend(int series) {
        return this.seriesVisibleInLegendMap.get(series);
    }

    public void setSeriesVisibleInLegend(int series, Boolean visible) {
        this.setSeriesVisibleInLegend(series, visible, true);
    }

    public void setSeriesVisibleInLegend(int series, Boolean visible, boolean notify) {
        this.seriesVisibleInLegendMap.put(series, visible);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean getDefaultSeriesVisibleInLegend() {
        return this.defaultSeriesVisibleInLegend;
    }

    public void setDefaultSeriesVisibleInLegend(boolean visible) {
        this.setDefaultSeriesVisibleInLegend(visible, true);
    }

    public void setDefaultSeriesVisibleInLegend(boolean visible, boolean notify) {
        this.defaultSeriesVisibleInLegend = visible;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Paint getItemPaint(int row, int column) {
        return this.lookupSeriesPaint(row);
    }

    public Paint lookupSeriesPaint(int series) {
        DrawingSupplier supplier;
        Paint seriesPaint = this.getSeriesPaint(series);
        if (seriesPaint == null && this.autoPopulateSeriesPaint && (supplier = this.getDrawingSupplier()) != null) {
            seriesPaint = supplier.getNextPaint();
            this.setSeriesPaint(series, seriesPaint, false);
        }
        if (seriesPaint == null) {
            seriesPaint = this.defaultPaint;
        }
        return seriesPaint;
    }

    public Paint getSeriesPaint(int series) {
        return this.seriesPaintMap.get(series);
    }

    public void setSeriesPaint(int series, Paint paint) {
        this.setSeriesPaint(series, paint, true);
    }

    public void setSeriesPaint(int series, Paint paint, boolean notify) {
        this.seriesPaintMap.put(series, paint);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public void clearSeriesPaints(boolean notify) {
        this.seriesPaintMap.clear();
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Paint getDefaultPaint() {
        return this.defaultPaint;
    }

    public void setDefaultPaint(Paint paint) {
        this.setDefaultPaint(paint, true);
    }

    public void setDefaultPaint(Paint paint, boolean notify) {
        this.defaultPaint = paint;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesPaint() {
        return this.autoPopulateSeriesPaint;
    }

    public void setAutoPopulateSeriesPaint(boolean auto) {
        this.autoPopulateSeriesPaint = auto;
    }

    public Paint getItemFillPaint(int row, int column) {
        return this.lookupSeriesFillPaint(row);
    }

    public Paint lookupSeriesFillPaint(int series) {
        DrawingSupplier supplier;
        Paint seriesFillPaint = this.getSeriesFillPaint(series);
        if (seriesFillPaint == null && this.autoPopulateSeriesFillPaint && (supplier = this.getDrawingSupplier()) != null) {
            seriesFillPaint = supplier.getNextFillPaint();
            this.setSeriesFillPaint(series, seriesFillPaint, false);
        }
        if (seriesFillPaint == null) {
            seriesFillPaint = this.defaultFillPaint;
        }
        return seriesFillPaint;
    }

    public Paint getSeriesFillPaint(int series) {
        return this.seriesFillPaintMap.get(series);
    }

    public void setSeriesFillPaint(int series, Paint paint) {
        this.setSeriesFillPaint(series, paint, true);
    }

    public void setSeriesFillPaint(int series, Paint paint, boolean notify) {
        this.seriesFillPaintMap.put(series, paint);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Paint getDefaultFillPaint() {
        return this.defaultFillPaint;
    }

    public void setDefaultFillPaint(Paint paint) {
        this.setDefaultFillPaint(paint, true);
    }

    public void setDefaultFillPaint(Paint paint, boolean notify) {
        Args.nullNotPermitted(paint, "paint");
        this.defaultFillPaint = paint;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesFillPaint() {
        return this.autoPopulateSeriesFillPaint;
    }

    public void setAutoPopulateSeriesFillPaint(boolean auto) {
        this.autoPopulateSeriesFillPaint = auto;
    }

    public Paint getItemOutlinePaint(int row, int column) {
        return this.lookupSeriesOutlinePaint(row);
    }

    public Paint lookupSeriesOutlinePaint(int series) {
        DrawingSupplier supplier;
        Paint seriesOutlinePaint = this.getSeriesOutlinePaint(series);
        if (seriesOutlinePaint == null && this.autoPopulateSeriesOutlinePaint && (supplier = this.getDrawingSupplier()) != null) {
            seriesOutlinePaint = supplier.getNextOutlinePaint();
            this.setSeriesOutlinePaint(series, seriesOutlinePaint, false);
        }
        if (seriesOutlinePaint == null) {
            seriesOutlinePaint = this.defaultOutlinePaint;
        }
        return seriesOutlinePaint;
    }

    public Paint getSeriesOutlinePaint(int series) {
        return this.seriesOutlinePaintMap.get(series);
    }

    public void setSeriesOutlinePaint(int series, Paint paint) {
        this.setSeriesOutlinePaint(series, paint, true);
    }

    public void setSeriesOutlinePaint(int series, Paint paint, boolean notify) {
        this.seriesOutlinePaintMap.put(series, paint);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Paint getDefaultOutlinePaint() {
        return this.defaultOutlinePaint;
    }

    public void setDefaultOutlinePaint(Paint paint) {
        this.setDefaultOutlinePaint(paint, true);
    }

    public void setDefaultOutlinePaint(Paint paint, boolean notify) {
        Args.nullNotPermitted(paint, "paint");
        this.defaultOutlinePaint = paint;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesOutlinePaint() {
        return this.autoPopulateSeriesOutlinePaint;
    }

    public void setAutoPopulateSeriesOutlinePaint(boolean auto) {
        this.autoPopulateSeriesOutlinePaint = auto;
    }

    public Stroke getItemStroke(int row, int column) {
        return this.lookupSeriesStroke(row);
    }

    public Stroke lookupSeriesStroke(int series) {
        DrawingSupplier supplier;
        Stroke result = this.getSeriesStroke(series);
        if (result == null && this.autoPopulateSeriesStroke && (supplier = this.getDrawingSupplier()) != null) {
            result = supplier.getNextStroke();
            this.setSeriesStroke(series, result, false);
        }
        if (result == null) {
            result = this.defaultStroke;
        }
        return result;
    }

    public Stroke getSeriesStroke(int series) {
        return this.seriesStrokeMap.get(series);
    }

    public void setSeriesStroke(int series, Stroke stroke) {
        this.setSeriesStroke(series, stroke, true);
    }

    public void setSeriesStroke(int series, Stroke stroke, boolean notify) {
        this.seriesStrokeMap.put(series, stroke);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public void clearSeriesStrokes(boolean notify) {
        this.seriesStrokeMap.clear();
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Stroke getDefaultStroke() {
        return this.defaultStroke;
    }

    public void setDefaultStroke(Stroke stroke) {
        this.setDefaultStroke(stroke, true);
    }

    public void setDefaultStroke(Stroke stroke, boolean notify) {
        Args.nullNotPermitted(stroke, "stroke");
        this.defaultStroke = stroke;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesStroke() {
        return this.autoPopulateSeriesStroke;
    }

    public void setAutoPopulateSeriesStroke(boolean auto) {
        this.autoPopulateSeriesStroke = auto;
    }

    public Stroke getItemOutlineStroke(int row, int column) {
        return this.lookupSeriesOutlineStroke(row);
    }

    public Stroke lookupSeriesOutlineStroke(int series) {
        DrawingSupplier supplier;
        Stroke result = this.getSeriesOutlineStroke(series);
        if (result == null && this.autoPopulateSeriesOutlineStroke && (supplier = this.getDrawingSupplier()) != null) {
            result = supplier.getNextOutlineStroke();
            this.setSeriesOutlineStroke(series, result, false);
        }
        if (result == null) {
            result = this.defaultOutlineStroke;
        }
        return result;
    }

    public Stroke getSeriesOutlineStroke(int series) {
        return this.seriesOutlineStrokeMap.get(series);
    }

    public void setSeriesOutlineStroke(int series, Stroke stroke) {
        this.setSeriesOutlineStroke(series, stroke, true);
    }

    public void setSeriesOutlineStroke(int series, Stroke stroke, boolean notify) {
        this.seriesOutlineStrokeMap.put(series, stroke);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Stroke getDefaultOutlineStroke() {
        return this.defaultOutlineStroke;
    }

    public void setDefaultOutlineStroke(Stroke stroke) {
        this.setDefaultOutlineStroke(stroke, true);
    }

    public void setDefaultOutlineStroke(Stroke stroke, boolean notify) {
        Args.nullNotPermitted(stroke, "stroke");
        this.defaultOutlineStroke = stroke;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesOutlineStroke() {
        return this.autoPopulateSeriesOutlineStroke;
    }

    public void setAutoPopulateSeriesOutlineStroke(boolean auto) {
        this.autoPopulateSeriesOutlineStroke = auto;
    }

    public Shape getItemShape(int row, int column) {
        return this.lookupSeriesShape(row);
    }

    public Shape lookupSeriesShape(int series) {
        DrawingSupplier supplier;
        Shape result = this.getSeriesShape(series);
        if (result == null && this.autoPopulateSeriesShape && (supplier = this.getDrawingSupplier()) != null) {
            result = supplier.getNextShape();
            this.setSeriesShape(series, result, false);
        }
        if (result == null) {
            result = this.defaultShape;
        }
        return result;
    }

    public Shape getSeriesShape(int series) {
        return this.seriesShapeMap.get(series);
    }

    public void setSeriesShape(int series, Shape shape) {
        this.setSeriesShape(series, shape, true);
    }

    public void setSeriesShape(int series, Shape shape, boolean notify) {
        this.seriesShapeMap.put(series, shape);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Shape getDefaultShape() {
        return this.defaultShape;
    }

    public void setDefaultShape(Shape shape) {
        this.setDefaultShape(shape, true);
    }

    public void setDefaultShape(Shape shape, boolean notify) {
        Args.nullNotPermitted(shape, "shape");
        this.defaultShape = shape;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean getAutoPopulateSeriesShape() {
        return this.autoPopulateSeriesShape;
    }

    public void setAutoPopulateSeriesShape(boolean auto) {
        this.autoPopulateSeriesShape = auto;
    }

    public boolean isItemLabelVisible(int row, int column) {
        return this.isSeriesItemLabelsVisible(row);
    }

    public boolean isSeriesItemLabelsVisible(int series) {
        Boolean b = this.seriesItemLabelsVisibleMap.get(series);
        if (b == null) {
            return this.defaultItemLabelsVisible;
        }
        return b;
    }

    public void setSeriesItemLabelsVisible(int series, boolean visible) {
        this.setSeriesItemLabelsVisible(series, (Boolean)visible);
    }

    public void setSeriesItemLabelsVisible(int series, Boolean visible) {
        this.setSeriesItemLabelsVisible(series, visible, true);
    }

    public void setSeriesItemLabelsVisible(int series, Boolean visible, boolean notify) {
        this.seriesItemLabelsVisibleMap.put(series, visible);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean getDefaultItemLabelsVisible() {
        return this.defaultItemLabelsVisible;
    }

    public void setDefaultItemLabelsVisible(boolean visible) {
        this.setDefaultItemLabelsVisible(visible, true);
    }

    public void setDefaultItemLabelsVisible(boolean visible, boolean notify) {
        this.defaultItemLabelsVisible = visible;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Font getItemLabelFont(int row, int column) {
        Font result = this.getSeriesItemLabelFont(row);
        if (result == null) {
            result = this.defaultItemLabelFont;
        }
        return result;
    }

    public Font getSeriesItemLabelFont(int series) {
        return this.itemLabelFontMap.get(series);
    }

    public void setSeriesItemLabelFont(int series, Font font) {
        this.setSeriesItemLabelFont(series, font, true);
    }

    public void setSeriesItemLabelFont(int series, Font font, boolean notify) {
        this.itemLabelFontMap.put(series, font);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Font getDefaultItemLabelFont() {
        return this.defaultItemLabelFont;
    }

    public void setDefaultItemLabelFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.setDefaultItemLabelFont(font, true);
    }

    public void setDefaultItemLabelFont(Font font, boolean notify) {
        this.defaultItemLabelFont = font;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Paint getItemLabelPaint(int row, int column) {
        Paint result = this.getSeriesItemLabelPaint(row);
        if (result == null) {
            result = this.defaultItemLabelPaint;
        }
        return result;
    }

    public Paint getSeriesItemLabelPaint(int series) {
        return this.itemLabelPaints.get(series);
    }

    public void setSeriesItemLabelPaint(int series, Paint paint) {
        this.setSeriesItemLabelPaint(series, paint, true);
    }

    public void setSeriesItemLabelPaint(int series, Paint paint, boolean notify) {
        this.itemLabelPaints.put(series, paint);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Paint getDefaultItemLabelPaint() {
        return this.defaultItemLabelPaint;
    }

    public void setDefaultItemLabelPaint(Paint paint) {
        this.setDefaultItemLabelPaint(paint, true);
    }

    public void setDefaultItemLabelPaint(Paint paint, boolean notify) {
        Args.nullNotPermitted(paint, "paint");
        this.defaultItemLabelPaint = paint;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getPositiveItemLabelPosition(int row, int column) {
        return this.getSeriesPositiveItemLabelPosition(row);
    }

    public ItemLabelPosition getSeriesPositiveItemLabelPosition(int series) {
        ItemLabelPosition position = this.positiveItemLabelPositionMap.get(series);
        if (position == null) {
            position = this.defaultPositiveItemLabelPosition;
        }
        return position;
    }

    public void setSeriesPositiveItemLabelPosition(int series, ItemLabelPosition position) {
        this.setSeriesPositiveItemLabelPosition(series, position, true);
    }

    public void setSeriesPositiveItemLabelPosition(int series, ItemLabelPosition position, boolean notify) {
        this.positiveItemLabelPositionMap.put(series, position);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getDefaultPositiveItemLabelPosition() {
        return this.defaultPositiveItemLabelPosition;
    }

    public void setDefaultPositiveItemLabelPosition(ItemLabelPosition position) {
        this.setDefaultPositiveItemLabelPosition(position, true);
    }

    public void setDefaultPositiveItemLabelPosition(ItemLabelPosition position, boolean notify) {
        Args.nullNotPermitted(position, "position");
        this.defaultPositiveItemLabelPosition = position;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getNegativeItemLabelPosition(int row, int column) {
        return this.getSeriesNegativeItemLabelPosition(row);
    }

    public ItemLabelPosition getSeriesNegativeItemLabelPosition(int series) {
        ItemLabelPosition position = this.negativeItemLabelPositionMap.get(series);
        if (position == null) {
            position = this.defaultNegativeItemLabelPosition;
        }
        return position;
    }

    public void setSeriesNegativeItemLabelPosition(int series, ItemLabelPosition position) {
        this.setSeriesNegativeItemLabelPosition(series, position, true);
    }

    public void setSeriesNegativeItemLabelPosition(int series, ItemLabelPosition position, boolean notify) {
        this.negativeItemLabelPositionMap.put(series, position);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public ItemLabelPosition getDefaultNegativeItemLabelPosition() {
        return this.defaultNegativeItemLabelPosition;
    }

    public void setDefaultNegativeItemLabelPosition(ItemLabelPosition position) {
        this.setDefaultNegativeItemLabelPosition(position, true);
    }

    public void setDefaultNegativeItemLabelPosition(ItemLabelPosition position, boolean notify) {
        Args.nullNotPermitted(position, "position");
        this.defaultNegativeItemLabelPosition = position;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public double getItemLabelAnchorOffset() {
        return this.itemLabelAnchorOffset;
    }

    public void setItemLabelAnchorOffset(double offset) {
        this.itemLabelAnchorOffset = offset;
        this.fireChangeEvent();
    }

    public boolean getItemCreateEntity(int series, int item) {
        Boolean b = this.getSeriesCreateEntities(series);
        if (b != null) {
            return b;
        }
        return this.defaultCreateEntities;
    }

    public Boolean getSeriesCreateEntities(int series) {
        return this.seriesCreateEntitiesMap.get(series);
    }

    public void setSeriesCreateEntities(int series, Boolean create) {
        this.setSeriesCreateEntities(series, create, true);
    }

    public void setSeriesCreateEntities(int series, Boolean create, boolean notify) {
        this.seriesCreateEntitiesMap.put(series, create);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean getDefaultCreateEntities() {
        return this.defaultCreateEntities;
    }

    public void setDefaultCreateEntities(boolean create) {
        this.setDefaultCreateEntities(create, true);
    }

    public void setDefaultCreateEntities(boolean create, boolean notify) {
        this.defaultCreateEntities = create;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public int getDefaultEntityRadius() {
        return this.defaultEntityRadius;
    }

    public void setDefaultEntityRadius(int radius) {
        this.defaultEntityRadius = radius;
    }

    public Shape lookupLegendShape(int series) {
        Shape result = this.getLegendShape(series);
        if (result == null) {
            result = this.defaultLegendShape;
        }
        if (result == null) {
            result = this.lookupSeriesShape(series);
        }
        return result;
    }

    public Shape getLegendShape(int series) {
        return this.seriesLegendShapes.get(series);
    }

    public void setLegendShape(int series, Shape shape) {
        this.seriesLegendShapes.put(series, shape);
        this.fireChangeEvent();
    }

    public Shape getDefaultLegendShape() {
        return this.defaultLegendShape;
    }

    public void setDefaultLegendShape(Shape shape) {
        this.defaultLegendShape = shape;
        this.fireChangeEvent();
    }

    protected boolean getTreatLegendShapeAsLine() {
        return this.treatLegendShapeAsLine;
    }

    protected void setTreatLegendShapeAsLine(boolean treatAsLine) {
        if (this.treatLegendShapeAsLine != treatAsLine) {
            this.treatLegendShapeAsLine = treatAsLine;
            this.fireChangeEvent();
        }
    }

    public Font lookupLegendTextFont(int series) {
        Font result = this.getLegendTextFont(series);
        if (result == null) {
            result = this.defaultLegendTextFont;
        }
        return result;
    }

    public Font getLegendTextFont(int series) {
        return this.legendTextFontMap.get(series);
    }

    public void setLegendTextFont(int series, Font font) {
        this.legendTextFontMap.put(series, font);
        this.fireChangeEvent();
    }

    public Font getDefaultLegendTextFont() {
        return this.defaultLegendTextFont;
    }

    public void setDefaultLegendTextFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.defaultLegendTextFont = font;
        this.fireChangeEvent();
    }

    public Paint lookupLegendTextPaint(int series) {
        Paint result = this.getLegendTextPaint(series);
        if (result == null) {
            result = this.defaultLegendTextPaint;
        }
        return result;
    }

    public Paint getLegendTextPaint(int series) {
        return this.legendTextPaints.get(series);
    }

    public void setLegendTextPaint(int series, Paint paint) {
        this.legendTextPaints.put(series, paint);
        this.fireChangeEvent();
    }

    public Paint getDefaultLegendTextPaint() {
        return this.defaultLegendTextPaint;
    }

    public void setDefaultLegendTextPaint(Paint paint) {
        this.defaultLegendTextPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getDataBoundsIncludesVisibleSeriesOnly() {
        return this.dataBoundsIncludesVisibleSeriesOnly;
    }

    public void setDataBoundsIncludesVisibleSeriesOnly(boolean visibleOnly) {
        this.dataBoundsIncludesVisibleSeriesOnly = visibleOnly;
        this.notifyListeners(new RendererChangeEvent((Object)this, true));
    }

    protected Point2D calculateLabelAnchorPoint(ItemLabelAnchor anchor, double x, double y, PlotOrientation orientation) {
        Args.nullNotPermitted((Object)anchor, "anchor");
        Point2D.Double result = null;
        switch (anchor) {
            case CENTER: {
                result = new Point2D.Double(x, y);
                break;
            }
            case INSIDE1: {
                result = new Point2D.Double(x + OPP * this.itemLabelAnchorOffset, y - ADJ * this.itemLabelAnchorOffset);
                break;
            }
            case INSIDE2: {
                result = new Point2D.Double(x + ADJ * this.itemLabelAnchorOffset, y - OPP * this.itemLabelAnchorOffset);
                break;
            }
            case INSIDE3: {
                result = new Point2D.Double(x + this.itemLabelAnchorOffset, y);
                break;
            }
            case INSIDE4: {
                result = new Point2D.Double(x + ADJ * this.itemLabelAnchorOffset, y + OPP * this.itemLabelAnchorOffset);
                break;
            }
            case INSIDE5: {
                result = new Point2D.Double(x + OPP * this.itemLabelAnchorOffset, y + ADJ * this.itemLabelAnchorOffset);
                break;
            }
            case INSIDE6: {
                result = new Point2D.Double(x, y + this.itemLabelAnchorOffset);
                break;
            }
            case INSIDE7: {
                result = new Point2D.Double(x - OPP * this.itemLabelAnchorOffset, y + ADJ * this.itemLabelAnchorOffset);
                break;
            }
            case INSIDE8: {
                result = new Point2D.Double(x - ADJ * this.itemLabelAnchorOffset, y + OPP * this.itemLabelAnchorOffset);
                break;
            }
            case INSIDE9: {
                result = new Point2D.Double(x - this.itemLabelAnchorOffset, y);
                break;
            }
            case INSIDE10: {
                result = new Point2D.Double(x - ADJ * this.itemLabelAnchorOffset, y - OPP * this.itemLabelAnchorOffset);
                break;
            }
            case INSIDE11: {
                result = new Point2D.Double(x - OPP * this.itemLabelAnchorOffset, y - ADJ * this.itemLabelAnchorOffset);
                break;
            }
            case INSIDE12: {
                result = new Point2D.Double(x, y - this.itemLabelAnchorOffset);
                break;
            }
            case OUTSIDE1: {
                result = new Point2D.Double(x + 2.0 * OPP * this.itemLabelAnchorOffset, y - 2.0 * ADJ * this.itemLabelAnchorOffset);
                break;
            }
            case OUTSIDE2: {
                result = new Point2D.Double(x + 2.0 * ADJ * this.itemLabelAnchorOffset, y - 2.0 * OPP * this.itemLabelAnchorOffset);
                break;
            }
            case OUTSIDE3: {
                result = new Point2D.Double(x + 2.0 * this.itemLabelAnchorOffset, y);
                break;
            }
            case OUTSIDE4: {
                result = new Point2D.Double(x + 2.0 * ADJ * this.itemLabelAnchorOffset, y + 2.0 * OPP * this.itemLabelAnchorOffset);
                break;
            }
            case OUTSIDE5: {
                result = new Point2D.Double(x + 2.0 * OPP * this.itemLabelAnchorOffset, y + 2.0 * ADJ * this.itemLabelAnchorOffset);
                break;
            }
            case OUTSIDE6: {
                result = new Point2D.Double(x, y + 2.0 * this.itemLabelAnchorOffset);
                break;
            }
            case OUTSIDE7: {
                result = new Point2D.Double(x - 2.0 * OPP * this.itemLabelAnchorOffset, y + 2.0 * ADJ * this.itemLabelAnchorOffset);
                break;
            }
            case OUTSIDE8: {
                result = new Point2D.Double(x - 2.0 * ADJ * this.itemLabelAnchorOffset, y + 2.0 * OPP * this.itemLabelAnchorOffset);
                break;
            }
            case OUTSIDE9: {
                result = new Point2D.Double(x - 2.0 * this.itemLabelAnchorOffset, y);
                break;
            }
            case OUTSIDE10: {
                result = new Point2D.Double(x - 2.0 * ADJ * this.itemLabelAnchorOffset, y - 2.0 * OPP * this.itemLabelAnchorOffset);
                break;
            }
            case OUTSIDE11: {
                result = new Point2D.Double(x - 2.0 * OPP * this.itemLabelAnchorOffset, y - 2.0 * ADJ * this.itemLabelAnchorOffset);
                break;
            }
            case OUTSIDE12: {
                result = new Point2D.Double(x, y - 2.0 * this.itemLabelAnchorOffset);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected anchor value.");
            }
        }
        return result;
    }

    public void addChangeListener(RendererChangeListener listener) {
        Args.nullNotPermitted(listener, "listener");
        this.listenerList.add(RendererChangeListener.class, listener);
    }

    public void removeChangeListener(RendererChangeListener listener) {
        Args.nullNotPermitted(listener, "listener");
        this.listenerList.remove(RendererChangeListener.class, listener);
    }

    public boolean hasListener(EventListener listener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(listener);
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void notifyListeners(RendererChangeEvent event) {
        Object[] ls = this.listenerList.getListenerList();
        for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != RendererChangeListener.class) continue;
            ((RendererChangeListener)ls[i + 1]).rendererChanged(event);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractRenderer)) {
            return false;
        }
        AbstractRenderer that = (AbstractRenderer)obj;
        if (this.dataBoundsIncludesVisibleSeriesOnly != that.dataBoundsIncludesVisibleSeriesOnly) {
            return false;
        }
        if (this.treatLegendShapeAsLine != that.treatLegendShapeAsLine) {
            return false;
        }
        if (this.defaultEntityRadius != that.defaultEntityRadius) {
            return false;
        }
        if (!this.seriesVisibleMap.equals(that.seriesVisibleMap)) {
            return false;
        }
        if (this.defaultSeriesVisible != that.defaultSeriesVisible) {
            return false;
        }
        if (!this.seriesVisibleInLegendMap.equals(that.seriesVisibleInLegendMap)) {
            return false;
        }
        if (this.defaultSeriesVisibleInLegend != that.defaultSeriesVisibleInLegend) {
            return false;
        }
        if (!PaintUtils.equal(this.seriesPaintMap, that.seriesPaintMap)) {
            return false;
        }
        if (this.autoPopulateSeriesPaint != that.autoPopulateSeriesPaint) {
            return false;
        }
        if (!PaintUtils.equal(this.defaultPaint, that.defaultPaint)) {
            return false;
        }
        if (!PaintUtils.equal(this.seriesFillPaintMap, that.seriesFillPaintMap)) {
            return false;
        }
        if (this.autoPopulateSeriesFillPaint != that.autoPopulateSeriesFillPaint) {
            return false;
        }
        if (!PaintUtils.equal(this.defaultFillPaint, that.defaultFillPaint)) {
            return false;
        }
        if (!PaintUtils.equal(this.seriesOutlinePaintMap, that.seriesOutlinePaintMap)) {
            return false;
        }
        if (this.autoPopulateSeriesOutlinePaint != that.autoPopulateSeriesOutlinePaint) {
            return false;
        }
        if (!PaintUtils.equal(this.defaultOutlinePaint, that.defaultOutlinePaint)) {
            return false;
        }
        if (!Objects.equals(this.seriesStrokeMap, that.seriesStrokeMap)) {
            return false;
        }
        if (this.autoPopulateSeriesStroke != that.autoPopulateSeriesStroke) {
            return false;
        }
        if (!Objects.equals(this.defaultStroke, that.defaultStroke)) {
            return false;
        }
        if (!Objects.equals(this.seriesOutlineStrokeMap, that.seriesOutlineStrokeMap)) {
            return false;
        }
        if (this.autoPopulateSeriesOutlineStroke != that.autoPopulateSeriesOutlineStroke) {
            return false;
        }
        if (!Objects.equals(this.defaultOutlineStroke, that.defaultOutlineStroke)) {
            return false;
        }
        if (!ShapeUtils.equal(this.seriesShapeMap, that.seriesShapeMap)) {
            return false;
        }
        if (this.autoPopulateSeriesShape != that.autoPopulateSeriesShape) {
            return false;
        }
        if (!ShapeUtils.equal(this.defaultShape, that.defaultShape)) {
            return false;
        }
        if (!Objects.equals(this.seriesItemLabelsVisibleMap, that.seriesItemLabelsVisibleMap)) {
            return false;
        }
        if (!Objects.equals(this.defaultItemLabelsVisible, that.defaultItemLabelsVisible)) {
            return false;
        }
        if (!Objects.equals(this.itemLabelFontMap, that.itemLabelFontMap)) {
            return false;
        }
        if (!Objects.equals(this.defaultItemLabelFont, that.defaultItemLabelFont)) {
            return false;
        }
        if (!PaintUtils.equal(this.itemLabelPaints, that.itemLabelPaints)) {
            return false;
        }
        if (!PaintUtils.equal(this.defaultItemLabelPaint, that.defaultItemLabelPaint)) {
            return false;
        }
        if (!Objects.equals(this.positiveItemLabelPositionMap, that.positiveItemLabelPositionMap)) {
            return false;
        }
        if (!Objects.equals(this.defaultPositiveItemLabelPosition, that.defaultPositiveItemLabelPosition)) {
            return false;
        }
        if (!Objects.equals(this.negativeItemLabelPositionMap, that.negativeItemLabelPositionMap)) {
            return false;
        }
        if (!Objects.equals(this.defaultNegativeItemLabelPosition, that.defaultNegativeItemLabelPosition)) {
            return false;
        }
        if (this.itemLabelAnchorOffset != that.itemLabelAnchorOffset) {
            return false;
        }
        if (!Objects.equals(this.seriesCreateEntitiesMap, that.seriesCreateEntitiesMap)) {
            return false;
        }
        if (this.defaultCreateEntities != that.defaultCreateEntities) {
            return false;
        }
        if (!ShapeUtils.equal(this.seriesLegendShapes, that.seriesLegendShapes)) {
            return false;
        }
        if (!ShapeUtils.equal(this.defaultLegendShape, that.defaultLegendShape)) {
            return false;
        }
        if (!Objects.equals(this.legendTextFontMap, that.legendTextFontMap)) {
            return false;
        }
        if (!Objects.equals(this.defaultLegendTextFont, that.defaultLegendTextFont)) {
            return false;
        }
        if (!PaintUtils.equal(this.legendTextPaints, that.legendTextPaints)) {
            return false;
        }
        return PaintUtils.equal(this.defaultLegendTextPaint, that.defaultLegendTextPaint);
    }

    public int hashCode() {
        int result = 193;
        result = HashUtils.hashCode(result, this.seriesVisibleMap);
        result = HashUtils.hashCode(result, this.defaultSeriesVisible);
        result = HashUtils.hashCode(result, this.seriesVisibleInLegendMap);
        result = HashUtils.hashCode(result, this.defaultSeriesVisibleInLegend);
        result = HashUtils.hashCode(result, this.seriesPaintMap);
        result = HashUtils.hashCode(result, this.defaultPaint);
        result = HashUtils.hashCode(result, this.seriesFillPaintMap);
        result = HashUtils.hashCode(result, this.defaultFillPaint);
        result = HashUtils.hashCode(result, this.seriesOutlinePaintMap);
        result = HashUtils.hashCode(result, this.defaultOutlinePaint);
        result = HashUtils.hashCode(result, this.seriesStrokeMap);
        result = HashUtils.hashCode(result, this.defaultStroke);
        result = HashUtils.hashCode(result, this.seriesOutlineStrokeMap);
        result = HashUtils.hashCode(result, this.defaultOutlineStroke);
        result = HashUtils.hashCode(result, this.seriesItemLabelsVisibleMap);
        result = HashUtils.hashCode(result, this.defaultItemLabelsVisible);
        return result;
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractRenderer clone = (AbstractRenderer)super.clone();
        if (this.seriesVisibleMap != null) {
            clone.seriesVisibleMap = new HashMap<Integer, Boolean>(this.seriesVisibleMap);
        }
        if (this.seriesVisibleInLegendMap != null) {
            clone.seriesVisibleInLegendMap = new HashMap<Integer, Boolean>(this.seriesVisibleInLegendMap);
        }
        if (this.seriesPaintMap != null) {
            clone.seriesPaintMap = new HashMap<Integer, Paint>(this.seriesPaintMap);
        }
        if (this.seriesFillPaintMap != null) {
            clone.seriesFillPaintMap = new HashMap<Integer, Paint>(this.seriesFillPaintMap);
        }
        if (this.seriesOutlinePaintMap != null) {
            clone.seriesOutlinePaintMap = new HashMap<Integer, Paint>(this.seriesOutlinePaintMap);
        }
        if (this.seriesStrokeMap != null) {
            clone.seriesStrokeMap = CloneUtils.cloneMapValues(this.seriesStrokeMap);
        }
        if (this.seriesOutlineStrokeMap != null) {
            clone.seriesOutlineStrokeMap = CloneUtils.cloneMapValues(this.seriesOutlineStrokeMap);
        }
        if (this.seriesShapeMap != null) {
            clone.seriesShapeMap = ShapeUtils.cloneMap(this.seriesShapeMap);
        }
        clone.defaultShape = CloneUtils.clone(this.defaultShape);
        if (this.seriesItemLabelsVisibleMap != null) {
            clone.seriesItemLabelsVisibleMap = new HashMap<Integer, Boolean>(this.seriesItemLabelsVisibleMap);
        }
        if (this.itemLabelFontMap != null) {
            clone.itemLabelFontMap = new HashMap<Integer, Font>(this.itemLabelFontMap);
        }
        if (this.itemLabelPaints != null) {
            clone.itemLabelPaints = new HashMap<Integer, Paint>(this.itemLabelPaints);
        }
        if (this.positiveItemLabelPositionMap != null) {
            clone.positiveItemLabelPositionMap = new HashMap<Integer, ItemLabelPosition>(this.positiveItemLabelPositionMap);
        }
        if (this.negativeItemLabelPositionMap != null) {
            clone.negativeItemLabelPositionMap = new HashMap<Integer, ItemLabelPosition>(this.negativeItemLabelPositionMap);
        }
        if (this.seriesCreateEntitiesMap != null) {
            clone.seriesCreateEntitiesMap = new HashMap<Integer, Boolean>(this.seriesCreateEntitiesMap);
        }
        if (this.seriesLegendShapes != null) {
            clone.seriesLegendShapes = ShapeUtils.cloneMap(this.seriesLegendShapes);
        }
        if (this.legendTextFontMap != null) {
            clone.legendTextFontMap = new HashMap<Integer, Font>(this.legendTextFontMap);
        }
        if (this.legendTextPaints != null) {
            clone.legendTextPaints = new HashMap<Integer, Paint>(this.legendTextPaints);
        }
        clone.listenerList = new EventListenerList();
        clone.event = null;
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writeMapOfPaint(this.seriesPaintMap, stream);
        SerialUtils.writePaint(this.defaultPaint, stream);
        SerialUtils.writeMapOfPaint(this.seriesFillPaintMap, stream);
        SerialUtils.writePaint(this.defaultFillPaint, stream);
        SerialUtils.writeMapOfPaint(this.seriesOutlinePaintMap, stream);
        SerialUtils.writePaint(this.defaultOutlinePaint, stream);
        SerialUtils.writeMapOfStroke(this.seriesStrokeMap, stream);
        SerialUtils.writeStroke(this.defaultStroke, stream);
        SerialUtils.writeMapOfStroke(this.seriesOutlineStrokeMap, stream);
        SerialUtils.writeStroke(this.defaultOutlineStroke, stream);
        SerialUtils.writeShape(this.defaultShape, stream);
        SerialUtils.writeMapOfPaint(this.itemLabelPaints, stream);
        SerialUtils.writePaint(this.defaultItemLabelPaint, stream);
        SerialUtils.writeShape(this.defaultLegendShape, stream);
        SerialUtils.writeMapOfPaint(this.legendTextPaints, stream);
        SerialUtils.writePaint(this.defaultLegendTextPaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.seriesPaintMap = SerialUtils.readMapOfPaint(stream);
        this.defaultPaint = SerialUtils.readPaint(stream);
        this.seriesFillPaintMap = SerialUtils.readMapOfPaint(stream);
        this.defaultFillPaint = SerialUtils.readPaint(stream);
        this.seriesOutlinePaintMap = SerialUtils.readMapOfPaint(stream);
        this.defaultOutlinePaint = SerialUtils.readPaint(stream);
        this.seriesStrokeMap = SerialUtils.readMapOfStroke(stream);
        this.defaultStroke = SerialUtils.readStroke(stream);
        this.seriesOutlineStrokeMap = SerialUtils.readMapOfStroke(stream);
        this.defaultOutlineStroke = SerialUtils.readStroke(stream);
        this.defaultShape = SerialUtils.readShape(stream);
        this.itemLabelPaints = SerialUtils.readMapOfPaint(stream);
        this.defaultItemLabelPaint = SerialUtils.readPaint(stream);
        this.defaultLegendShape = SerialUtils.readShape(stream);
        this.legendTextPaints = SerialUtils.readMapOfPaint(stream);
        this.defaultLegendTextPaint = SerialUtils.readPaint(stream);
        this.listenerList = new EventListenerList();
    }
}

