/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.jfree.chart.ChartElementVisitor;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.chart.api.RectangleEdge;
import org.jfree.chart.api.RectangleInsets;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.internal.Args;
import org.jfree.chart.internal.CloneUtils;
import org.jfree.chart.internal.PaintUtils;
import org.jfree.chart.internal.SerialUtils;
import org.jfree.chart.legend.LegendItem;
import org.jfree.chart.legend.LegendItemCollection;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.PolarAxisLocation;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.chart.text.TextAnchor;
import org.jfree.chart.text.TextUtils;
import org.jfree.data.Range;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtils;
import org.jfree.data.xy.XYDataset;

public class PolarPlot
extends Plot
implements ValueAxisPlot,
Zoomable,
RendererChangeListener,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3794383185924179525L;
    private static final int DEFAULT_MARGIN = 20;
    private static final double ANNOTATION_MARGIN = 7.0;
    public static final double DEFAULT_ANGLE_TICK_UNIT_SIZE = 45.0;
    public static final double DEFAULT_ANGLE_OFFSET = -90.0;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.GRAY;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private List<ValueTick> angleTicks;
    private Map<Integer, ValueAxis> axes;
    private final Map<Integer, PolarAxisLocation> axisLocations;
    private Map<Integer, XYDataset> datasets;
    private Map<Integer, PolarItemRenderer> renderers;
    private TickUnit angleTickUnit;
    private double angleOffset;
    private boolean counterClockwise;
    private boolean angleLabelsVisible = true;
    private Font angleLabelFont = new Font("SansSerif", 0, 12);
    private transient Paint angleLabelPaint = Color.BLACK;
    private boolean angleGridlinesVisible;
    private transient Stroke angleGridlineStroke;
    private transient Paint angleGridlinePaint;
    private boolean radiusGridlinesVisible;
    private transient Stroke radiusGridlineStroke;
    private transient Paint radiusGridlinePaint;
    private boolean radiusMinorGridlinesVisible;
    private List<String> cornerTextItems = new ArrayList<String>();
    private int margin;
    private LegendItemCollection fixedLegendItems;
    private final Map<Integer, List<Integer>> datasetToAxesMap;

    public PolarPlot() {
        this(null, null, null);
    }

    public PolarPlot(XYDataset dataset, ValueAxis radiusAxis, PolarItemRenderer renderer) {
        this.datasets = new HashMap<Integer, XYDataset>();
        this.datasets.put(0, dataset);
        if (dataset != null) {
            dataset.addChangeListener(this);
        }
        this.angleTickUnit = new NumberTickUnit(45.0);
        this.axes = new HashMap<Integer, ValueAxis>();
        this.datasetToAxesMap = new TreeMap<Integer, List<Integer>>();
        this.axes.put(0, radiusAxis);
        if (radiusAxis != null) {
            radiusAxis.setPlot(this);
            radiusAxis.addChangeListener(this);
        }
        this.axisLocations = new HashMap<Integer, PolarAxisLocation>();
        this.axisLocations.put(0, PolarAxisLocation.EAST_ABOVE);
        this.axisLocations.put(1, PolarAxisLocation.NORTH_LEFT);
        this.axisLocations.put(2, PolarAxisLocation.WEST_BELOW);
        this.axisLocations.put(3, PolarAxisLocation.SOUTH_RIGHT);
        this.axisLocations.put(4, PolarAxisLocation.EAST_BELOW);
        this.axisLocations.put(5, PolarAxisLocation.NORTH_RIGHT);
        this.axisLocations.put(6, PolarAxisLocation.WEST_ABOVE);
        this.axisLocations.put(7, PolarAxisLocation.SOUTH_LEFT);
        this.renderers = new HashMap<Integer, PolarItemRenderer>();
        this.renderers.put(0, renderer);
        if (renderer != null) {
            renderer.setPlot(this);
            renderer.addChangeListener(this);
        }
        this.angleOffset = -90.0;
        this.counterClockwise = false;
        this.angleGridlinesVisible = true;
        this.angleGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.angleGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.radiusGridlinesVisible = true;
        this.radiusMinorGridlinesVisible = true;
        this.radiusGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.radiusGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.margin = 20;
    }

    @Override
    public String getPlotType() {
        return localizationResources.getString("Polar_Plot");
    }

    public ValueAxis getAxis() {
        return this.getAxis(0);
    }

    public ValueAxis getAxis(int index) {
        return this.axes.get(index);
    }

    public void setAxis(ValueAxis axis) {
        this.setAxis(0, axis);
    }

    public void setAxis(int index, ValueAxis axis) {
        this.setAxis(index, axis, true);
    }

    public void setAxis(int index, ValueAxis axis, boolean notify) {
        ValueAxis existing = this.getAxis(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        if (axis != null) {
            axis.setPlot(this);
        }
        this.axes.put(index, axis);
        if (axis != null) {
            axis.configure();
            axis.addChangeListener(this);
        }
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public PolarAxisLocation getAxisLocation() {
        return this.getAxisLocation(0);
    }

    public PolarAxisLocation getAxisLocation(int index) {
        return this.axisLocations.get(index);
    }

    public void setAxisLocation(PolarAxisLocation location) {
        this.setAxisLocation(0, location, true);
    }

    public void setAxisLocation(PolarAxisLocation location, boolean notify) {
        this.setAxisLocation(0, location, notify);
    }

    public void setAxisLocation(int index, PolarAxisLocation location) {
        this.setAxisLocation(index, location, true);
    }

    public void setAxisLocation(int index, PolarAxisLocation location, boolean notify) {
        Args.nullNotPermitted((Object)location, "location");
        this.axisLocations.put(index, location);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public int getAxisCount() {
        return this.axes.size();
    }

    public XYDataset getDataset() {
        return this.getDataset(0);
    }

    public XYDataset getDataset(int index) {
        return this.datasets.get(index);
    }

    public void setDataset(XYDataset dataset) {
        this.setDataset(0, dataset);
    }

    public void setDataset(int index, XYDataset dataset) {
        XYDataset existing = this.getDataset(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.datasets.put(index, dataset);
        if (dataset != null) {
            dataset.addChangeListener(this);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, dataset);
        this.datasetChanged(event);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public int indexOf(XYDataset dataset) {
        for (Map.Entry<Integer, XYDataset> entry : this.datasets.entrySet()) {
            if (entry.getValue() != dataset) continue;
            return entry.getKey();
        }
        return -1;
    }

    public PolarItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public PolarItemRenderer getRenderer(int index) {
        return this.renderers.get(index);
    }

    public void setRenderer(PolarItemRenderer renderer) {
        this.setRenderer(0, renderer);
    }

    public void setRenderer(int index, PolarItemRenderer renderer) {
        this.setRenderer(index, renderer, true);
    }

    public void setRenderer(int index, PolarItemRenderer renderer, boolean notify) {
        PolarItemRenderer existing = this.getRenderer(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.renderers.put(index, renderer);
        if (renderer != null) {
            renderer.setPlot(this);
            renderer.addChangeListener(this);
        }
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public TickUnit getAngleTickUnit() {
        return this.angleTickUnit;
    }

    public void setAngleTickUnit(TickUnit unit) {
        Args.nullNotPermitted(unit, "unit");
        this.angleTickUnit = unit;
        this.fireChangeEvent();
    }

    public double getAngleOffset() {
        return this.angleOffset;
    }

    public void setAngleOffset(double offset) {
        this.angleOffset = offset;
        this.fireChangeEvent();
    }

    public boolean isCounterClockwise() {
        return this.counterClockwise;
    }

    public void setCounterClockwise(boolean counterClockwise) {
        this.counterClockwise = counterClockwise;
    }

    public boolean isAngleLabelsVisible() {
        return this.angleLabelsVisible;
    }

    public void setAngleLabelsVisible(boolean visible) {
        if (this.angleLabelsVisible != visible) {
            this.angleLabelsVisible = visible;
            this.fireChangeEvent();
        }
    }

    public Font getAngleLabelFont() {
        return this.angleLabelFont;
    }

    public void setAngleLabelFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.angleLabelFont = font;
        this.fireChangeEvent();
    }

    public Paint getAngleLabelPaint() {
        return this.angleLabelPaint;
    }

    public void setAngleLabelPaint(Paint paint) {
        Args.nullNotPermitted(paint, "paint");
        this.angleLabelPaint = paint;
        this.fireChangeEvent();
    }

    public boolean isAngleGridlinesVisible() {
        return this.angleGridlinesVisible;
    }

    public void setAngleGridlinesVisible(boolean visible) {
        if (this.angleGridlinesVisible != visible) {
            this.angleGridlinesVisible = visible;
            this.fireChangeEvent();
        }
    }

    public Stroke getAngleGridlineStroke() {
        return this.angleGridlineStroke;
    }

    public void setAngleGridlineStroke(Stroke stroke) {
        this.angleGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getAngleGridlinePaint() {
        return this.angleGridlinePaint;
    }

    public void setAngleGridlinePaint(Paint paint) {
        this.angleGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRadiusGridlinesVisible() {
        return this.radiusGridlinesVisible;
    }

    public void setRadiusGridlinesVisible(boolean visible) {
        if (this.radiusGridlinesVisible != visible) {
            this.radiusGridlinesVisible = visible;
            this.fireChangeEvent();
        }
    }

    public Stroke getRadiusGridlineStroke() {
        return this.radiusGridlineStroke;
    }

    public void setRadiusGridlineStroke(Stroke stroke) {
        this.radiusGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRadiusGridlinePaint() {
        return this.radiusGridlinePaint;
    }

    public void setRadiusGridlinePaint(Paint paint) {
        this.radiusGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRadiusMinorGridlinesVisible() {
        return this.radiusMinorGridlinesVisible;
    }

    public void setRadiusMinorGridlinesVisible(boolean flag) {
        this.radiusMinorGridlinesVisible = flag;
        this.fireChangeEvent();
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
        this.fireChangeEvent();
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection items) {
        this.fixedLegendItems = items;
        this.fireChangeEvent();
    }

    public void addCornerTextItem(String text) {
        Args.nullNotPermitted(text, "text");
        this.cornerTextItems.add(text);
        this.fireChangeEvent();
    }

    public void removeCornerTextItem(String text) {
        boolean removed = this.cornerTextItems.remove(text);
        if (removed) {
            this.fireChangeEvent();
        }
    }

    public void clearCornerTextItems() {
        if (!this.cornerTextItems.isEmpty()) {
            this.cornerTextItems.clear();
            this.fireChangeEvent();
        }
    }

    protected List<ValueTick> refreshAngleTicks() {
        ArrayList<ValueTick> ticks = new ArrayList<ValueTick>();
        for (double currentTickVal = 0.0; currentTickVal < 360.0; currentTickVal += this.angleTickUnit.getSize()) {
            TextAnchor ta = this.calculateTextAnchor(currentTickVal);
            NumberTick tick = new NumberTick((Number)currentTickVal, this.angleTickUnit.valueToString(currentTickVal), ta, TextAnchor.CENTER, 0.0);
            ticks.add(tick);
        }
        return ticks;
    }

    protected TextAnchor calculateTextAnchor(double angleDegrees) {
        double normalizedAngle;
        TextAnchor ta = TextAnchor.CENTER;
        for (double offset = this.angleOffset; offset < 0.0; offset += 360.0) {
        }
        for (normalizedAngle = ((double)(this.counterClockwise ? -1 : 1) * angleDegrees + offset) % 360.0; this.counterClockwise && normalizedAngle < 0.0; normalizedAngle += 360.0) {
        }
        if (normalizedAngle == 0.0) {
            ta = TextAnchor.CENTER_LEFT;
        } else if (normalizedAngle > 0.0 && normalizedAngle < 90.0) {
            ta = TextAnchor.TOP_LEFT;
        } else if (normalizedAngle == 90.0) {
            ta = TextAnchor.TOP_CENTER;
        } else if (normalizedAngle > 90.0 && normalizedAngle < 180.0) {
            ta = TextAnchor.TOP_RIGHT;
        } else if (normalizedAngle == 180.0) {
            ta = TextAnchor.CENTER_RIGHT;
        } else if (normalizedAngle > 180.0 && normalizedAngle < 270.0) {
            ta = TextAnchor.BOTTOM_RIGHT;
        } else if (normalizedAngle == 270.0) {
            ta = TextAnchor.BOTTOM_CENTER;
        } else if (normalizedAngle > 270.0 && normalizedAngle < 360.0) {
            ta = TextAnchor.BOTTOM_LEFT;
        }
        return ta;
    }

    public void mapDatasetToAxis(int index, int axisIndex) {
        ArrayList<Integer> axisIndices = new ArrayList<Integer>(1);
        axisIndices.add(axisIndex);
        this.mapDatasetToAxes(index, axisIndices);
    }

    public void mapDatasetToAxes(int index, List<Integer> axisIndices) {
        if (index < 0) {
            throw new IllegalArgumentException("Requires 'index' >= 0.");
        }
        this.checkAxisIndices(axisIndices);
        Integer key = index;
        this.datasetToAxesMap.put(key, new ArrayList<Integer>(axisIndices));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(index)));
    }

    private void checkAxisIndices(List<Integer> indices) {
        if (indices == null) {
            return;
        }
        if (indices.isEmpty()) {
            throw new IllegalArgumentException("Empty list not permitted.");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (Integer i : indices) {
            if (set.contains(i)) {
                throw new IllegalArgumentException("Indices must be unique.");
            }
            set.add(i);
        }
    }

    public ValueAxis getAxisForDataset(int index) {
        ValueAxis valueAxis;
        List<Integer> axisIndices = this.datasetToAxesMap.get(index);
        if (axisIndices != null) {
            Integer axisIndex = axisIndices.get(0);
            valueAxis = this.getAxis(axisIndex);
        } else {
            valueAxis = this.getAxis(0);
        }
        return valueAxis;
    }

    public int getAxisIndex(ValueAxis axis) {
        for (Map.Entry<Integer, ValueAxis> entry : this.axes.entrySet()) {
            if (!axis.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        Plot parent = this.getParent();
        if (parent instanceof PolarPlot) {
            PolarPlot p = (PolarPlot)parent;
            return p.getAxisIndex(axis);
        }
        return -1;
    }

    public int getIndexOf(PolarItemRenderer renderer) {
        Args.nullNotPermitted(renderer, "renderer");
        for (Map.Entry<Integer, PolarItemRenderer> entry : this.renderers.entrySet()) {
            if (!renderer.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public void receive(ChartElementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        boolean b2;
        boolean b1 = area.getWidth() <= 10.0;
        boolean bl = b2 = area.getHeight() <= 10.0;
        if (b1 || b2) {
            return;
        }
        if (info != null) {
            info.setPlotArea(area);
        }
        RectangleInsets insets = this.getInsets();
        insets.trim(area);
        Rectangle2D dataArea = area;
        if (info != null) {
            info.setDataArea(dataArea);
        }
        this.drawBackground(g2, dataArea);
        int axisCount = this.axes.size();
        AxisState state = null;
        for (int i = 0; i < axisCount; ++i) {
            ValueAxis axis = this.getAxis(i);
            if (axis == null) continue;
            PolarAxisLocation location = this.axisLocations.get(i);
            AxisState s = this.drawAxis(axis, location, g2, dataArea);
            if (i != 0) continue;
            state = s;
        }
        Shape originalClip = g2.getClip();
        Composite originalComposite = g2.getComposite();
        g2.clip(dataArea);
        g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        this.angleTicks = this.refreshAngleTicks();
        this.drawGridlines(g2, dataArea, this.angleTicks, state.getTicks());
        this.render(g2, dataArea, info);
        g2.setClip(originalClip);
        g2.setComposite(originalComposite);
        this.drawOutline(g2, dataArea);
        this.drawCornerTextItems(g2, dataArea);
    }

    protected void drawCornerTextItems(Graphics2D g2, Rectangle2D area) {
        if (this.cornerTextItems.isEmpty()) {
            return;
        }
        g2.setColor(Color.BLACK);
        double width = 0.0;
        double height = 0.0;
        for (String msg : this.cornerTextItems) {
            FontMetrics fm = g2.getFontMetrics();
            Rectangle2D bounds = TextUtils.getTextBounds(msg, g2, fm);
            width = Math.max(width, bounds.getWidth());
            height += bounds.getHeight();
        }
        double xadj = 14.0;
        double yadj = 7.0;
        double x = area.getMaxX() - (width += xadj);
        double y = area.getMaxY() - (height += yadj);
        g2.drawRect((int)x, (int)y, (int)width, (int)height);
        x += 7.0;
        for (String msg : this.cornerTextItems) {
            Rectangle2D bounds = TextUtils.getTextBounds(msg, g2, g2.getFontMetrics());
            g2.drawString(msg, (int)x, (int)(y += bounds.getHeight()));
        }
    }

    protected AxisState drawAxis(ValueAxis axis, PolarAxisLocation location, Graphics2D g2, Rectangle2D plotArea) {
        double centerX = plotArea.getCenterX();
        double centerY = plotArea.getCenterY();
        double r = Math.min(plotArea.getWidth() / 2.0, plotArea.getHeight() / 2.0) - (double)this.margin;
        double x = centerX - r;
        double y = centerY - r;
        Rectangle2D.Double dataArea = null;
        AxisState result = null;
        if (location == PolarAxisLocation.NORTH_RIGHT) {
            dataArea = new Rectangle2D.Double(x, y, r, r);
            result = axis.draw(g2, centerX, plotArea, dataArea, RectangleEdge.RIGHT, null);
        } else if (location == PolarAxisLocation.NORTH_LEFT) {
            dataArea = new Rectangle2D.Double(centerX, y, r, r);
            result = axis.draw(g2, centerX, plotArea, dataArea, RectangleEdge.LEFT, null);
        } else if (location == PolarAxisLocation.SOUTH_LEFT) {
            dataArea = new Rectangle2D.Double(centerX, centerY, r, r);
            result = axis.draw(g2, centerX, plotArea, dataArea, RectangleEdge.LEFT, null);
        } else if (location == PolarAxisLocation.SOUTH_RIGHT) {
            dataArea = new Rectangle2D.Double(x, centerY, r, r);
            result = axis.draw(g2, centerX, plotArea, dataArea, RectangleEdge.RIGHT, null);
        } else if (location == PolarAxisLocation.EAST_ABOVE) {
            dataArea = new Rectangle2D.Double(centerX, centerY, r, r);
            result = axis.draw(g2, centerY, plotArea, dataArea, RectangleEdge.TOP, null);
        } else if (location == PolarAxisLocation.EAST_BELOW) {
            dataArea = new Rectangle2D.Double(centerX, y, r, r);
            result = axis.draw(g2, centerY, plotArea, dataArea, RectangleEdge.BOTTOM, null);
        } else if (location == PolarAxisLocation.WEST_ABOVE) {
            dataArea = new Rectangle2D.Double(x, centerY, r, r);
            result = axis.draw(g2, centerY, plotArea, dataArea, RectangleEdge.TOP, null);
        } else if (location == PolarAxisLocation.WEST_BELOW) {
            dataArea = new Rectangle2D.Double(x, y, r, r);
            result = axis.draw(g2, centerY, plotArea, dataArea, RectangleEdge.BOTTOM, null);
        }
        return result;
    }

    protected void render(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info) {
        boolean hasData = false;
        int datasetCount = this.datasets.size();
        for (int i = datasetCount - 1; i >= 0; --i) {
            PolarItemRenderer renderer;
            XYDataset dataset = this.getDataset(i);
            if (dataset == null || (renderer = this.getRenderer(i)) == null || DatasetUtils.isEmptyOrNull(dataset)) continue;
            hasData = true;
            int seriesCount = dataset.getSeriesCount();
            for (int series = 0; series < seriesCount; ++series) {
                renderer.drawSeries(g2, dataArea, info, this, dataset, series);
            }
        }
        if (!hasData) {
            this.drawNoDataMessage(g2, dataArea);
        }
    }

    protected void drawGridlines(Graphics2D g2, Rectangle2D dataArea, List<ValueTick> angularTicks, List<ValueTick> radialTicks) {
        Paint gridPaint;
        Stroke gridStroke;
        PolarItemRenderer renderer = this.getRenderer();
        if (renderer == null) {
            return;
        }
        if (this.isAngleGridlinesVisible()) {
            gridStroke = this.getAngleGridlineStroke();
            gridPaint = this.getAngleGridlinePaint();
            if (gridStroke != null && gridPaint != null) {
                renderer.drawAngularGridLines(g2, this, angularTicks, dataArea);
            }
        }
        if (this.isRadiusGridlinesVisible()) {
            gridStroke = this.getRadiusGridlineStroke();
            gridPaint = this.getRadiusGridlinePaint();
            if (gridStroke != null && gridPaint != null) {
                List<ValueTick> ticks = this.buildRadialTicks(radialTicks);
                renderer.drawRadialGridLines(g2, this, this.getAxis(), ticks, dataArea);
            }
        }
    }

    protected List<ValueTick> buildRadialTicks(List<ValueTick> allTicks) {
        ArrayList<ValueTick> ticks = new ArrayList<ValueTick>();
        for (ValueTick tick : allTicks) {
            if (!this.isRadiusMinorGridlinesVisible() && !TickType.MAJOR.equals((Object)tick.getTickType())) continue;
            ticks.add(tick);
        }
        return ticks;
    }

    @Override
    public void zoom(double percent) {
        for (int axisIdx = 0; axisIdx < this.getAxisCount(); ++axisIdx) {
            ValueAxis axis = this.getAxis(axisIdx);
            if (axis == null) continue;
            if (percent > 0.0) {
                double radius = axis.getUpperBound();
                double scaledRadius = radius * percent;
                axis.setUpperBound(scaledRadius);
                axis.setAutoRange(false);
                continue;
            }
            axis.setAutoRange(true);
        }
    }

    private List<XYDataset> getDatasetsMappedToAxis(Integer axisIndex) {
        Args.nullNotPermitted(axisIndex, "axisIndex");
        ArrayList<XYDataset> result = new ArrayList<XYDataset>();
        for (Map.Entry<Integer, XYDataset> entry : this.datasets.entrySet()) {
            List<Integer> mappedAxes = this.datasetToAxesMap.get(entry.getKey());
            if (mappedAxes == null) {
                if (!axisIndex.equals(ZERO)) continue;
                result.add(this.getDataset(entry.getKey()));
                continue;
            }
            if (!mappedAxes.contains(axisIndex)) continue;
            result.add(this.getDataset(entry.getKey()));
        }
        return result;
    }

    @Override
    public Range getDataRange(ValueAxis axis) {
        Range result = null;
        List<Object> mappedDatasets = new ArrayList();
        int axisIndex = this.getAxisIndex(axis);
        if (axisIndex >= 0) {
            mappedDatasets = this.getDatasetsMappedToAxis(axisIndex);
        }
        for (XYDataset dataset : mappedDatasets) {
            if (dataset == null) continue;
            result = Range.combine(result, DatasetUtils.findRangeBounds(dataset));
        }
        return result;
    }

    @Override
    public void datasetChanged(DatasetChangeEvent event) {
        for (int i = 0; i < this.axes.size(); ++i) {
            ValueAxis axis = this.axes.get(i);
            if (axis == null) continue;
            axis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(event);
        } else {
            super.datasetChanged(event);
        }
    }

    @Override
    public void rendererChanged(RendererChangeEvent event) {
        this.fireChangeEvent();
    }

    @Override
    public LegendItemCollection getLegendItems() {
        if (this.fixedLegendItems != null) {
            return this.fixedLegendItems;
        }
        LegendItemCollection result = new LegendItemCollection();
        int count = this.datasets.size();
        for (int datasetIndex = 0; datasetIndex < count; ++datasetIndex) {
            XYDataset dataset = this.getDataset(datasetIndex);
            PolarItemRenderer renderer = this.getRenderer(datasetIndex);
            if (dataset == null || renderer == null) continue;
            int seriesCount = dataset.getSeriesCount();
            for (int i = 0; i < seriesCount; ++i) {
                LegendItem item = renderer.getLegendItem(i);
                result.add(item);
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PolarPlot)) {
            return false;
        }
        PolarPlot that = (PolarPlot)obj;
        if (!this.axes.equals(that.axes)) {
            return false;
        }
        if (!this.axisLocations.equals(that.axisLocations)) {
            return false;
        }
        if (!this.renderers.equals(that.renderers)) {
            return false;
        }
        if (!this.angleTickUnit.equals(that.angleTickUnit)) {
            return false;
        }
        if (this.angleGridlinesVisible != that.angleGridlinesVisible) {
            return false;
        }
        if (this.angleOffset != that.angleOffset) {
            return false;
        }
        if (this.counterClockwise != that.counterClockwise) {
            return false;
        }
        if (this.angleLabelsVisible != that.angleLabelsVisible) {
            return false;
        }
        if (!this.angleLabelFont.equals(that.angleLabelFont)) {
            return false;
        }
        if (!PaintUtils.equal(this.angleLabelPaint, that.angleLabelPaint)) {
            return false;
        }
        if (!Objects.equals(this.angleGridlineStroke, that.angleGridlineStroke)) {
            return false;
        }
        if (!PaintUtils.equal(this.angleGridlinePaint, that.angleGridlinePaint)) {
            return false;
        }
        if (this.radiusGridlinesVisible != that.radiusGridlinesVisible) {
            return false;
        }
        if (!Objects.equals(this.radiusGridlineStroke, that.radiusGridlineStroke)) {
            return false;
        }
        if (!PaintUtils.equal(this.radiusGridlinePaint, that.radiusGridlinePaint)) {
            return false;
        }
        if (this.radiusMinorGridlinesVisible != that.radiusMinorGridlinesVisible) {
            return false;
        }
        if (!this.cornerTextItems.equals(that.cornerTextItems)) {
            return false;
        }
        if (this.margin != that.margin) {
            return false;
        }
        if (!Objects.equals(this.fixedLegendItems, that.fixedLegendItems)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        PolarPlot clone = (PolarPlot)super.clone();
        clone.axes = CloneUtils.clone(this.axes);
        for (i = 0; i < this.axes.size(); ++i) {
            ValueAxis axis = this.axes.get(i);
            if (axis == null) continue;
            ValueAxis clonedAxis = (ValueAxis)axis.clone();
            clone.axes.put(i, clonedAxis);
            clonedAxis.setPlot(clone);
            clonedAxis.addChangeListener(clone);
        }
        clone.datasets = CloneUtils.clone(this.datasets);
        for (i = 0; i < clone.datasets.size(); ++i) {
            XYDataset d = this.getDataset(i);
            if (d == null) continue;
            d.addChangeListener(clone);
        }
        clone.renderers = CloneUtils.clone(this.renderers);
        for (i = 0; i < this.renderers.size(); ++i) {
            PolarItemRenderer renderer2 = this.renderers.get(i);
            if (!(renderer2 instanceof PublicCloneable)) continue;
            PublicCloneable pc = (PublicCloneable)((Object)renderer2);
            PolarItemRenderer rc = (PolarItemRenderer)pc.clone();
            clone.renderers.put(i, rc);
            rc.setPlot(clone);
            rc.addChangeListener(clone);
        }
        clone.cornerTextItems = new ArrayList<String>(this.cornerTextItems);
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writeStroke(this.angleGridlineStroke, stream);
        SerialUtils.writePaint(this.angleGridlinePaint, stream);
        SerialUtils.writeStroke(this.radiusGridlineStroke, stream);
        SerialUtils.writePaint(this.radiusGridlinePaint, stream);
        SerialUtils.writePaint(this.angleLabelPaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.angleGridlineStroke = SerialUtils.readStroke(stream);
        this.angleGridlinePaint = SerialUtils.readPaint(stream);
        this.radiusGridlineStroke = SerialUtils.readStroke(stream);
        this.radiusGridlinePaint = SerialUtils.readPaint(stream);
        this.angleLabelPaint = SerialUtils.readPaint(stream);
        int rangeAxisCount = this.axes.size();
        for (int i = 0; i < rangeAxisCount; ++i) {
            Axis axis = this.axes.get(i);
            if (axis == null) continue;
            axis.setPlot(this);
            axis.addChangeListener(this);
        }
        int datasetCount = this.datasets.size();
        for (int i = 0; i < datasetCount; ++i) {
            Dataset dataset = this.datasets.get(i);
            if (dataset == null) continue;
            dataset.addChangeListener(this);
        }
        int rendererCount = this.renderers.size();
        for (int i = 0; i < rendererCount; ++i) {
            PolarItemRenderer renderer = this.renderers.get(i);
            if (renderer == null) continue;
            renderer.addChangeListener(this);
        }
    }

    @Override
    public void zoomDomainAxes(double factor, PlotRenderingInfo state, Point2D source) {
    }

    @Override
    public void zoomDomainAxes(double factor, PlotRenderingInfo state, Point2D source, boolean useAnchor) {
    }

    @Override
    public void zoomDomainAxes(double lowerPercent, double upperPercent, PlotRenderingInfo state, Point2D source) {
    }

    @Override
    public void zoomRangeAxes(double factor, PlotRenderingInfo state, Point2D source) {
        this.zoom(factor);
    }

    @Override
    public void zoomRangeAxes(double factor, PlotRenderingInfo info, Point2D source, boolean useAnchor) {
        double sourceX = source.getX();
        for (int axisIdx = 0; axisIdx < this.getAxisCount(); ++axisIdx) {
            ValueAxis axis = this.getAxis(axisIdx);
            if (axis == null) continue;
            if (useAnchor) {
                double anchorX = axis.java2DToValue(sourceX, info.getDataArea(), RectangleEdge.BOTTOM);
                axis.resizeRange(factor, anchorX);
                continue;
            }
            axis.resizeRange(factor);
        }
    }

    @Override
    public void zoomRangeAxes(double lowerPercent, double upperPercent, PlotRenderingInfo state, Point2D source) {
        this.zoom((upperPercent + lowerPercent) / 2.0);
    }

    @Override
    public boolean isDomainZoomable() {
        return false;
    }

    @Override
    public boolean isRangeZoomable() {
        return true;
    }

    @Override
    public PlotOrientation getOrientation() {
        return PlotOrientation.HORIZONTAL;
    }

    public Point translateToJava2D(double angleDegrees, double radius, ValueAxis axis, Rectangle2D dataArea) {
        if (this.counterClockwise) {
            angleDegrees = -angleDegrees;
        }
        double radians = Math.toRadians(angleDegrees + this.angleOffset);
        double minx = dataArea.getMinX() + (double)this.margin;
        double maxx = dataArea.getMaxX() - (double)this.margin;
        double miny = dataArea.getMinY() + (double)this.margin;
        double maxy = dataArea.getMaxY() - (double)this.margin;
        double halfWidth = (maxx - minx) / 2.0;
        double halfHeight = (maxy - miny) / 2.0;
        double midX = minx + halfWidth;
        double midY = miny + halfHeight;
        double l = Math.min(halfWidth, halfHeight);
        Rectangle2D.Double quadrant = new Rectangle2D.Double(midX, midY, l, l);
        double axisMin = axis.getLowerBound();
        double adjustedRadius = Math.max(radius, axisMin);
        double length = axis.valueToJava2D(adjustedRadius, quadrant, RectangleEdge.BOTTOM) - midX;
        float x = (float)(midX + Math.cos(radians) * length);
        float y = (float)(midY + Math.sin(radians) * length);
        int ix = Math.round(x);
        int iy = Math.round(y);
        Point p = new Point(ix, iy);
        return p;
    }
}

