/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.internal;

import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;

public class HashUtils {
    public static int hashCodeForPaint(Paint p) {
        int result;
        if (p == null) {
            return 0;
        }
        if (p instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)p;
            result = 193;
            result = 37 * result + gp.getColor1().hashCode();
            result = 37 * result + gp.getPoint1().hashCode();
            result = 37 * result + gp.getColor2().hashCode();
            result = 37 * result + gp.getPoint2().hashCode();
        } else {
            result = p.hashCode();
        }
        return result;
    }

    public static int hashCodeForDoubleArray(double[] a) {
        if (a == null) {
            return 0;
        }
        int result = 193;
        for (double v : a) {
            long temp = Double.doubleToLongBits(v);
            result = 29 * result + (int)(temp ^ temp >>> 32);
        }
        return result;
    }

    public static int hashCode(int pre, boolean b) {
        return 37 * pre + (b ? 0 : 1);
    }

    public static int hashCode(int pre, int i) {
        return 37 * pre + i;
    }

    public static int hashCode(int pre, double d) {
        long l = Double.doubleToLongBits(d);
        return 37 * pre + (int)(l ^ l >>> 32);
    }

    public static int hashCode(int pre, Paint p) {
        return 37 * pre + HashUtils.hashCodeForPaint(p);
    }

    public static int hashCode(int pre, Stroke s) {
        int h = s != null ? s.hashCode() : 0;
        return 37 * pre + h;
    }

    public static int hashCode(int pre, String s) {
        int h = s != null ? s.hashCode() : 0;
        return 37 * pre + h;
    }

    public static int hashCode(int pre, Comparable<?> c) {
        int h = c != null ? c.hashCode() : 0;
        return 37 * pre + h;
    }

    public static int hashCode(int pre, Object obj) {
        int h = obj != null ? obj.hashCode() : 0;
        return 37 * pre + h;
    }
}

