/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.api.PublicCloneable;
import org.jfree.chart.internal.Args;

public class CloneUtils {
    public static <T> T copy(T object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        if (object instanceof PublicCloneable) {
            PublicCloneable pc = (PublicCloneable)object;
            return (T)pc.clone();
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            if (Modifier.isPublic(method.getModifiers())) {
                return (T)method.invoke(object, (Object[])null);
            }
            return object;
        }
        catch (NoSuchMethodException e) {
            return object;
        }
        catch (IllegalAccessException e) {
            throw new CloneNotSupportedException("Object.clone(): unable to call method.");
        }
        catch (InvocationTargetException e) {
            throw new CloneNotSupportedException("Object without clone() method is impossible.");
        }
    }

    public static <T> T clone(T object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        if (object instanceof PublicCloneable) {
            PublicCloneable pc = (PublicCloneable)object;
            return (T)pc.clone();
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            if (Modifier.isPublic(method.getModifiers())) {
                return (T)method.invoke(object, (Object[])null);
            }
        }
        catch (NoSuchMethodException e) {
            throw new CloneNotSupportedException("Object without clone() method is impossible.");
        }
        catch (IllegalAccessException e) {
            throw new CloneNotSupportedException("Object.clone(): unable to call method.");
        }
        catch (InvocationTargetException e) {
            throw new CloneNotSupportedException("Object without clone() method is impossible.");
        }
        throw new CloneNotSupportedException("Failed to clone.");
    }

    public static <T> List<T> cloneList(List<T> source) {
        Args.nullNotPermitted(source, "source");
        ArrayList<T> result = new ArrayList<T>();
        for (T obj : source) {
            try {
                result.add(CloneUtils.copy(obj));
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    public static <K, V> Map<K, V> cloneMapValues(Map<K, V> source) {
        Args.nullNotPermitted(source, "source");
        HashMap<K, V> result = new HashMap<K, V>();
        for (K key : source.keySet()) {
            V value = source.get(key);
            if (value != null) {
                try {
                    result.put(key, CloneUtils.copy(value));
                    continue;
                }
                catch (CloneNotSupportedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            result.put(key, null);
        }
        return result;
    }
}

