/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.util.Objects;
import org.jfree.chart.internal.Args;
import org.jfree.chart.text.TextAnchor;

public abstract class Tick
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6668230383875149773L;
    private String text;
    private TextAnchor textAnchor;
    private TextAnchor rotationAnchor;
    private double angle;

    public Tick(String text, TextAnchor textAnchor, TextAnchor rotationAnchor, double angle) {
        Args.nullNotPermitted((Object)textAnchor, "textAnchor");
        Args.nullNotPermitted((Object)rotationAnchor, "rotationAnchor");
        this.text = text;
        this.textAnchor = textAnchor;
        this.rotationAnchor = rotationAnchor;
        this.angle = angle;
    }

    public String getText() {
        return this.text;
    }

    public TextAnchor getTextAnchor() {
        return this.textAnchor;
    }

    public TextAnchor getRotationAnchor() {
        return this.rotationAnchor;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tick) {
            Tick t = (Tick)obj;
            if (!Objects.equals(this.text, t.text)) {
                return false;
            }
            if (!Objects.equals((Object)this.textAnchor, (Object)t.textAnchor)) {
                return false;
            }
            if (!Objects.equals((Object)this.rotationAnchor, (Object)t.rotationAnchor)) {
                return false;
            }
            return this.angle == t.angle;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Tick clone = (Tick)super.clone();
        return clone;
    }

    public String toString() {
        return this.text;
    }
}

