/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.internal.Args;

public class DateTickUnit
extends TickUnit
implements Serializable {
    private static final long serialVersionUID = -7289292157229621901L;
    private DateTickUnitType unitType;
    private int count;
    private DateTickUnitType rollUnitType;
    private int rollCount;
    private DateFormat formatter;

    public DateTickUnit(DateTickUnitType unitType, int multiple) {
        this(unitType, multiple, DateFormat.getDateInstance(3));
    }

    public DateTickUnit(DateTickUnitType unitType, int multiple, DateFormat formatter) {
        this(unitType, multiple, unitType, multiple, formatter);
    }

    public DateTickUnit(DateTickUnitType unitType, int multiple, DateTickUnitType rollUnitType, int rollMultiple, DateFormat formatter) {
        super(DateTickUnit.getMillisecondCount(unitType, multiple));
        Args.nullNotPermitted(formatter, "formatter");
        if (multiple <= 0) {
            throw new IllegalArgumentException("Requires 'multiple' > 0.");
        }
        if (rollMultiple <= 0) {
            throw new IllegalArgumentException("Requires 'rollMultiple' > 0.");
        }
        this.unitType = unitType;
        this.count = multiple;
        this.rollUnitType = rollUnitType;
        this.rollCount = rollMultiple;
        this.formatter = formatter;
    }

    public DateTickUnitType getUnitType() {
        return this.unitType;
    }

    public int getMultiple() {
        return this.count;
    }

    public DateTickUnitType getRollUnitType() {
        return this.rollUnitType;
    }

    public int getRollMultiple() {
        return this.rollCount;
    }

    @Override
    public String valueToString(double milliseconds) {
        return this.formatter.format(new Date((long)milliseconds));
    }

    public String dateToString(Date date) {
        return this.formatter.format(date);
    }

    public Date addToDate(Date base, TimeZone zone) {
        Calendar calendar = Calendar.getInstance(zone);
        calendar.setTime(base);
        calendar.add(this.unitType.getCalendarField(), this.count);
        return calendar.getTime();
    }

    public Date rollDate(Date base) {
        return this.rollDate(base, TimeZone.getDefault());
    }

    public Date rollDate(Date base, TimeZone zone) {
        Calendar calendar = Calendar.getInstance(zone);
        calendar.setTime(base);
        calendar.add(this.rollUnitType.getCalendarField(), this.rollCount);
        return calendar.getTime();
    }

    public int getCalendarField() {
        return this.unitType.getCalendarField();
    }

    private static long getMillisecondCount(DateTickUnitType unit, int count) {
        if (unit.equals((Object)DateTickUnitType.YEAR)) {
            return 31536000000L * (long)count;
        }
        if (unit.equals((Object)DateTickUnitType.MONTH)) {
            return 2678400000L * (long)count;
        }
        if (unit.equals((Object)DateTickUnitType.DAY)) {
            return 86400000L * (long)count;
        }
        if (unit.equals((Object)DateTickUnitType.HOUR)) {
            return 3600000L * (long)count;
        }
        if (unit.equals((Object)DateTickUnitType.MINUTE)) {
            return 60000L * (long)count;
        }
        if (unit.equals((Object)DateTickUnitType.SECOND)) {
            return 1000L * (long)count;
        }
        if (unit.equals((Object)DateTickUnitType.MILLISECOND)) {
            return count;
        }
        throw new IllegalArgumentException("The 'unit' argument has a value that is not recognised.");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DateTickUnit)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DateTickUnit that = (DateTickUnit)obj;
        if (!this.unitType.equals((Object)that.unitType)) {
            return false;
        }
        if (this.count != that.count) {
            return false;
        }
        return Objects.equals(this.formatter, that.formatter);
    }

    @Override
    public int hashCode() {
        int result = 19;
        result = 37 * result + this.unitType.hashCode();
        result = 37 * result + this.count;
        result = 37 * result + this.formatter.hashCode();
        return result;
    }

    public String toString() {
        return "DateTickUnit[" + this.unitType.toString() + ", " + this.count + "]";
    }
}

