/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.api.RectangleEdge;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.internal.Args;

public class AxisState {
    private double cursor;
    private List<ValueTick> ticks;
    private double max;

    public AxisState() {
        this(0.0);
    }

    public AxisState(double cursor) {
        this.cursor = cursor;
        this.ticks = new ArrayList<ValueTick>();
    }

    public double getCursor() {
        return this.cursor;
    }

    public void setCursor(double cursor) {
        this.cursor = cursor;
    }

    public void moveCursor(double units, RectangleEdge edge) {
        Args.nullNotPermitted((Object)edge, "edge");
        switch (edge) {
            case TOP: {
                this.cursorUp(units);
                break;
            }
            case BOTTOM: {
                this.cursorDown(units);
                break;
            }
            case LEFT: {
                this.cursorLeft(units);
                break;
            }
            case RIGHT: {
                this.cursorRight(units);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected enum value " + edge);
            }
        }
    }

    public void cursorUp(double units) {
        this.cursor -= units;
    }

    public void cursorDown(double units) {
        this.cursor += units;
    }

    public void cursorLeft(double units) {
        this.cursor -= units;
    }

    public void cursorRight(double units) {
        this.cursor += units;
    }

    public List<ValueTick> getTicks() {
        return this.ticks;
    }

    public void setTicks(List<ValueTick> ticks) {
        this.ticks = ticks;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }
}

