/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.api;

import java.awt.geom.Rectangle2D;

public enum RectangleEdge {
    TOP,
    BOTTOM,
    LEFT,
    RIGHT;


    public static boolean isTopOrBottom(RectangleEdge edge) {
        return edge == TOP || edge == BOTTOM;
    }

    public static boolean isLeftOrRight(RectangleEdge edge) {
        return edge == LEFT || edge == RIGHT;
    }

    public static RectangleEdge opposite(RectangleEdge edge) {
        switch (edge) {
            case TOP: {
                return BOTTOM;
            }
            case BOTTOM: {
                return TOP;
            }
            case LEFT: {
                return RIGHT;
            }
            case RIGHT: {
                return LEFT;
            }
        }
        return null;
    }

    public static double coordinate(Rectangle2D rectangle, RectangleEdge edge) {
        switch (edge) {
            case TOP: {
                return rectangle.getMinY();
            }
            case BOTTOM: {
                return rectangle.getMaxY();
            }
            case LEFT: {
                return rectangle.getMinX();
            }
            case RIGHT: {
                return rectangle.getMaxX();
            }
        }
        return 0.0;
    }
}

