/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.api;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.block.Size2D;
import org.jfree.chart.internal.Args;

public enum RectangleAnchor {
    CENTER,
    TOP,
    TOP_LEFT,
    TOP_RIGHT,
    BOTTOM,
    BOTTOM_LEFT,
    BOTTOM_RIGHT,
    LEFT,
    RIGHT;


    public Point2D getAnchorPoint(Rectangle2D rectangle) {
        Args.nullNotPermitted(rectangle, "rectangle");
        Point2D.Double result = new Point2D.Double();
        switch (this) {
            case CENTER: {
                ((Point2D)result).setLocation(rectangle.getCenterX(), rectangle.getCenterY());
                break;
            }
            case TOP: {
                ((Point2D)result).setLocation(rectangle.getCenterX(), rectangle.getMinY());
                break;
            }
            case BOTTOM: {
                ((Point2D)result).setLocation(rectangle.getCenterX(), rectangle.getMaxY());
                break;
            }
            case LEFT: {
                ((Point2D)result).setLocation(rectangle.getMinX(), rectangle.getCenterY());
                break;
            }
            case RIGHT: {
                ((Point2D)result).setLocation(rectangle.getMaxX(), rectangle.getCenterY());
                break;
            }
            case TOP_LEFT: {
                ((Point2D)result).setLocation(rectangle.getMinX(), rectangle.getMinY());
                break;
            }
            case TOP_RIGHT: {
                ((Point2D)result).setLocation(rectangle.getMaxX(), rectangle.getMinY());
                break;
            }
            case BOTTOM_LEFT: {
                ((Point2D)result).setLocation(rectangle.getMinX(), rectangle.getMaxY());
                break;
            }
            case BOTTOM_RIGHT: {
                ((Point2D)result).setLocation(rectangle.getMaxX(), rectangle.getMaxY());
                break;
            }
        }
        return result;
    }

    public static Rectangle2D createRectangle(Size2D dimensions, double anchorX, double anchorY, RectangleAnchor anchor) {
        Args.nullNotPermitted(dimensions, "dimensions");
        Args.nullNotPermitted((Object)anchor, "anchor");
        Rectangle2D.Double result = null;
        double w = dimensions.getWidth();
        double h = dimensions.getHeight();
        switch (anchor) {
            case CENTER: {
                result = new Rectangle2D.Double(anchorX - w / 2.0, anchorY - h / 2.0, w, h);
                break;
            }
            case TOP: {
                result = new Rectangle2D.Double(anchorX - w / 2.0, anchorY, w, h);
                break;
            }
            case BOTTOM: {
                result = new Rectangle2D.Double(anchorX - w / 2.0, anchorY - h, w, h);
                break;
            }
            case LEFT: {
                result = new Rectangle2D.Double(anchorX, anchorY - h / 2.0, w, h);
                break;
            }
            case RIGHT: {
                result = new Rectangle2D.Double(anchorX - w, anchorY - h / 2.0, w, h);
                break;
            }
            case TOP_LEFT: {
                result = new Rectangle2D.Double(anchorX, anchorY, w, h);
                break;
            }
            case TOP_RIGHT: {
                result = new Rectangle2D.Double(anchorX - w, anchorY, w, h);
                break;
            }
            case BOTTOM_LEFT: {
                result = new Rectangle2D.Double(anchorX, anchorY - h, w, h);
                break;
            }
            case BOTTOM_RIGHT: {
                result = new Rectangle2D.Double(anchorX - w, anchorY - h, w, h);
                break;
            }
        }
        return result;
    }
}

