/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.api;

import java.awt.geom.Rectangle2D;
import org.jfree.chart.internal.Args;

public enum RectangleAlignment {
    FILL,
    FILL_VERTICAL,
    FILL_HORIZONTAL,
    TOP_LEFT,
    TOP_CENTER,
    TOP_RIGHT,
    CENTER_LEFT,
    CENTER,
    CENTER_RIGHT,
    BOTTOM_LEFT,
    BOTTOM_CENTER,
    BOTTOM_RIGHT;


    public void align(Rectangle2D rect, Rectangle2D frame) {
        Args.nullNotPermitted(rect, "rect");
        Args.nullNotPermitted(frame, "frame");
        double x = rect.getX();
        double y = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        switch (this) {
            case BOTTOM_CENTER: {
                x = frame.getCenterX() - rect.getWidth() / 2.0;
                y = frame.getMaxY() - h;
                break;
            }
            case BOTTOM_LEFT: {
                x = frame.getX();
                y = frame.getMaxY() - h;
                break;
            }
            case BOTTOM_RIGHT: {
                x = frame.getMaxX() - w;
                y = frame.getMaxY() - h;
                break;
            }
            case CENTER: {
                x = frame.getCenterX() - rect.getWidth() / 2.0;
                y = frame.getCenterY() - rect.getHeight() / 2.0;
                break;
            }
            case FILL: {
                x = frame.getX();
                y = frame.getY();
                w = frame.getWidth();
                h = frame.getHeight();
                break;
            }
            case FILL_HORIZONTAL: {
                x = frame.getX();
                w = frame.getWidth();
                break;
            }
            case FILL_VERTICAL: {
                y = frame.getY();
                h = frame.getHeight();
                break;
            }
            case CENTER_LEFT: {
                x = frame.getX();
                y = frame.getCenterY() - rect.getHeight() / 2.0;
                break;
            }
            case CENTER_RIGHT: {
                x = frame.getMaxX() - w;
                y = frame.getCenterY() - rect.getHeight() / 2.0;
                break;
            }
            case TOP_CENTER: {
                x = frame.getCenterX() - rect.getWidth() / 2.0;
                y = frame.getY();
                break;
            }
            case TOP_LEFT: {
                x = frame.getX();
                y = frame.getY();
                break;
            }
            case TOP_RIGHT: {
                x = frame.getMaxX() - w;
                y = frame.getY();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected RectangleAlignment value");
            }
        }
        rect.setRect(x, y, w, h);
    }
}

