/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.gui;

import jade.tools.gui.ACLSLTokenMarker;
import jade.tools.gui.ACLSyntaxUtilities;
import jade.tools.gui.ACLSytntaxStyle;
import jade.tools.gui.ACLTextArea;
import jade.tools.gui.ACLToken;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class ACLTextAreaPainter
extends JComponent
implements TabExpander {
    protected static boolean copyAreaBroken;
    protected ACLTextArea textArea;
    protected ACLSytntaxStyle[] styles;
    protected Color caretColor;
    protected Color selectionColor;
    protected Color lineHighlightColor;
    protected Color bracketHighlightColor;
    protected Color eolMarkerColor;
    protected boolean blockCaret;
    protected boolean lineHighlight;
    protected boolean bracketHighlight;
    protected boolean eolMarkers;
    protected int cols;
    protected int rows;
    protected int tabSize;
    protected FontMetrics fm;
    protected Graphics offGfx;
    protected Image offImg;
    protected int firstInvalid;
    protected int lastInvalid;
    int currentLineIndex;
    ACLToken currentLineTokens;
    Segment currentLine;

    public ACLTextAreaPainter(ACLTextArea textArea) {
        this.textArea = textArea;
        this.currentLine = new Segment();
        this.currentLineIndex = -1;
        this.lastInvalid = -1;
        this.firstInvalid = -1;
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setFont(new Font("Dialog", 0, 11));
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.styles = ACLSyntaxUtilities.getDefaultSyntaxStyles(this);
        this.cols = 80;
        this.rows = 5;
        this.caretColor = Color.red;
        this.selectionColor = new Color(0xCCCCFF);
        this.lineHighlightColor = new Color(0xE0E0E0);
        this.lineHighlight = true;
        this.bracketHighlightColor = Color.black;
        this.bracketHighlight = true;
        this.eolMarkerColor = new Color(39321);
        this.eolMarkers = true;
        copyAreaBroken = true;
    }

    @Override
    public final boolean isManagingFocus() {
        return false;
    }

    public final ACLSytntaxStyle[] getStyles() {
        return this.styles;
    }

    public final Color getCaretColor() {
        return this.caretColor;
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public final boolean isLineHighlightEnabled() {
        return this.lineHighlight;
    }

    public final Color getBracketHighlightColor() {
        return this.bracketHighlightColor;
    }

    public final boolean isBracketHighlightEnabled() {
        return this.bracketHighlight;
    }

    public final boolean isBlockCaretEnabled() {
        return this.blockCaret;
    }

    public final Color getEOLMarkerColor() {
        return this.eolMarkerColor;
    }

    public final boolean isEOLMarkerEnabled() {
        return this.eolMarkers;
    }

    public final void setStyles(ACLSytntaxStyle[] styles) {
        this.styles = styles;
        this.invalidateOffscreen();
        this.repaint();
    }

    public final void setCaretColor(Color caretColor) {
        this.caretColor = caretColor;
        this.invalidateSelectedLines();
    }

    public final void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
        this.invalidateSelectedLines();
    }

    public final void setLineHighlightColor(Color lineHighlightColor) {
        this.lineHighlightColor = lineHighlightColor;
        this.invalidateSelectedLines();
    }

    public final void setLineHighlightEnabled(boolean lineHighlight) {
        this.lineHighlight = lineHighlight;
        this.invalidateSelectedLines();
    }

    public final void setBracketHighlightColor(Color bracketHighlightColor) {
        this.bracketHighlightColor = bracketHighlightColor;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public final void setBracketHighlightEnabled(boolean bracketHighlight) {
        this.bracketHighlight = bracketHighlight;
        this.invalidateLine(this.textArea.getBracketLine());
    }

    public final void setBlockCaretEnabled(boolean blockCaret) {
        this.blockCaret = blockCaret;
        this.invalidateSelectedLines();
    }

    public final void setEOLMarkerColor(Color eolMarkerColor) {
        this.eolMarkerColor = eolMarkerColor;
        this.invalidateOffscreen();
        this.repaint();
    }

    public final void setEOLMarkerEnabled(boolean eolMarkers) {
        this.eolMarkers = eolMarkers;
        this.invalidateOffscreen();
        this.repaint();
    }

    public final void fastRepaint() {
        if (this.firstInvalid == -1 && this.lastInvalid == -1) {
            this.repaint();
        } else {
            this.repaint(0, this.textArea.lineToY(this.firstInvalid) + this.fm.getLeading() + this.fm.getMaxDescent(), this.getWidth(), (this.lastInvalid - this.firstInvalid + 1) * this.fm.getHeight());
        }
    }

    public final void invalidateLine(int line) {
        this._invalidateLine(line);
        this.fastRepaint();
    }

    public final void invalidateLineRange(int firstLine, int lastLine) {
        this._invalidateLineRange(firstLine, lastLine);
        this.fastRepaint();
    }

    public final void invalidateSelectedLines() {
        this.invalidateLineRange(this.textArea.getSelectionStartLine(), this.textArea.getSelectionEndLine());
    }

    public final void invalidateOffscreen() {
        this.offImg = null;
        this.offGfx = null;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public boolean isCopyAreaBroken() {
        return copyAreaBroken;
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getMinimumSize();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.textArea.getFontMetrics(font);
        this.textArea.recalculateVisibleLines();
    }

    public void setCopyAreaBroken(boolean copyAreaBroken) {
        ACLTextAreaPainter.copyAreaBroken = copyAreaBroken;
    }

    @Override
    public void update(Graphics g) {
        this.tabSize = this.fm.charWidth('w') * (Integer)this.textArea.getDocument().getProperty("tabSize");
        if (this.ensureOffscreenValid()) {
            this.firstInvalid = this.textArea.getFirstLine();
            this.lastInvalid = this.firstInvalid + this.textArea.getVisibleLines();
        }
        if (this.firstInvalid != -1 && this.lastInvalid != -1) {
            try {
                Rectangle clip;
                int lineCount = this.firstInvalid == this.lastInvalid ? this.offscreenRepaintLine(this.firstInvalid, this.textArea.getHorizontalOffset()) : this.offscreenRepaintLineRange(this.firstInvalid, this.lastInvalid);
                if (this.lastInvalid - this.firstInvalid + 1 != lineCount && !(clip = g.getClipBounds()).equals(this.getBounds())) {
                    this.repaint();
                }
            }
            catch (Exception e) {
                System.err.println("Error repainting line range {" + this.firstInvalid + "," + this.lastInvalid + "}:");
                e.printStackTrace();
            }
            this.lastInvalid = -1;
            this.firstInvalid = -1;
        }
        g.drawImage(this.offImg, 0, 0, null);
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    public void _invalidateLine(int line) {
        int firstVisible = this.textArea.getFirstLine();
        int lastVisible = firstVisible + this.textArea.getVisibleLines();
        if (line < firstVisible || line > lastVisible) {
            return;
        }
        if (line >= this.firstInvalid && line <= this.lastInvalid) {
            return;
        }
        if (this.firstInvalid == -1 && this.lastInvalid == -1) {
            this.firstInvalid = this.lastInvalid = line;
        } else {
            this.firstInvalid = Math.min(line, this.firstInvalid);
            this.lastInvalid = Math.max(line, this.lastInvalid);
        }
    }

    public void _invalidateLineRange(int firstLine, int lastLine) {
        int firstVisible = this.textArea.getFirstLine();
        int lastVisible = firstVisible + this.textArea.getVisibleLines();
        if (firstLine > lastLine) {
            int tmp = firstLine;
            firstLine = lastLine;
            lastLine = tmp;
        }
        if (lastLine < firstVisible || firstLine > lastVisible) {
            return;
        }
        if (this.firstInvalid == -1 && this.lastInvalid == -1) {
            this.firstInvalid = firstLine;
            this.lastInvalid = lastLine;
        } else {
            if (firstLine >= this.firstInvalid && lastLine <= this.lastInvalid) {
                return;
            }
            this.firstInvalid = Math.min(this.firstInvalid, firstLine);
            this.lastInvalid = Math.max(this.lastInvalid, lastLine);
        }
        this.firstInvalid = Math.max(this.firstInvalid, firstVisible);
        this.lastInvalid = Math.min(this.lastInvalid, lastVisible);
    }

    public void scrollRepaint(int oldFirstLine, int newFirstLine) {
        if (this.offGfx == null) {
            return;
        }
        int visibleLines = this.textArea.getVisibleLines();
        if (copyAreaBroken || oldFirstLine + visibleLines <= newFirstLine || newFirstLine + visibleLines <= oldFirstLine) {
            this._invalidateLineRange(newFirstLine, newFirstLine + visibleLines + 1);
        } else {
            int y = this.fm.getHeight() * (oldFirstLine - newFirstLine);
            this.offGfx.copyArea(0, 0, this.offImg.getWidth(this), this.offImg.getHeight(this), 0, y);
            if (oldFirstLine < newFirstLine) {
                this._invalidateLineRange(oldFirstLine + visibleLines - 1, newFirstLine + visibleLines + 1);
            } else {
                this._invalidateLineRange(newFirstLine, oldFirstLine);
            }
        }
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        int offset = this.textArea.getHorizontalOffset();
        int ntabs = ((int)x - offset) / this.tabSize;
        return (ntabs + 1) * this.tabSize + offset;
    }

    protected boolean ensureOffscreenValid() {
        if (this.offImg == null || this.offGfx == null) {
            this.offImg = this.textArea.createImage(this.getWidth(), this.getHeight());
            this.offGfx = this.offImg.getGraphics();
            return true;
        }
        return false;
    }

    protected int offscreenRepaintLineRange(int firstLine, int lastLine) {
        int line;
        if (this.offGfx == null) {
            return 0;
        }
        int x = this.textArea.getHorizontalOffset();
        for (line = firstLine; line <= lastLine; line += this.offscreenRepaintLine(line, x)) {
        }
        return line - firstLine;
    }

    protected int offscreenRepaintLine(int line, int x) {
        ACLSLTokenMarker tokenMarker = this.textArea.getTokenMarker();
        Font defaultFont = this.getFont();
        Color defaultColor = this.getForeground();
        int y = this.textArea.lineToY(line);
        if (line < 0 || line >= this.textArea.getLineCount()) {
            this.paintHighlight(line, y);
            this.styles[10].setGraphicsFlags(this.offGfx, defaultFont);
            this.offGfx.drawString(".", 0, y + this.fm.getHeight());
            return 1;
        }
        if (tokenMarker == null) {
            this.currentLineIndex = line;
            this.paintPlainLine(line, defaultFont, defaultColor, x, y);
            return 1;
        }
        int count = 0;
        int lastVisibleLine = Math.min(this.textArea.getLineCount(), this.textArea.getFirstLine() + this.textArea.getVisibleLines());
        do {
            this.currentLineIndex = line + count;
            this.paintSyntaxLine(tokenMarker, this.currentLineIndex, defaultFont, defaultColor, x, y);
            y += this.fm.getHeight();
        } while (tokenMarker.isNextLineRequested() && line + ++count < lastVisibleLine);
        return count;
    }

    protected void paintPlainLine(int line, Font defaultFont, Color defaultColor, int x, int y) {
        this.paintHighlight(line, y);
        this.textArea.getLineText(line, this.currentLine);
        this.offGfx.setFont(defaultFont);
        this.offGfx.setColor(defaultColor);
        x = Utilities.drawTabbedText(this.currentLine, x, y += this.fm.getHeight(), this.offGfx, (TabExpander)this, 0);
        if (this.eolMarkers) {
            this.offGfx.setColor(this.eolMarkerColor);
            this.offGfx.drawString(".", x, y);
        }
    }

    protected void paintSyntaxLine(ACLSLTokenMarker tokenMarker, int line, Font defaultFont, Color defaultColor, int x, int y) {
        this.textArea.getLineText(this.currentLineIndex, this.currentLine);
        this.currentLineTokens = tokenMarker.markTokens(this.currentLine, this.currentLineIndex);
        this.paintHighlight(line, y);
        this.offGfx.setFont(defaultFont);
        this.offGfx.setColor(defaultColor);
        this.styles = ACLSyntaxUtilities.getDefaultSyntaxStyles(this);
        x = ACLSyntaxUtilities.paintSyntaxLine(this.currentLine, this.currentLineTokens, this.styles, this, this.offGfx, x, y += this.fm.getHeight());
        if (this.eolMarkers) {
            this.offGfx.setColor(this.eolMarkerColor);
            this.offGfx.drawString(".", x, y);
        }
    }

    protected void paintHighlight(int line, int y) {
        int gap = this.fm.getMaxDescent() + this.fm.getLeading();
        this.offGfx.setColor(this.getBackground());
        this.offGfx.fillRect(0, y + gap, this.offImg.getWidth(this), this.fm.getHeight());
        if (line >= this.textArea.getSelectionStartLine() && line <= this.textArea.getSelectionEndLine()) {
            this.paintLineHighlight(line, y);
        }
        if (this.bracketHighlight && line == this.textArea.getBracketLine()) {
            this.paintBracketHighlight(line, y);
        }
        if (line == this.textArea.getCaretLine()) {
            this.paintCaret(line, y);
        }
    }

    protected void paintLineHighlight(int line, int y) {
        int selectionEnd;
        int height = this.fm.getHeight();
        y += this.fm.getLeading() + this.fm.getMaxDescent();
        int selectionStart = this.textArea.getSelectionStart();
        if (selectionStart == (selectionEnd = this.textArea.getSelectionEnd())) {
            if (this.lineHighlight) {
                this.offGfx.setColor(this.lineHighlightColor);
                this.offGfx.fillRect(0, y, this.offImg.getWidth(this), height);
            } else {
                int x2;
                int x1;
                this.offGfx.setColor(this.selectionColor);
                int selectionStartLine = this.textArea.getSelectionStartLine();
                int selectionEndLine = this.textArea.getSelectionEndLine();
                int lineStart = this.textArea.getLineStartOffset(line);
                if (selectionStartLine == selectionEndLine) {
                    x1 = this.textArea.offsetToX(line, selectionStart - lineStart);
                    x2 = this.textArea.offsetToX(line, selectionEnd - lineStart);
                } else if (line == selectionStartLine) {
                    x1 = this.textArea.offsetToX(line, selectionStart - lineStart);
                    x2 = this.offImg.getWidth(this);
                } else if (line == selectionEndLine) {
                    x1 = 0;
                    x2 = this.textArea.offsetToX(line, selectionEnd - lineStart);
                } else {
                    x1 = 0;
                    x2 = this.offImg.getWidth(this);
                }
                this.offGfx.fillRect(x1, y, x2 - x1, height);
            }
        }
    }

    protected void paintBracketHighlight(int line, int y) {
        int position = this.textArea.getBracketPosition();
        if (position == -1) {
            return;
        }
        int x = this.textArea.offsetToX(line, position);
        this.offGfx.setColor(this.bracketHighlightColor);
        this.offGfx.drawRect(x, y += this.fm.getLeading() + this.fm.getMaxDescent(), this.fm.charWidth('(') - 1, this.fm.getHeight() - 1);
    }

    protected void paintCaret(int line, int y) {
        if (this.textArea.isCaretVisible()) {
            int offset = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(line);
            int caretX = this.textArea.offsetToX(line, offset);
            int caretWidth = this.blockCaret || this.textArea.isOverwriteEnabled() ? this.fm.charWidth('w') : 1;
            y += this.fm.getLeading() + this.fm.getMaxDescent();
            int height = this.fm.getHeight();
            this.offGfx.setColor(this.caretColor);
            if (this.textArea.isOverwriteEnabled()) {
                this.offGfx.fillRect(caretX, y + height - 1, caretWidth, 1);
            } else {
                this.offGfx.drawRect(caretX, y, caretWidth - 1, height - 1);
            }
        }
    }
}

