/*
 * Decompiled with CFR 0.152.
 */
package jade.tools;

import jade.content.lang.sl.SLCodec;
import jade.core.Agent;
import jade.core.ServiceException;
import jade.core.event.ContainerAdapter;
import jade.core.event.ContainerEvent;
import jade.core.event.ContainerListener;
import jade.core.event.NotificationHelper;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.IntrospectionOntology;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;

public abstract class ToolAgent
extends Agent {
    private ACLMessage AMSSubscription = new ACLMessage(19);
    private ACLMessage AMSCancellation = new ACLMessage(2);
    private transient ContainerListener myContainerListener = null;
    protected transient Logger logger;

    protected void toolSetup() {
    }

    protected void toolTakeDown() {
    }

    protected ACLMessage getSubscribe() {
        return this.AMSSubscription;
    }

    protected ACLMessage getCancel() {
        return this.AMSCancellation;
    }

    protected ACLMessage getRequest() {
        ACLMessage AMSRequest = new ACLMessage(16);
        AMSRequest.setSender(this.getAID());
        AMSRequest.addReceiver(this.getAMS());
        AMSRequest.setProtocol("fipa-request");
        AMSRequest.setLanguage("fipa-sl0");
        return AMSRequest;
    }

    @Override
    public final void setup() {
        this.init();
        this.AMSSubscription.setSender(this.getAID());
        this.AMSSubscription.clearAllReceiver();
        this.AMSSubscription.addReceiver(this.getAMS());
        this.AMSSubscription.setLanguage("fipa-sl0");
        this.AMSSubscription.setOntology("JADE-Introspection");
        this.AMSSubscription.setReplyWith("tool-subscription");
        this.AMSSubscription.setConversationId(this.getLocalName());
        this.AMSSubscription.setContent("platform-events");
        this.AMSCancellation.setSender(this.getAID());
        this.AMSCancellation.clearAllReceiver();
        this.AMSCancellation.addReceiver(this.getAMS());
        this.AMSCancellation.setLanguage("fipa-sl0");
        this.AMSCancellation.setOntology("JADE-Introspection");
        this.AMSCancellation.setReplyWith("tool-cancellation");
        this.AMSCancellation.setConversationId(this.getLocalName());
        this.toolSetup();
    }

    @Override
    protected final void takeDown() {
        this.clean();
        this.toolTakeDown();
    }

    @Override
    protected void afterClone() {
        this.init();
    }

    @Override
    protected void beforeMove() {
        this.clean();
    }

    @Override
    protected void afterMove() {
        this.init();
    }

    protected void afterLoad() {
        this.init();
    }

    protected void afterThaw() {
        this.init();
    }

    protected void afterReload() {
        this.init();
    }

    protected void beforeSave() {
    }

    protected void beforeFreeze() {
        this.clean();
    }

    protected void beforeReload() {
        this.clean();
    }

    private void init() {
        this.logger = Logger.getMyLogger(this.getName());
        this.getContentManager().registerOntology(JADEManagementOntology.getInstance());
        this.getContentManager().registerOntology(IntrospectionOntology.getInstance());
        this.getContentManager().registerOntology(FIPAManagementOntology.getInstance());
        SLCodec codec = new SLCodec();
        this.getContentManager().registerLanguage(codec, "fipa-sl0");
        this.getContentManager().registerLanguage(codec, "fipa-sl1");
        this.getContentManager().registerLanguage(codec, "fipa-sl2");
        this.getContentManager().registerLanguage(codec, "fipa-sl");
        try {
            NotificationHelper helper = (NotificationHelper)this.getHelper("jade.core.event.Notification");
            this.myContainerListener = new ContainerAdapter(){

                @Override
                public void reattached(ContainerEvent ev) {
                    ToolAgent.this.send(ToolAgent.this.getSubscribe());
                }
            };
            helper.registerContainerListener(this.myContainerListener);
        }
        catch (ServiceException se) {
            this.logger.log(Logger.WARNING, "NotificationService not installed. Some tool may not work properly.");
        }
    }

    private void clean() {
        if (this.myContainerListener != null) {
            try {
                NotificationHelper helper = (NotificationHelper)this.getHelper("jade.core.event.Notification");
                helper.deregisterContainerListener(this.myContainerListener);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
    }

    protected abstract class AMSListenerBehaviour
    extends AMSSubscriber {
        protected AMSListenerBehaviour() {
        }

        @Override
        public void onStart() {
        }
    }

    public static interface EventHandler
    extends AMSSubscriber.EventHandler {
    }
}

