/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.SocketProxyAgent;

import jade.core.Agent;
import jade.core.behaviours.SimpleBehaviour;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.util.Logger;
import java.io.PrintStream;
import java.util.Date;

class WaitAnswersBehaviour
extends SimpleBehaviour {
    ACLMessage msg;
    PrintStream out;
    long timeout;
    private static final long ONE_SEC_AS_MS = 1000L;
    private static final long TEN_SEC_AS_MS = 10000L;
    static final long DEFAULT_TIMEOUT = 10000L;
    boolean finished;
    MessageTemplate mt;
    Agent myAgent = null;
    private String myThreadName;
    private static final Logger logger = Logger.getMyLogger(WaitAnswersBehaviour.class.getName());

    WaitAnswersBehaviour(Agent a, ACLMessage m, PrintStream o) {
        super(a);
        this.myAgent = a;
        this.out = o;
        this.myThreadName = Thread.currentThread().getName();
        this.mt = MessageTemplate.MatchInReplyTo(m.getReplyWith());
        Date d = m.getReplyByDate();
        if (d != null) {
            this.timeout = d.getTime() - new Date().getTime();
            if (this.timeout <= 1000L) {
                this.timeout = 1000L;
            }
        } else {
            this.timeout = 10000L;
        }
        this.finished = false;
        logger.log(Logger.CONFIG, this.myThreadName + ": Constructed " + this.getClass().getName() + " using message template " + this.mt + " and timeout " + this.timeout + " to wait for answer to:" + m);
    }

    @Override
    public void action() {
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, this.myThreadName + ": About to block, message template " + this.mt + ", timeout " + this.timeout + "ms, waiting for reply...");
        }
        this.msg = this.myAgent.blockingReceive(this.mt, this.timeout);
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, this.myThreadName + ": No longer blocked");
        }
        if (this.msg == null) {
            logger.log(Logger.INFO, this.myThreadName + ": Reply was null");
            this.msg = new ACLMessage(6);
            this.msg.setContent("( \"Timed-out waiting for response from agent\" )");
        }
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, this.myThreadName + ": writing reply...:" + this.msg);
        }
        this.out.print(this.msg.toString());
        this.out.flush();
        boolean bl = this.finished = this.msg.getPerformative() != 1;
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, this.myThreadName + ": set finished=" + this.finished);
        }
    }

    @Override
    public boolean done() {
        return this.finished;
    }
}

