/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.proto.Initiator;
import jade.util.leap.Serializable;
import java.util.Vector;

public class TwoPh2Initiator
extends Initiator {
    public final String ACCEPTANCE_KEY;
    public final String ALL_ACCEPTANCES_KEY;
    public final String REPLY_KEY;
    public final String ALL_RESPONSES_KEY;
    public final String ALL_INFORMS_KEY;
    public final String ALL_PENDINGS_KEY;
    private static final String HANDLE_INFORM = "Handle-Inform";
    private static final String HANDLE_OLD_RESPONSE = "Handle-old-response";
    private static final String HANDLE_ALL_RESPONSES = "Handle-all-responses";
    private static final int OLD_RESPONSE = 1000;
    private static final int ALL_RESPONSES_RECEIVED = 1;
    private String[] toBeReset;

    public TwoPh2Initiator(Agent a, ACLMessage acceptance) {
        this(a, acceptance, new DataStore());
    }

    public TwoPh2Initiator(Agent a, ACLMessage acceptance, DataStore store) {
        super(a, acceptance, store);
        this.ACCEPTANCE_KEY = this.INITIATION_K;
        this.ALL_ACCEPTANCES_KEY = this.ALL_INITIATIONS_K;
        this.REPLY_KEY = this.REPLY_K;
        this.ALL_RESPONSES_KEY = "__all-responses" + this.hashCode();
        this.ALL_INFORMS_KEY = "__all-informs" + this.hashCode();
        this.ALL_PENDINGS_KEY = "__all-pendings" + this.hashCode();
        this.toBeReset = null;
        this.registerTransition("Check-in-seq", HANDLE_INFORM, 7);
        this.registerTransition("Check-in-seq", HANDLE_OLD_RESPONSE, 1000);
        this.registerDefaultTransition(HANDLE_INFORM, "Check-sessions");
        this.registerDefaultTransition(HANDLE_OLD_RESPONSE, "Check-sessions");
        this.registerTransition("Check-sessions", HANDLE_ALL_RESPONSES, 1);
        this.registerDefaultTransition(HANDLE_ALL_RESPONSES, "Dummy-final");
        OneShotBehaviour b = null;
        b = new OneShotBehaviour(this.myAgent){
            int ret;

            @Override
            public void action() {
                ACLMessage reply = (ACLMessage)this.getDataStore().get(TwoPh2Initiator.this.REPLY_K);
                String inReplyTo = reply.getInReplyTo();
                String phase = inReplyTo.substring(inReplyTo.length() - 3);
                if (phase.equals("PH0") || phase.equals("PH1")) {
                    TwoPh2Initiator.this.oldResponse(reply);
                    this.ret = 1000;
                } else {
                    this.ret = TwoPh2Initiator.this.checkInSequence(reply) ? reply.getPerformative() : -1;
                }
            }

            @Override
            public int onEnd() {
                return this.ret;
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, "Check-in-seq");
        b = new OneShotBehaviour(this.myAgent){
            int ret;
            {
                this.ret = -1;
            }

            @Override
            public void action() {
                ACLMessage inform = (ACLMessage)this.getDataStore().get(TwoPh2Initiator.this.REPLY_KEY);
                TwoPh2Initiator.this.handleInform(inform);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_INFORM);
        b = new OneShotBehaviour(this.myAgent){

            @Override
            public void action() {
                ACLMessage old = (ACLMessage)this.getDataStore().get(TwoPh2Initiator.this.REPLY_KEY);
                TwoPh2Initiator.this.handleOldResponse(old);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_OLD_RESPONSE);
        b = new OneShotBehaviour(this.myAgent){

            @Override
            public void action() {
                Vector responses = (Vector)this.getDataStore().get(TwoPh2Initiator.this.ALL_RESPONSES_KEY);
                TwoPh2Initiator.this.handleAllResponses(responses);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_ALL_RESPONSES);
    }

    protected Vector prepareAcceptances(ACLMessage acceptance) {
        Vector<ACLMessage> v = new Vector<ACLMessage>(1);
        v.addElement(acceptance);
        return v;
    }

    protected void handleInform(ACLMessage inform) {
    }

    protected void handleOldResponse(ACLMessage old) {
    }

    protected void handleAllResponses(Vector responses) {
    }

    public void registerPrepareProposals(Behaviour b) {
        this.registerPrepareInitiations(b);
    }

    public void registerHandleInform(Behaviour b) {
        this.registerState(b, HANDLE_INFORM);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleOldResponse(Behaviour b) {
        this.registerState(b, HANDLE_OLD_RESPONSE);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResponses(Behaviour b) {
        this.registerState(b, HANDLE_ALL_RESPONSES);
        b.setDataStore(this.getDataStore());
    }

    @Override
    protected String[] getToBeReset() {
        if (this.toBeReset == null) {
            this.toBeReset = new String[]{HANDLE_INFORM, HANDLE_OLD_RESPONSE, "Handle-not-understood", "Handle-failure", "Handle-out-of-seq"};
        }
        return this.toBeReset;
    }

    @Override
    protected final Vector prepareInitiations(ACLMessage initiation) {
        return this.prepareAcceptances(initiation);
    }

    @Override
    protected final void sendInitiations(Vector initiations) {
        this.getDataStore().put(this.ALL_PENDINGS_KEY, new Vector());
        super.sendInitiations(initiations);
    }

    @Override
    protected final boolean checkInSequence(ACLMessage reply) {
        boolean ret = false;
        String inReplyTo = reply.getInReplyTo();
        Session s = (Session)this.sessions.get(inReplyTo);
        if (s != null) {
            int perf = reply.getPerformative();
            if (s.update(perf)) {
                ((Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY)).add(reply);
                if (perf == 7) {
                    ((Vector)this.getDataStore().get(this.ALL_INFORMS_KEY)).add(reply);
                }
                this.updatePendings(inReplyTo);
                ret = true;
            }
            if (s.isCompleted()) {
                this.sessions.remove(inReplyTo);
            }
        }
        return ret;
    }

    private void updatePendings(String key) {
        Vector pendings = (Vector)this.getDataStore().get(this.ALL_PENDINGS_KEY);
        for (int i = 0; i < pendings.size(); ++i) {
            ACLMessage pendingMsg = (ACLMessage)pendings.get(i);
            if (!pendingMsg.getReplyWith().equals(key)) continue;
            pendings.remove(i);
            break;
        }
    }

    private void oldResponse(ACLMessage reply) {
        String inReplyTo = reply.getInReplyTo();
        String sessionKey = inReplyTo.substring(0, inReplyTo.length() - 3) + "PH2";
        int perf = reply.getPerformative();
        if (perf == 6 || perf == 10 || perf == 5) {
            this.sessions.remove(sessionKey);
            this.updatePendings(sessionKey);
        }
    }

    @Override
    protected final int checkSessions(ACLMessage reply) {
        if (reply == null) {
            this.sessions.clear();
        }
        if (this.sessions.size() == 0) {
            return 1;
        }
        return -1;
    }

    @Override
    protected void initializeDataStore(ACLMessage msg) {
        super.initializeDataStore(msg);
        this.getDataStore().put(this.ALL_RESPONSES_KEY, new Vector());
        this.getDataStore().put(this.ALL_INFORMS_KEY, new Vector());
    }

    @Override
    protected Initiator.ProtocolSession getSession(ACLMessage msg, int sessionIndex) {
        Vector pendings = (Vector)this.getDataStore().get(this.ALL_PENDINGS_KEY);
        pendings.add(msg);
        return new Session("R" + this.hashCode() + "_" + Integer.toString(sessionIndex) + "_" + "PH2");
    }

    class Session
    implements Initiator.ProtocolSession,
    Serializable {
        static final int INIT = 0;
        static final int REPLY_RECEIVED = 1;
        private int state = 0;
        private String myId;

        public Session(String id) {
            this.myId = id;
        }

        @Override
        public String getId() {
            return this.myId;
        }

        @Override
        public boolean update(int perf) {
            if (this.state == 0) {
                switch (perf) {
                    case 6: 
                    case 7: 
                    case 10: {
                        this.state = 1;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        @Override
        public int getState() {
            return this.state;
        }

        @Override
        public boolean isCompleted() {
            return this.state == 1;
        }
    }
}

