/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import jade.proto.Initiator;
import jade.util.leap.Serializable;
import java.util.Vector;

public class TwoPh0Initiator
extends Initiator {
    public final String CFP_KEY;
    public final String ALL_CFPS_KEY;
    public final String REPLY_KEY;
    public final String ALL_RESPONSES_KEY;
    public final String ALL_PROPOSES_KEY;
    public final String ALL_PENDINGS_KEY;
    private static final String HANDLE_PROPOSE = "Handle-Propose";
    private static final String HANDLE_ALL_RESPONSES = "Handle-all-responses";
    private static final int ALL_RESPONSES_RECEIVED = 1;
    private String outputKey;
    private int totSessions;
    private String[] toBeReset;

    public TwoPh0Initiator(Agent a, ACLMessage cfp, String outputKey) {
        this(a, cfp, outputKey, new DataStore());
    }

    public TwoPh0Initiator(Agent a, ACLMessage cfp, String outputKey, DataStore store) {
        super(a, cfp, store);
        this.CFP_KEY = this.INITIATION_K;
        this.ALL_CFPS_KEY = this.ALL_INITIATIONS_K;
        this.REPLY_KEY = this.REPLY_K;
        this.ALL_RESPONSES_KEY = "__all-responses" + this.hashCode();
        this.ALL_PROPOSES_KEY = "__all-proposes" + this.hashCode();
        this.ALL_PENDINGS_KEY = "__all-pendings" + this.hashCode();
        this.outputKey = null;
        this.toBeReset = null;
        this.outputKey = outputKey;
        this.registerTransition("Check-in-seq", HANDLE_PROPOSE, 11);
        this.registerDefaultTransition(HANDLE_PROPOSE, "Check-sessions");
        this.registerTransition("Check-sessions", HANDLE_ALL_RESPONSES, 1);
        this.registerDefaultTransition(HANDLE_ALL_RESPONSES, "Dummy-final");
        OneShotBehaviour b = null;
        b = new OneShotBehaviour(this.myAgent){

            @Override
            public void action() {
                ACLMessage propose = (ACLMessage)this.getDataStore().get(TwoPh0Initiator.this.REPLY_KEY);
                TwoPh0Initiator.this.handlePropose(propose);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_PROPOSE);
        b = new OneShotBehaviour(this.myAgent){

            @Override
            public void action() {
                Vector responses = (Vector)this.getDataStore().get(TwoPh0Initiator.this.ALL_RESPONSES_KEY);
                Vector proposes = (Vector)this.getDataStore().get(TwoPh0Initiator.this.ALL_PROPOSES_KEY);
                Vector pendings = (Vector)this.getDataStore().get(TwoPh0Initiator.this.ALL_PENDINGS_KEY);
                Vector nextPhMsgs = (Vector)this.getDataStore().get(TwoPh0Initiator.this.outputKey);
                TwoPh0Initiator.this.handleAllResponses(responses, proposes, pendings, nextPhMsgs);
            }
        };
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_ALL_RESPONSES);
    }

    @Override
    public int onEnd() {
        Vector nextPhMsgs = (Vector)this.getDataStore().get(this.outputKey);
        if (nextPhMsgs.size() != 0) {
            return ((ACLMessage)nextPhMsgs.get(0)).getPerformative();
        }
        return -1;
    }

    protected Vector prepareCfps(ACLMessage cfp) {
        Vector<ACLMessage> v = new Vector<ACLMessage>(1);
        v.addElement(cfp);
        return v;
    }

    protected void handlePropose(ACLMessage propose) {
    }

    protected void handleAllResponses(Vector responses, Vector proposes, Vector pendings, Vector nextPhMsgs) {
    }

    public void registerPrepareCfps(Behaviour b) {
        this.registerPrepareInitiations(b);
    }

    public void registerHandlePropose(Behaviour b) {
        this.registerState(b, HANDLE_PROPOSE);
        b.setDataStore(this.getDataStore());
    }

    public void registerHandleAllResponses(Behaviour b) {
        this.registerState(b, HANDLE_ALL_RESPONSES);
        b.setDataStore(this.getDataStore());
    }

    @Override
    protected String[] getToBeReset() {
        if (this.toBeReset == null) {
            this.toBeReset = new String[]{HANDLE_PROPOSE, "Handle-not-understood", "Handle-failure", "Handle-out-of-seq"};
        }
        return this.toBeReset;
    }

    @Override
    protected final Vector prepareInitiations(ACLMessage initiation) {
        return this.prepareCfps(initiation);
    }

    @Override
    protected final void sendInitiations(Vector initiations) {
        this.getDataStore().put(this.ALL_PENDINGS_KEY, new Vector());
        super.sendInitiations(initiations);
        this.totSessions = this.sessions.size();
    }

    @Override
    protected final boolean checkInSequence(ACLMessage reply) {
        boolean ret = false;
        String inReplyTo = reply.getInReplyTo();
        Session s = (Session)this.sessions.get(inReplyTo);
        if (s != null) {
            int perf = reply.getPerformative();
            if (s.update(perf)) {
                ((Vector)this.getDataStore().get(this.ALL_RESPONSES_KEY)).add(reply);
                if (perf == 11) {
                    ((Vector)this.getDataStore().get(this.ALL_PROPOSES_KEY)).add(reply);
                }
                this.updatePendings(inReplyTo);
                ret = true;
            }
            if (s.isCompleted()) {
                this.sessions.remove(inReplyTo);
            }
        }
        return ret;
    }

    private void updatePendings(String key) {
        Vector pendings = (Vector)this.getDataStore().get(this.ALL_PENDINGS_KEY);
        for (int i = 0; i < pendings.size(); ++i) {
            ACLMessage pendingMsg = (ACLMessage)pendings.get(i);
            if (!pendingMsg.getReplyWith().equals(key)) continue;
            pendings.remove(i);
            break;
        }
    }

    @Override
    protected final int checkSessions(ACLMessage reply) {
        if (reply == null) {
            this.sessions.clear();
        }
        if (this.sessions.size() == 0) {
            DataStore ds = this.getDataStore();
            Vector nextPhMsgs = (Vector)ds.get(this.outputKey);
            if (nextPhMsgs.size() == 0) {
                Vector proposes = (Vector)ds.get(this.ALL_PROPOSES_KEY);
                Vector pendings = (Vector)ds.get(this.ALL_PENDINGS_KEY);
                this.fillNextPhInitiations(nextPhMsgs, proposes, pendings);
            }
            return 1;
        }
        return -1;
    }

    private void fillNextPhInitiations(Vector nextPhMsgs, Vector proposes, Vector pendings) {
        if (proposes.size() == this.totSessions) {
            for (int i = 0; i < proposes.size(); ++i) {
                ACLMessage msg = (ACLMessage)proposes.get(i);
                ACLMessage queryIf = msg.createReply();
                queryIf.setPerformative(12);
                nextPhMsgs.add(queryIf);
            }
        } else {
            ACLMessage reject;
            ACLMessage msg;
            int i;
            for (i = 0; i < proposes.size(); ++i) {
                msg = (ACLMessage)proposes.get(i);
                reject = msg.createReply();
                reject.setPerformative(15);
                nextPhMsgs.add(reject);
            }
            for (i = 0; i < pendings.size(); ++i) {
                msg = (ACLMessage)pendings.get(i);
                reject = (ACLMessage)msg.clone();
                reject.setPerformative(15);
                nextPhMsgs.add(reject);
            }
        }
    }

    @Override
    protected void initializeDataStore(ACLMessage msg) {
        super.initializeDataStore(msg);
        this.getDataStore().put(this.ALL_RESPONSES_KEY, new Vector());
        this.getDataStore().put(this.ALL_PROPOSES_KEY, new Vector());
        this.getDataStore().put(this.outputKey, new Vector());
    }

    @Override
    protected Initiator.ProtocolSession getSession(ACLMessage msg, int sessionIndex) {
        Vector pendings = (Vector)this.getDataStore().get(this.ALL_PENDINGS_KEY);
        pendings.add(msg);
        return new Session("R" + this.hashCode() + "_" + Integer.toString(sessionIndex) + "_" + "PH0");
    }

    class Session
    implements Initiator.ProtocolSession,
    Serializable {
        static final int INIT = 0;
        static final int REPLY_RECEIVED = 1;
        private int state = 0;
        private String myId;

        public Session(String id) {
            this.myId = id;
        }

        @Override
        public String getId() {
            return this.myId;
        }

        @Override
        public boolean update(int perf) {
            if (this.state == 0) {
                switch (perf) {
                    case 6: 
                    case 10: 
                    case 11: {
                        this.state = 1;
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        @Override
        public int getState() {
            return this.state;
        }

        @Override
        public boolean isCompleted() {
            return this.state == 1;
        }
    }
}

