/*
 * Decompiled with CFR 0.152.
 */
package jade.proto;

import jade.core.Agent;
import jade.core.CaseInsensitiveString;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.DataStore;
import jade.core.behaviours.FSMBehaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPANames;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.states.MsgReceiver;
import jade.proto.states.ReplySender;

public class AchieveREResponder
extends FSMBehaviour
implements FIPANames.InteractionProtocol {
    public final String REQUEST_KEY = "__request" + this.hashCode();
    public final String RESPONSE_KEY = "__response" + this.hashCode();
    public final String RESULT_NOTIFICATION_KEY = "__result-notification" + this.hashCode();
    private static final String RECEIVE_REQUEST = "Receive-request";
    private static final String HANDLE_REQUEST = "Handle-request";
    private static final String SEND_RESPONSE = "Send-response";
    private static final String PREPARE_RESULT_NOTIFICATION = "Prepare-result-notification";
    private static final String SEND_RESULT_NOTIFICATION = "Send-result-notification";
    MsgReceiver rec = null;

    public static MessageTemplate createMessageTemplate(String iprotocol) {
        if (CaseInsensitiveString.equalsIgnoreCase("fipa-request", iprotocol)) {
            return MessageTemplate.and(MessageTemplate.MatchProtocol("fipa-request"), MessageTemplate.MatchPerformative(16));
        }
        if (CaseInsensitiveString.equalsIgnoreCase("fipa-query", iprotocol)) {
            return MessageTemplate.and(MessageTemplate.MatchProtocol("fipa-query"), MessageTemplate.or(MessageTemplate.MatchPerformative(12), MessageTemplate.MatchPerformative(13)));
        }
        return MessageTemplate.MatchProtocol(iprotocol);
    }

    public AchieveREResponder(Agent a, MessageTemplate mt) {
        this(a, mt, new DataStore());
    }

    public AchieveREResponder(Agent a, MessageTemplate mt, DataStore store) {
        super(a);
        this.setDataStore(store);
        this.registerDefaultTransition(RECEIVE_REQUEST, HANDLE_REQUEST);
        this.registerDefaultTransition(HANDLE_REQUEST, SEND_RESPONSE);
        this.registerTransition(SEND_RESPONSE, PREPARE_RESULT_NOTIFICATION, 1);
        this.registerTransition(SEND_RESPONSE, PREPARE_RESULT_NOTIFICATION, -1);
        this.registerDefaultTransition(SEND_RESPONSE, RECEIVE_REQUEST);
        this.registerDefaultTransition(PREPARE_RESULT_NOTIFICATION, SEND_RESULT_NOTIFICATION);
        this.registerDefaultTransition(SEND_RESULT_NOTIFICATION, RECEIVE_REQUEST);
        OneShotBehaviour b = null;
        this.rec = new MsgReceiver(this.myAgent, mt, -1L, this.getDataStore(), this.REQUEST_KEY);
        this.registerFirstState(this.rec, RECEIVE_REQUEST);
        b = new HandleRequest(this.myAgent);
        b.setDataStore(this.getDataStore());
        this.registerState(b, HANDLE_REQUEST);
        b = new SendResponse(this.myAgent, this.RESPONSE_KEY, this.REQUEST_KEY);
        b.setDataStore(this.getDataStore());
        this.registerState(b, SEND_RESPONSE);
        b = new PrepareResult(this.myAgent);
        b.setDataStore(this.getDataStore());
        this.registerState(b, PREPARE_RESULT_NOTIFICATION);
        b = new SendResult(this.myAgent, this.RESULT_NOTIFICATION_KEY, this.REQUEST_KEY);
        b.setDataStore(this.getDataStore());
        this.registerState(b, SEND_RESULT_NOTIFICATION);
    }

    private AchieveREResponder() {
    }

    @Override
    public void reset() {
        super.reset();
        DataStore ds = this.getDataStore();
        ds.remove(this.REQUEST_KEY);
        ds.remove(this.RESPONSE_KEY);
        ds.remove(this.RESULT_NOTIFICATION_KEY);
    }

    public void reset(MessageTemplate mt) {
        this.reset();
        this.rec.reset(mt, -1L, this.getDataStore(), this.REQUEST_KEY);
    }

    protected ACLMessage handleRequest(ACLMessage request) throws NotUnderstoodException, RefuseException {
        return this.prepareResponse(request);
    }

    protected ACLMessage prepareResponse(ACLMessage request) throws NotUnderstoodException, RefuseException {
        System.out.println("prepareResponse() method not re-defined");
        return null;
    }

    protected ACLMessage prepareResultNotification(ACLMessage request, ACLMessage response) throws FailureException {
        System.out.println("prepareResultNotification() method not re-defined");
        return null;
    }

    public void registerHandleRequest(Behaviour b) {
        this.registerState(b, HANDLE_REQUEST);
        b.setDataStore(this.getDataStore());
    }

    public void registerPrepareResponse(Behaviour b) {
        this.registerHandleRequest(b);
    }

    public void registerPrepareResultNotification(Behaviour b) {
        this.registerState(b, PREPARE_RESULT_NOTIFICATION);
        b.setDataStore(this.getDataStore());
    }

    private static class SendResult
    extends ReplySender {
        public SendResult(Agent a, String replyKey, String msgKey) {
            super(a, replyKey, msgKey);
        }

        private SendResult() {
        }

        @Override
        public int onEnd() {
            AchieveREResponder fsm = (AchieveREResponder)this.getParent();
            fsm.reset();
            return super.onEnd();
        }
    }

    private static class PrepareResult
    extends OneShotBehaviour {
        public PrepareResult(Agent a) {
            super(a);
        }

        private PrepareResult() {
        }

        @Override
        public void action() {
            DataStore ds = this.getDataStore();
            AchieveREResponder fsm = (AchieveREResponder)this.getParent();
            ACLMessage request = (ACLMessage)ds.get(fsm.REQUEST_KEY);
            ACLMessage response = (ACLMessage)ds.get(fsm.RESPONSE_KEY);
            ACLMessage resNotification = null;
            try {
                resNotification = fsm.prepareResultNotification(request, response);
            }
            catch (FailureException fe) {
                resNotification = fe.getACLMessage();
            }
            ds.put(fsm.RESULT_NOTIFICATION_KEY, resNotification);
        }
    }

    private static class SendResponse
    extends ReplySender {
        public SendResponse(Agent a, String replyKey, String msgKey) {
            super(a, replyKey, msgKey);
        }

        private SendResponse() {
        }

        @Override
        public int onEnd() {
            int ret = super.onEnd();
            if (ret != 1 && ret != -1) {
                AchieveREResponder fsm = (AchieveREResponder)this.getParent();
                fsm.reset();
            }
            return ret;
        }
    }

    private static class HandleRequest
    extends OneShotBehaviour {
        public HandleRequest(Agent a) {
            super(a);
        }

        @Override
        public void action() {
            DataStore ds = this.getDataStore();
            AchieveREResponder fsm = (AchieveREResponder)this.getParent();
            ACLMessage request = (ACLMessage)ds.get(fsm.REQUEST_KEY);
            ACLMessage response = null;
            try {
                response = fsm.handleRequest(request);
            }
            catch (NotUnderstoodException nue) {
                response = nue.getACLMessage();
            }
            catch (RefuseException re) {
                response = re.getACLMessage();
            }
            ds.put(fsm.RESPONSE_KEY, response);
        }
    }
}

