/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.nio;

import jade.core.BEConnectionManager;
import jade.core.BackEnd;
import jade.core.BackEndContainer;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.ProfileException;
import jade.imtp.leap.BackEndSkel;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.FrontEndStub;
import jade.imtp.leap.ICPDispatchException;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPMediatorManager;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.JICP.JICPProtocol;
import jade.imtp.leap.nio.NIOMediator;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;
import java.net.InetAddress;

public class BackEndDispatcher
implements NIOMediator,
BEConnectionManager,
Dispatcher {
    private long responseTimeoutOffset;
    private double responseTimeoutMultiplicativeFactor;
    private long keepAliveTime;
    private long maxDisconnectionTime;
    private long expirationDeadline;
    private long lastReceivedTime;
    private boolean active = true;
    private boolean peerActive = true;
    private boolean connectionDropped = false;
    private long dropTimeStamp = -1L;
    private JICPMediatorManager myMediatorManager;
    private String myID;
    private Properties myProperties;
    private BackEndContainer myContainer = null;
    private Connection myConnection = null;
    private Object writeLock = new Object();
    protected InputManager inpManager;
    protected OutputManager outManager;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private Object shutdownLock = new Object();

    @Override
    public String getID() {
        return this.active ? this.myID : null;
    }

    @Override
    public Properties getProperties() {
        return this.myProperties;
    }

    @Override
    public void init(JICPMediatorManager mgr, String id, Properties props) throws ICPException {
        this.myLogger.log(Logger.INFO, "BackEndDispatcher " + id + " starting...");
        this.myMediatorManager = mgr;
        this.myID = id;
        this.myProperties = props;
        this.responseTimeoutOffset = 30000L;
        try {
            this.responseTimeoutOffset = Long.parseLong(props.getProperty("response-timeout-offset"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.responseTimeoutMultiplicativeFactor = 0.1953125;
        try {
            this.responseTimeoutMultiplicativeFactor = Double.parseDouble(props.getProperty("response-timeout-multiplicative-factor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.maxDisconnectionTime = 600000L;
        try {
            this.maxDisconnectionTime = Long.parseLong(props.getProperty("max-disconnection-time"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.keepAliveTime = 60000L;
        try {
            this.keepAliveTime = Long.parseLong(props.getProperty("keep-alive-time"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int inpCnt = 0;
        try {
            inpCnt = Integer.parseInt(props.getProperty("lastsid")) + 1 & 0xF;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myLogger.log(Logger.CONFIG, "Next command for FE will have sessionID " + inpCnt);
        FrontEndStub st = new FrontEndStub(this);
        this.inpManager = new InputManager(inpCnt, st);
        BackEndSkel sk = this.startBackEndContainer(props);
        this.outManager = new OutputManager(15, sk);
    }

    protected final BackEndSkel startBackEndContainer(Properties props) throws ICPException {
        try {
            String nodeName = this.myID.replace(':', '_');
            props.setProperty("container-name", nodeName);
            this.myContainer = new BackEndContainer(props, this);
            if (!this.myContainer.connect()) {
                throw new ICPException("BackEnd container failed to join the platform");
            }
            this.myID = this.myContainer.here().getName();
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "BackEndContainer " + this.myID + " successfully joined the platform");
            }
            return new BackEndSkel(this.myContainer);
        }
        catch (ProfileException pe) {
            pe.printStackTrace();
            throw new ICPException("Error creating profile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.active) {
                this.active = false;
                this.myContainer.shutDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleIncomingConnection(Connection c, JICPPacket pkt, InetAddress addr, int port) {
        if (pkt.getType() == 23) {
            this.inpManager.notifyIncomingResponseReceived(null);
            if (this.myConnection != null && this.myConnection != c) {
                try {
                    this.myConnection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Thread flusher = this.inpManager.prepareFlush();
        BackEndDispatcher backEndDispatcher = this;
        synchronized (backEndDispatcher) {
            this.checkTerminatedInfo(pkt);
            this.lastReceivedTime = System.currentTimeMillis();
            if (this.peerActive) {
                this.myConnection = c;
                this.myLogger.log(Logger.INFO, this.myID + ": Connection = " + this.myConnection);
                this.updateConnectedState();
                this.connectionDropped = false;
                if (flusher != null) {
                    flusher.start();
                }
                return true;
            }
            if (flusher != null) {
                this.inpManager.abortFlush();
            }
            this.kill();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConnectionError(Connection c, Exception e) {
        this.inpManager.notifyIncomingResponseReceived(null);
        try {
            c.close();
        }
        catch (Exception e1) {
            this.myLogger.log(Logger.WARNING, this.myID + ": Unexpected error closing Connection = " + c, e1);
        }
        BackEndDispatcher backEndDispatcher = this;
        synchronized (backEndDispatcher) {
            if (this.active && this.peerActive && c == this.myConnection) {
                this.myConnection = null;
                this.updateConnectedState();
                this.myLogger.log(Logger.WARNING, this.myID + ": Disconnection detected");
                this.setExpirationDeadline();
            }
        }
    }

    @Override
    public JICPPacket handleJICPPacket(JICPPacket p, InetAddress addr, int port) throws ICPException {
        throw new ICPException("Unexpected call");
    }

    @Override
    public JICPPacket handleJICPPacket(Connection c, JICPPacket pkt, InetAddress addr, int port) throws ICPException {
        this.checkTerminatedInfo(pkt);
        this.lastReceivedTime = System.currentTimeMillis();
        JICPPacket reply = null;
        byte type = pkt.getType();
        switch (type) {
            case 30: {
                this.myLogger.log(Logger.INFO, "BE " + this.myID + " - DROP_DOWN received: " + pkt.getSessionID());
                this.handleDropDown(c, pkt, addr, port);
                break;
            }
            case 0: {
                this.myLogger.log(Logger.FINE, "BE " + this.myID + " - COMMAND received: " + pkt.getSessionID());
                if (this.peerActive) {
                    reply = this.outManager.handleCommand(pkt);
                    break;
                }
                this.kill();
                break;
            }
            case 2: {
                this.myLogger.log(Logger.FINE, "BE " + this.myID + " - KEEP_ALIVE received");
                reply = this.outManager.handleKeepAlive(pkt);
                break;
            }
            case 1: 
            case 100: {
                this.myLogger.log(Logger.FINE, "BE " + this.myID + " - RESPONSE/ERROR received: " + pkt.getSessionID());
                this.inpManager.notifyIncomingResponseReceived(pkt);
                break;
            }
            default: {
                this.myLogger.log(Logger.WARNING, "BE " + this.myID + " - Unexpected incoming packet type: " + type);
            }
        }
        if (reply != null) {
            try {
                this.writePacket(this.myConnection, reply);
                this.myLogger.log(Logger.FINE, "BE " + this.myID + " - RESPONSE sent back: " + reply.getSessionID());
            }
            catch (IOException ioe) {
                this.myLogger.log(Logger.WARNING, this.myID + ": Communication error sending back response. " + ioe);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePacket(Connection c, JICPPacket pkt) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            c.writePacket(pkt);
        }
    }

    @Override
    public final void tick(long currentTime) {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, this.myID + ": Tick.");
        }
        if (this.active) {
            if (!this.connectionDropped) {
                if (this.keepAliveTime > 0L && this.myConnection != null && currentTime - this.lastReceivedTime > this.keepAliveTime + this.responseTimeoutOffset) {
                    this.myLogger.log(Logger.WARNING, this.myID + ": Missing keep-alive.");
                    this.handleConnectionError(this.myConnection, null);
                }
                if (this.checkMaxDisconnectionTime(currentTime)) {
                    this.myLogger.log(Logger.WARNING, this.myID + ": Max disconnection time expired. FrontEnd is likely dead --> Close BackEnd");
                    this.kill();
                }
            } else if (currentTime - this.dropTimeStamp > 3600000L) {
                this.myLogger.log(Logger.WARNING, this.myID + ": Max drop-down time expired. FrontEnd is likely dead --> Close BackEnd");
                this.kill();
            }
        }
    }

    @Override
    public FrontEnd getFrontEnd(BackEnd be, Properties props) throws IMTPException {
        return this.inpManager.getStub();
    }

    @Override
    public void shutdown() {
        this.active = false;
        this.myLogger.log(Logger.INFO, "BackEndDispatcher " + this.myID + " shutting down...");
        if (this.myID != null) {
            this.myMediatorManager.deregisterMediator(this.myID);
        }
        this.inpManager.shutdown();
        this.outManager.shutdown();
    }

    @Override
    public synchronized byte[] dispatch(byte[] payload, boolean flush, int oldSessionId) throws ICPException {
        if (this.connectionDropped) {
            this.droppedToDisconnected();
            throw new ICPException("Connection dropped");
        }
        JICPPacket pkt = new JICPPacket(0, 0, payload);
        long start = System.currentTimeMillis();
        pkt = this.inpManager.dispatch(pkt, flush, oldSessionId);
        long elapsed = System.currentTimeMillis() - start;
        if (elapsed > 2000L) {
            this.myLogger.log(Logger.WARNING, this.myID + " - JICP command dispatching time over threshold: " + elapsed + " ms");
        }
        return pkt.getData();
    }

    protected void handleDropDown(Connection c, JICPPacket pkt, InetAddress addr, int port) {
        try {
            if (this.inpManager.isEmpty()) {
                JICPPacket rsp = new JICPPacket(1, 0, null);
                this.writePacket(c, rsp);
                this.inpManager.notifyIncomingResponseReceived(null);
                this.myConnection = null;
                this.updateConnectedState();
                this.connectionDropped = true;
                this.dropTimeStamp = System.currentTimeMillis();
            } else {
                this.myLogger.log(Logger.WARNING, this.myID + ": DROP_DOWN request refused.");
                JICPPacket rsp = new JICPPacket(100, 0, null);
                this.writePacket(c, rsp);
            }
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, this.myID + ": Error writing DROP_DOWN response. " + e);
        }
    }

    private void droppedToDisconnected() {
        this.connectionDropped = false;
        this.setExpirationDeadline();
        this.requestRefresh();
    }

    protected void requestRefresh() {
    }

    public boolean isConnected() {
        return this.myConnection != null;
    }

    private void updateConnectedState() {
        this.myProperties.put("connected", this.isConnected() ? "true" : "false");
    }

    private final synchronized void setExpirationDeadline() {
        this.expirationDeadline = System.currentTimeMillis() + this.maxDisconnectionTime;
    }

    private final synchronized boolean checkMaxDisconnectionTime(long currentTime) {
        return !this.isConnected() && currentTime > this.expirationDeadline;
    }

    private final boolean checkTerminatedInfo(JICPPacket pkt) {
        byte type;
        if ((pkt.getInfo() & 0x40) != 0 && ((type = pkt.getType()) == 0 || type == 1 || type == 23)) {
            this.peerActive = false;
            this.myLogger.log(Logger.INFO, this.myID + ": Peer termination notification received");
            if (pkt.getType() == 0) {
                this.inpManager.notifyIncomingResponseReceived(null);
            }
        }
        return this.peerActive;
    }

    protected class OutputManager {
        private JICPPacket lastResponse;
        private int lastSid;
        private BackEndSkel mySkel;

        OutputManager(int n, BackEndSkel s) {
            this.lastSid = n;
            this.mySkel = s;
        }

        void shutdown() {
        }

        final JICPPacket handleCommand(JICPPacket cmd) throws ICPException {
            JICPPacket reply = null;
            byte sid = cmd.getSessionID();
            if (sid == this.lastSid && this.lastResponse != null) {
                BackEndDispatcher.this.myLogger.log(Logger.WARNING, BackEndDispatcher.this.myID + ": Duplicated packet from FE: pkt-type=" + cmd.getType() + " info=" + cmd.getInfo() + " SID=" + sid);
                reply = this.lastResponse;
            } else {
                if (BackEndDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                    BackEndDispatcher.this.myLogger.log(Logger.FINE, BackEndDispatcher.this.myID + ": Received command " + sid + " from FE");
                }
                byte[] rspData = this.mySkel.handleCommand(cmd.getData());
                if (BackEndDispatcher.this.myLogger.isLoggable(Logger.FINER)) {
                    BackEndDispatcher.this.myLogger.log(Logger.FINER, BackEndDispatcher.this.myID + ": Command " + sid + " from FE served ");
                }
                reply = new JICPPacket(1, 0, rspData);
                reply.setSessionID(sid);
                this.lastSid = sid;
                this.lastResponse = reply;
            }
            return reply;
        }

        final JICPPacket handleKeepAlive(JICPPacket command) throws ICPException {
            if (BackEndDispatcher.this.myLogger.isLoggable(Logger.FINEST)) {
                BackEndDispatcher.this.myLogger.log(Logger.FINEST, BackEndDispatcher.this.myID + ": Keep-alive received");
            }
            return new JICPPacket(1, 0, null);
        }
    }

    protected class InputManager {
        private boolean dispatching = false;
        private boolean waitingForFlush;
        private JICPPacket lastIncomingResponse;
        private int inpCnt;
        private FrontEndStub myStub;

        InputManager(int c, FrontEndStub s) {
            this.inpCnt = c;
            this.myStub = s;
        }

        FrontEndStub getStub() {
            return this.myStub;
        }

        Thread prepareFlush() {
            Thread flusher = this.myStub.checkFlush();
            this.waitingForFlush = flusher != null;
            return flusher;
        }

        void abortFlush() {
            this.myStub.endFlush();
        }

        final boolean isEmpty() {
            return !this.dispatching && this.myStub.isEmpty();
        }

        void shutdown() {
            this.notifyIncomingResponseReceived(null);
        }

        final JICPPacket dispatch(JICPPacket pkt, boolean flush, int oldSessionId) throws ICPException {
            this.dispatching = true;
            try {
                if (BackEndDispatcher.this.active && BackEndDispatcher.this.isConnected()) {
                    if (this.waitingForFlush && !flush) {
                        throw new ICPException("Upsetting dispatching order");
                    }
                    this.waitingForFlush = false;
                    if (flush && oldSessionId != -1) {
                        this.inpCnt = oldSessionId;
                    }
                    pkt.setSessionID((byte)this.inpCnt);
                    try {
                        long responseTimeout;
                        this.lastIncomingResponse = null;
                        if (BackEndDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                            BackEndDispatcher.this.myLogger.log(Logger.FINE, "[Thread=" + Thread.currentThread().getName() + "] BE " + BackEndDispatcher.this.myID + " - Sending command to FE " + pkt.getSessionID());
                        }
                        BackEndDispatcher.this.writePacket(BackEndDispatcher.this.myConnection, pkt);
                        if (BackEndDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                            BackEndDispatcher.this.myLogger.log(Logger.FINE, "[Thread=" + Thread.currentThread().getName() + "] BE " + BackEndDispatcher.this.myID + " - Waiting for response from FE " + pkt.getSessionID());
                        }
                        if ((pkt = this.waitForResponse(this.inpCnt, responseTimeout = JICPProtocol.computeTimeout(BackEndDispatcher.this.responseTimeoutOffset, BackEndDispatcher.this.responseTimeoutMultiplicativeFactor, pkt.getLength()))) != null) {
                            if (BackEndDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                                BackEndDispatcher.this.myLogger.log(Logger.FINE, "[Thread=" + Thread.currentThread().getName() + "] BE " + BackEndDispatcher.this.myID + " - Response received from FE " + pkt.getSessionID());
                            }
                            if (pkt.getType() == 100) {
                                throw new ICPException(new String(pkt.getData()));
                            }
                            if (!BackEndDispatcher.this.peerActive) {
                                BackEndDispatcher.this.shutdown();
                            }
                            JICPPacket jICPPacket = pkt;
                            return jICPPacket;
                        }
                        try {
                            BackEndDispatcher.this.myLogger.log(Logger.WARNING, "[Thread=" + Thread.currentThread().getName() + "] BE " + BackEndDispatcher.this.myID + ": Response timeout expired");
                            BackEndDispatcher.this.handleConnectionError(BackEndDispatcher.this.myConnection, null);
                            throw new ICPDispatchException("Response timeout expired", this.inpCnt);
                        }
                        catch (IOException ioe) {
                            BackEndDispatcher.this.myLogger.log(Logger.WARNING, "[Thread=" + Thread.currentThread().getName() + "] BE " + BackEndDispatcher.this.myID + ": " + ioe);
                            BackEndDispatcher.this.handleConnectionError(BackEndDispatcher.this.myConnection, ioe);
                            throw new ICPDispatchException("Dispatching error.", ioe, this.inpCnt);
                        }
                    }
                    finally {
                        this.inpCnt = this.inpCnt + 1 & 0xF;
                    }
                }
                throw new ICPException("Unreachable");
            }
            finally {
                this.dispatching = false;
            }
        }

        private synchronized JICPPacket waitForResponse(int sessionID, long timeout) {
            try {
                while (this.lastIncomingResponse == null) {
                    this.wait(timeout);
                    if (this.lastIncomingResponse != null && this.lastIncomingResponse.getSessionID() != sessionID) {
                        BackEndDispatcher.this.myLogger.log(Logger.WARNING, BackEndDispatcher.this.myID + ": Duplicated response from FE: type=" + this.lastIncomingResponse.getType() + " info=" + this.lastIncomingResponse.getInfo() + " SID=" + this.lastIncomingResponse.getSessionID());
                        this.lastIncomingResponse = null;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.lastIncomingResponse;
        }

        private synchronized void notifyIncomingResponseReceived(JICPPacket rsp) {
            this.lastIncomingResponse = rsp;
            this.notifyAll();
        }
    }
}

