/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.imtp.leap.ICPException;
import jade.imtp.leap.TransportProtocol;
import jade.imtp.leap.http.HTTPAddress;
import jade.mtp.TransportAddress;
import java.util.Vector;

public class HTTPProtocol
extends TransportProtocol {
    public static final String NAME = "http";
    public static final int DEFAULT_PORT = 80;
    private static HTTPProtocol theInstance = new HTTPProtocol();

    public static HTTPProtocol getInstance() {
        return theInstance;
    }

    @Override
    public String addrToString(TransportAddress ta) throws ICPException {
        HTTPAddress hta = null;
        try {
            hta = (HTTPAddress)ta;
        }
        catch (ClassCastException cce) {
            throw new ICPException("The TransportAddress " + ta.toString() + " is not an HTTP Address");
        }
        return hta.toString();
    }

    @Override
    public TransportAddress stringToAddr(String s) throws ICPException {
        Vector addressFields = this.parseURL(s);
        String protocol = (String)addressFields.elementAt(0);
        if (!NAME.equals(protocol)) {
            throw new ICPException("Unexpected protocol \"" + protocol + "\" when \"" + NAME + "\" was expected.");
        }
        String host = (String)addressFields.elementAt(1);
        String port = (String)addressFields.elementAt(2);
        String file = (String)addressFields.elementAt(3);
        String anchor = (String)addressFields.elementAt(4);
        return new HTTPAddress(host, port, file, anchor);
    }

    @Override
    public TransportAddress buildAddress(String host, String port, String file, String anchor) {
        return new HTTPAddress(host, port, file, anchor);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

