/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.core.BEConnectionManager;
import jade.core.BackEnd;
import jade.core.BackEndContainer;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.ProfileException;
import jade.core.Runtime;
import jade.core.Timer;
import jade.core.TimerListener;
import jade.imtp.leap.BackEndSkel;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.FrontEndStub;
import jade.imtp.leap.ICPDispatchException;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPMediator;
import jade.imtp.leap.JICP.JICPMediatorManager;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.MicroSkeleton;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.net.InetAddress;

public class HTTPBEDispatcher
implements BEConnectionManager,
Dispatcher,
JICPMediator {
    private JICPMediatorManager myMediatorManager;
    private String myID;
    private MicroSkeleton mySkel = null;
    private FrontEndStub myStub = null;
    private BackEndContainer myContainer = null;
    private OutgoingsHandler myOutgoingsHandler;
    private JICPPacket lastResponse = null;
    private byte lastSid = (byte)16;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    @Override
    public String getID() {
        return this.myID;
    }

    @Override
    public void init(JICPMediatorManager mgr, String id, Properties props) throws ICPException {
        this.myMediatorManager = mgr;
        this.myID = id;
        long maxDisconnectionTime = 600000L;
        try {
            maxDisconnectionTime = Long.parseLong(props.getProperty("max-disconnection-time"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        long keepAliveTime = 60000L;
        try {
            keepAliveTime = Long.parseLong(props.getProperty("keep-alive-time"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.myOutgoingsHandler = new OutgoingsHandler(maxDisconnectionTime, keepAliveTime);
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, "Created HTTPBEDispatcher V2.0. ID = " + this.myID + "\n- MaxDisconnectionTime = " + maxDisconnectionTime);
        }
        this.myStub = new FrontEndStub(this);
        this.mySkel = this.startBackEndContainer(props);
    }

    protected final BackEndSkel startBackEndContainer(Properties props) throws ICPException {
        try {
            String nodeName = this.myID.replace(':', '_');
            props.setProperty("container-name", nodeName);
            this.myContainer = new BackEndContainer(props, this);
            if (!this.myContainer.connect()) {
                throw new ICPException("BackEnd container failed to join the platform");
            }
            this.myID = this.myContainer.here().getName();
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "BackEndContainer " + this.myID + " successfully joined the platform.");
            }
            return new BackEndSkel(this.myContainer);
        }
        catch (ProfileException pe) {
            pe.printStackTrace();
            throw new ICPException("Error creating profile");
        }
    }

    @Override
    public void kill() {
        this.myContainer.shutDown();
    }

    @Override
    public JICPPacket handleJICPPacket(JICPPacket pkt, InetAddress addr, int port) throws ICPException {
        String from = " [" + addr + ":" + port + "]";
        if (pkt.getType() == 0) {
            if ((pkt.getInfo() & 0x40) != 0) {
                this.myLogger.log(Logger.INFO, "Peer termination notification received. Peer address is " + from);
                this.handlePeerExited();
                return null;
            }
            byte sid = pkt.getSessionID();
            if (sid == this.lastSid && this.lastResponse != null) {
                if (this.myLogger.isLoggable(Logger.WARNING)) {
                    this.myLogger.log(Logger.WARNING, "Duplicated command received " + sid + " " + from);
                }
                pkt = this.lastResponse;
            } else {
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, "Incoming command received " + sid + " " + from);
                }
                byte[] rspData = this.mySkel.handleCommand(pkt.getData());
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, "Incoming command served " + sid);
                }
                pkt = new JICPPacket(1, 0, rspData);
                pkt.setSessionID(sid);
                this.lastSid = sid;
                this.lastResponse = pkt;
            }
            return pkt;
        }
        return this.myOutgoingsHandler.dispatchResponse(pkt, from);
    }

    @Override
    public boolean handleIncomingConnection(Connection c, JICPPacket pkt, InetAddress addr, int port) {
        this.myOutgoingsHandler.setConnecting();
        return false;
    }

    private void ensureFERunning(final long timeout) {
        Thread t = new Thread(){

            @Override
            public void run() {
                if (timeout > 0L && !HTTPBEDispatcher.this.myOutgoingsHandler.waitForInitialResponse(timeout) && HTTPBEDispatcher.this.myLogger.isLoggable(Logger.INFO)) {
                    HTTPBEDispatcher.this.myLogger.log(Logger.INFO, "Missing initial dummy response after reconnection");
                }
            }
        };
        t.start();
    }

    @Override
    public void tick(long currentTime) {
    }

    @Override
    public synchronized byte[] dispatch(byte[] payload, boolean flush, int oldSessionId) throws ICPException {
        JICPPacket pkt = new JICPPacket(0, 0, payload);
        if ((pkt = this.myOutgoingsHandler.deliverCommand(pkt, flush, oldSessionId)).getType() == 100) {
            throw new ICPException(new String(pkt.getData()));
        }
        return pkt.getData();
    }

    @Override
    public FrontEnd getFrontEnd(BackEnd be, Properties props) throws IMTPException {
        return this.myStub;
    }

    @Override
    public void shutdown() {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Initiate HTTPBEDispatcher shutdown");
        }
        if (this.myID != null) {
            this.myMediatorManager.deregisterMediator(this.myID);
            this.myID = null;
        }
        this.myOutgoingsHandler.setTerminating();
    }

    protected void handlePeerExited() {
        this.myOutgoingsHandler.setTerminating();
        this.kill();
    }

    protected void handleConnectionError() {
        this.myOutgoingsHandler.setTerminating();
        this.kill();
    }

    private class OutgoingsHandler
    implements TimerListener {
        private static final int REACHABLE = 0;
        private static final int CONNECTING = 1;
        private static final int UNREACHABLE = 2;
        private static final int TERMINATED = 3;
        private static final long RESPONSE_TIMEOUT = 5000L;
        private static final int MAX_SID = 15;
        private int frontEndStatus = 1;
        private int outCnt = 0;
        private Thread responseWaiter = null;
        private JICPPacket currentCommand = null;
        private JICPPacket currentResponse = null;
        private boolean commandReady = false;
        private boolean responseReady = false;
        private boolean connectionReset = false;
        private long maxDisconnectionTime;
        private long keepAliveTime;
        private Timer maxDisconnectionTimer = null;
        private boolean waitingForFlush = false;
        private Object initialResponseLock = new Object();
        private boolean initialResponseReceived;

        public OutgoingsHandler(long maxDisconnectionTime, long keepAliveTime) {
            this.maxDisconnectionTime = maxDisconnectionTime;
            this.keepAliveTime = keepAliveTime >= 0L ? keepAliveTime : 0L;
        }

        public synchronized JICPPacket deliverCommand(JICPPacket cmd, boolean flush, int oldSessionId) throws ICPException {
            if (this.frontEndStatus == 0) {
                if (this.waitingForFlush && !flush) {
                    throw new ICPException("Upsetting dispatching order");
                }
                this.waitingForFlush = false;
                if (flush && oldSessionId != -1) {
                    this.outCnt = oldSessionId;
                }
                int sid = this.outCnt;
                this.outCnt = this.outCnt + 1 & 0xF;
                if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                    HTTPBEDispatcher.this.myLogger.log(Logger.FINE, "Scheduling outgoing command for delivery " + sid);
                }
                cmd.setSessionID((byte)sid);
                this.currentCommand = cmd;
                this.commandReady = true;
                this.notifyAll();
                while (!this.responseReady) {
                    try {
                        this.responseWaiter = Thread.currentThread();
                        this.wait(5000L * (long)(1 + cmd.getLength() / 4096));
                        this.responseWaiter = null;
                        if (this.responseReady) continue;
                        if (this.frontEndStatus == 1) {
                            HTTPBEDispatcher.this.myLogger.log(Logger.WARNING, "Connection reset while waiting for response " + sid);
                        } else if (this.frontEndStatus != 3) {
                            HTTPBEDispatcher.this.myLogger.log(Logger.WARNING, "Response timeout expired " + sid);
                            this.setUnreachable();
                        }
                        throw new ICPDispatchException("Missing response", cmd.getSessionID());
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                    HTTPBEDispatcher.this.myLogger.log(Logger.FINE, "Response to scheduled command received " + this.currentResponse.getSessionID());
                }
                this.responseReady = false;
                return this.currentResponse;
            }
            throw new ICPException("Unreachable");
        }

        public synchronized JICPPacket dispatchResponse(JICPPacket rsp, String from) {
            if ((rsp.getInfo() & 0x20) != 0) {
                if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINER)) {
                    HTTPBEDispatcher.this.myLogger.log(Logger.FINER, "Keep-alive response received");
                }
                this.notifyAll();
            } else if (this.responseWaiter != null) {
                if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                    HTTPBEDispatcher.this.myLogger.log(Logger.FINE, "Response received " + rsp.getSessionID() + " from " + from);
                }
                this.responseReady = true;
                this.currentResponse = rsp;
                this.notifyAll();
            } else if (this.frontEndStatus == 1) {
                if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.INFO)) {
                    HTTPBEDispatcher.this.myLogger.log(Logger.INFO, "Initial dummy response received " + rsp.getSessionID() + from);
                }
                this.notifyInitialResponseReceived();
            } else if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.WARNING)) {
                HTTPBEDispatcher.this.myLogger.log(Logger.WARNING, "Unexpected response received (likely an out of time respose) " + rsp.getSessionID() + from);
            }
            if (this.frontEndStatus != 0) {
                this.frontEndStatus = 0;
                this.resetMaxDisconnectionTimer();
                this.waitingForFlush = HTTPBEDispatcher.this.myStub.flush();
            }
            if ((rsp.getInfo() & 0x40) != 0) {
                if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.INFO)) {
                    HTTPBEDispatcher.this.myLogger.log(Logger.INFO, "Last response detected");
                }
                HTTPBEDispatcher.this.shutdown();
                return null;
            }
            while (!this.commandReady) {
                try {
                    this.wait(this.keepAliveTime);
                    if (this.commandReady) continue;
                    if (this.connectionReset) {
                        if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                            HTTPBEDispatcher.this.myLogger.log(Logger.FINE, "Return with no command to deliver");
                        }
                        return null;
                    }
                    if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINER)) {
                        HTTPBEDispatcher.this.myLogger.log(Logger.FINER, "Sending keep-alive packet");
                    }
                    return new JICPPacket(2, 0, null);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                HTTPBEDispatcher.this.myLogger.log(Logger.FINE, "Delivering outgoing command " + this.currentCommand.getSessionID());
            }
            this.commandReady = false;
            return this.currentCommand;
        }

        public synchronized void setConnecting() {
            if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                HTTPBEDispatcher.this.myLogger.log(Logger.FINE, "Resetting the connection");
            }
            this.initialResponseReceived = false;
            this.frontEndStatus = 1;
            this.reset();
            Thread t = new Thread(){

                @Override
                public void run() {
                    if (!HTTPBEDispatcher.this.myOutgoingsHandler.waitForInitialResponse(60000L)) {
                        if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                            HTTPBEDispatcher.this.myLogger.log(Logger.FINE, "Missing initial dummy response after reconnection");
                        }
                        OutgoingsHandler.this.setUnreachable();
                    }
                }
            };
            t.start();
        }

        private synchronized void setUnreachable() {
            this.frontEndStatus = 2;
            this.activateMaxDisconnectionTimer(this.maxDisconnectionTime);
        }

        public synchronized void setTerminating() {
            this.frontEndStatus = 3;
            this.reset();
        }

        private void reset() {
            this.commandReady = false;
            this.responseReady = false;
            this.currentCommand = null;
            this.currentResponse = null;
            this.resetMaxDisconnectionTimer();
            this.notifyAll();
        }

        private void activateMaxDisconnectionTimer(long timeout) {
            long now = System.currentTimeMillis();
            this.maxDisconnectionTimer = new Timer(now + timeout, this);
            this.maxDisconnectionTimer = Runtime.instance().getTimerDispatcher().add(this.maxDisconnectionTimer);
            if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                HTTPBEDispatcher.this.myLogger.log(Logger.FINE, "Disconnection timer activated.");
            }
        }

        private void resetMaxDisconnectionTimer() {
            if (this.maxDisconnectionTimer != null) {
                Runtime.instance().getTimerDispatcher().remove(this.maxDisconnectionTimer);
                this.maxDisconnectionTimer = null;
            }
        }

        @Override
        public synchronized void doTimeOut(Timer t) {
            if (this.frontEndStatus != 0) {
                if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.WARNING)) {
                    HTTPBEDispatcher.this.myLogger.log(Logger.WARNING, "Max disconnection timeout expired.");
                }
                HTTPBEDispatcher.this.handleConnectionError();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForInitialResponse(long timeout) {
            Object object = this.initialResponseLock;
            synchronized (object) {
                if (!this.initialResponseReceived) {
                    try {
                        this.initialResponseLock.wait(timeout);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return this.initialResponseReceived;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyInitialResponseReceived() {
            Object object = this.initialResponseLock;
            synchronized (object) {
                this.initialResponseReceived = true;
                this.initialResponseLock.notifyAll();
            }
        }
    }
}

