/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.Node;
import jade.core.Service;
import jade.core.UnreachableException;
import jade.core.messaging.DeliveryTracing;
import jade.imtp.leap.Command;
import jade.imtp.leap.DispatcherException;
import jade.imtp.leap.Stub;
import jade.util.Logger;

class NodeStub
extends Stub
implements Node {
    private String name;
    private boolean hasPM = false;

    public NodeStub() {
    }

    public NodeStub(int id, String platformName) {
        super(id, platformName);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasPlatformManager() {
        return this.hasPM;
    }

    void setPlatformManager(boolean b) {
        this.hasPM = b;
    }

    @Override
    public void exportSlice(String serviceName, Service.Slice localSlice) {
        throw new RuntimeException("Trying to export a slice on a node stub");
    }

    @Override
    public void unexportSlice(String serviceName) {
    }

    @Override
    public Object accept(HorizontalCommand cmd) throws IMTPException {
        try {
            if (this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, "Sending HC " + cmd.getName() + " to remote node " + this.name + " at addresses " + this.remoteTAs.toString());
            }
            Command leapCmd = new Command(8, this.remoteID);
            leapCmd.addParam(cmd);
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, leapCmd);
            int nParam = result.getParamCnt();
            if (nParam > 1) {
                try {
                    Integer time = (Integer)result.getParamAt(nParam - 1);
                    DeliveryTracing.setTracingInfo("Remote-node-serving-time", time);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.checkResult(result, new String[0]);
            return result.getParamAt(0);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    @Override
    public boolean ping(boolean hang) throws IMTPException {
        Command cmd = hang ? new Command(9, this.remoteID, true) : new Command(10, this.remoteID, true);
        cmd.addParam(new Boolean(hang));
        try {
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Pinging remote node " + this.name + " at addresses " + this.remoteTAs.toString());
            }
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            this.checkResult(result, new String[0]);
            Boolean b = (Boolean)result.getParamAt(0);
            if (this.myLogger.isLoggable(Logger.FINE)) {
                this.myLogger.log(Logger.FINE, "Ping to remote node " + this.name + " returned: " + b);
            }
            return b;
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    @Override
    public void interrupt() throws IMTPException {
        Command cmd = new Command(12, this.remoteID);
        try {
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            this.checkResult(result, new String[0]);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    @Override
    public void exit() throws IMTPException {
        Command cmd = new Command(11, this.remoteID);
        try {
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            this.checkResult(result, new String[0]);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    @Override
    public void platformManagerDead(String deadPMAddress, String notifyingPMAddress) throws IMTPException {
        Command cmd = new Command(16, this.remoteID, true);
        cmd.addParam(deadPMAddress);
        cmd.addParam(notifyingPMAddress);
        try {
            Command result = this.theDispatcher.dispatchCommand(this.remoteTAs, cmd);
            this.checkResult(result, new String[0]);
        }
        catch (DispatcherException de) {
            throw new IMTPException("Dispatcher error", de);
        }
        catch (UnreachableException ue) {
            throw new IMTPException("Remote object unreachable", ue);
        }
    }

    public String toString() {
        String address = (this.remoteTAs != null && this.remoteTAs.size() > 0 ? this.remoteTAs.get(0) : "null").toString();
        return "[" + this.name + ", " + this.remoteID + ", " + address + "]";
    }
}

