/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap;

import jade.core.BaseNode;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.ServiceException;
import jade.imtp.leap.CommandDispatcher;
import jade.imtp.leap.NodeStub;
import jade.util.Logger;
import java.io.ObjectStreamException;

class NodeLEAP
extends BaseNode {
    private Object terminationLock = new Object();
    private boolean terminating = false;
    private CommandDispatcher myDispatcher;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public NodeLEAP(String name, boolean hasPM, CommandDispatcher dispatcher) {
        super(name, hasPM);
        this.myDispatcher = dispatcher;
    }

    @Override
    public Object accept(HorizontalCommand cmd) throws IMTPException {
        try {
            if (this.terminating) {
                throw new IMTPException("Dead node");
            }
            return this.serveHorizontalCommand(cmd);
        }
        catch (ServiceException se) {
            throw new IMTPException("Service Error", se);
        }
    }

    @Override
    public boolean ping(boolean hang) throws IMTPException {
        if (hang) {
            this.waitTermination();
        }
        this.myLogger.log(Logger.CONFIG, "Node " + this.getName() + " terminated (" + this.terminating + ")");
        return this.terminating;
    }

    @Override
    public void exit() throws IMTPException {
        this.myLogger.log(Logger.CONFIG, "Node " + this.getName() + " exiting...");
        this.terminating = true;
        this.notifyTermination();
    }

    @Override
    public void interrupt() throws IMTPException {
        this.notifyTermination();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTermination() {
        Object object = this.terminationLock;
        synchronized (object) {
            try {
                this.terminationLock.wait();
            }
            catch (InterruptedException ie) {
                System.out.println("PING wait interrupted");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTermination() {
        Object object = this.terminationLock;
        synchronized (object) {
            this.terminationLock.notifyAll();
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        try {
            NodeStub stub = (NodeStub)this.myDispatcher.buildLocalStub(this);
            stub.setName(this.getName());
            stub.setPlatformManager(this.hasPlatformManager());
            return stub;
        }
        catch (IMTPException imtpe) {
            throw new NodeStubAccessException("Can't retrieve NodeStub. " + imtpe.getMessage());
        }
    }

    private static class NodeStubAccessException
    extends ObjectStreamException {
        public NodeStubAccessException(String message) {
            super(message);
        }
    }
}

