/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.messaging.DeliveryTracing;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.ConnectionFactory;
import jade.imtp.leap.JICP.ConnectionPool;
import jade.imtp.leap.JICP.ConnectionWrapper;
import jade.imtp.leap.JICP.JICPConnection;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.TransportProtocol;
import jade.mtp.TransportAddress;
import jade.util.Logger;
import java.io.EOFException;
import java.io.IOException;

class JICPClient {
    private TransportProtocol protocol;
    private ConnectionFactory connFactory;
    private ConnectionPool pool;
    private int readTimeout;
    private static Logger log = Logger.getMyLogger(JICPClient.class.getName());

    public JICPClient(TransportProtocol tp, ConnectionFactory f, int max, int rt) {
        this.protocol = tp;
        this.connFactory = f;
        this.pool = new ConnectionPool(this.protocol, this.connFactory, max);
        this.readTimeout = rt;
    }

    public byte[] send(TransportAddress ta, byte dataType, byte[] data, boolean requireFreshConnection) throws ICPException {
        ConnectionWrapper cw = null;
        boolean done = false;
        while (true) {
            try {
                cw = this.pool.acquire(ta, requireFreshConnection);
                this.manageReadTimeout(cw);
                byte dataInfo = 0;
                if (cw.isOneShot()) {
                    dataInfo = (byte)(dataInfo | 0x40);
                }
                Connection connection = cw.getConnection();
                JICPPacket request = new JICPPacket(dataType, dataInfo, ta.getFile(), data);
                long start = System.currentTimeMillis();
                connection.writePacket(request);
                JICPPacket reply = connection.readPacket();
                DeliveryTracing.setTracingInfo("Network-waiting-time", System.currentTimeMillis() - start);
                DeliveryTracing.setTracingInfo("Reused-connection", cw.isReused());
                if (reply.getType() == 100) {
                    throw new ICPException(new String(reply.getData()));
                }
                if ((reply.getInfo() & 0x40) != 0) {
                    cw.setOneShot();
                }
                this.pool.release(cw);
                done = true;
                byte[] bb = reply.getData();
                if (bb == null) {
                    throw new ICPException("Null response from server");
                }
                byte[] byArray = bb;
                return byArray;
            }
            catch (EOFException eof) {
                if (cw.isReused()) continue;
                log.log(Logger.SEVERE, "EOF reached", eof);
                throw new ICPException("EOF reached");
            }
            catch (IOException ioe) {
                if (cw.isReused()) continue;
                throw new ICPException("I/O error sending/receiving data to " + ta.getHost() + ":" + ta.getPort(), ioe);
            }
            catch (ICPException icpe) {
                throw icpe;
            }
            catch (Exception e) {
                throw new ICPException("Problems in communication with " + ta.getHost() + ":" + ta.getPort(), e);
            }
            finally {
                if (done) {
                    if (!cw.isOneShot()) continue;
                    this.pool.remove(cw);
                    continue;
                }
                if (cw == null) continue;
                this.pool.remove(cw);
                continue;
            }
            break;
        }
    }

    private void manageReadTimeout(ConnectionWrapper cw) {
        Connection c;
        if (cw.isReused() && (c = cw.getConnection()) instanceof JICPConnection && this.readTimeout > 0) {
            try {
                ((JICPConnection)c).setReadTimeout(this.readTimeout);
            }
            catch (IOException e) {
                try {
                    log.log(Logger.WARNING, "Cannot set read-timeout on reused connection to " + c.getRemoteHost());
                }
                catch (Exception e1) {
                    log.log(Logger.WARNING, "Cannot set read-timeout on reused connection");
                }
            }
        }
    }

    public void shutdown() {
        this.pool.shutdown();
    }

    public void tick(long currentTime) {
        this.pool.clearExpiredConnections(currentTime);
    }
}

