/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.core.BEConnectionManager;
import jade.core.BackEnd;
import jade.core.BackEndContainer;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.ProfileException;
import jade.imtp.leap.BackEndSkel;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.FrontEndStub;
import jade.imtp.leap.ICPDispatchException;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPMediator;
import jade.imtp.leap.JICP.JICPMediatorManager;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.MicroSkeleton;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.io.IOException;
import java.net.InetAddress;

public class BIBEDispatcher
extends Thread
implements BEConnectionManager,
Dispatcher,
JICPMediator {
    private static final long RESPONSE_TIMEOUT = 60000L;
    private static final int REACHABLE = 1;
    private static final int UNREACHABLE = 0;
    private int frontEndStatus = 0;
    private long maxDisconnectionTime;
    private long keepAliveTime;
    private long lastReceivedTime;
    private JICPMediatorManager myMediatorManager;
    private String myID;
    private byte lastSid = (byte)15;
    private int inpCnt = 0;
    private boolean active = true;
    protected InpConnectionHolder inpHolder = new InpConnectionHolder();
    protected OutConnectionHolder outHolder = new OutConnectionHolder();
    private MicroSkeleton mySkel = null;
    private FrontEndStub myStub = null;
    private BackEndContainer myContainer = null;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private Object shutdownLock = new Object();
    private JICPPacket lastResponse;

    @Override
    public String getID() {
        return this.myID;
    }

    @Override
    public void init(JICPMediatorManager mgr, String id, Properties props) throws ICPException {
        this.myMediatorManager = mgr;
        this.myID = id;
        int verbosity = 1;
        try {
            verbosity = Integer.parseInt(props.getProperty("verbosity"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.maxDisconnectionTime = 600000L;
        try {
            this.maxDisconnectionTime = Long.parseLong(props.getProperty("max-disconnection-time"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.keepAliveTime = 60000L;
        try {
            this.keepAliveTime = Long.parseLong(props.getProperty("keep-alive-time"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.inpCnt = Integer.parseInt(props.getProperty("lastsid")) + 1 & 0xF;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.start();
        this.myStub = new FrontEndStub(this);
        this.mySkel = this.startBackEndContainer(props);
    }

    protected final BackEndSkel startBackEndContainer(Properties props) throws ICPException {
        try {
            String nodeName = this.myID.replace(':', '_');
            props.setProperty("container-name", nodeName);
            this.myContainer = new BackEndContainer(props, this);
            if (!this.myContainer.connect()) {
                throw new ICPException("BackEnd container failed to join the platform");
            }
            this.myID = this.myContainer.here().getName();
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "BackEndContainer " + this.myID + " successfully joined the platform.");
            }
            return new BackEndSkel(this.myContainer);
        }
        catch (ProfileException pe) {
            pe.printStackTrace();
            throw new ICPException("Error creating profile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.active) {
                this.active = false;
                this.myContainer.shutDown();
            }
        }
    }

    @Override
    public JICPPacket handleJICPPacket(JICPPacket p, InetAddress addr, int port) throws ICPException {
        return null;
    }

    @Override
    public boolean handleIncomingConnection(Connection c, JICPPacket pkt, InetAddress addr, int port) {
        boolean inp = false;
        byte[] data = pkt.getData();
        if (data.length == 1) {
            inp = data[0] == 1;
        } else {
            try {
                inp = new String(data).equals("inp");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inp) {
            this.inpHolder.setConnection(c);
        } else {
            this.outHolder.setConnection(c);
        }
        this.lastReceivedTime = System.currentTimeMillis();
        return true;
    }

    @Override
    public void tick(long currentTime) {
        if (this.keepAliveTime > 0L && currentTime - this.lastReceivedTime > this.keepAliveTime + 60000L) {
            if (this.outHolder.isConnected()) {
                if (this.myLogger.isLoggable(Logger.WARNING)) {
                    this.myLogger.log(Logger.WARNING, this.myID + " - Missing keep-alive");
                }
                this.outHolder.resetConnection();
            }
            if (this.inpHolder.isConnected()) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            JICPPacket pkt = new JICPPacket(2, 0, null);
                            BIBEDispatcher.this.dispatchPacket(pkt, false, -1);
                            if (BIBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                                BIBEDispatcher.this.myLogger.log(Logger.FINE, BIBEDispatcher.this.myID + " - IC valid");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                t.start();
            }
        }
    }

    @Override
    public FrontEnd getFrontEnd(BackEnd be, Properties props) throws IMTPException {
        return this.myStub;
    }

    @Override
    public void shutdown() {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, this.myID + " - Initiate BIBEDispatcher shutdown");
        }
        if (this.myID != null) {
            this.myMediatorManager.deregisterMediator(this.myID);
            this.myID = null;
        }
        this.active = false;
        this.inpHolder.resetConnection(true);
        this.outHolder.resetConnection();
    }

    @Override
    public byte[] dispatch(byte[] payload, boolean flush, int oldSessionId) throws ICPException {
        JICPPacket pkt = new JICPPacket(0, 0, payload);
        pkt = this.dispatchPacket(pkt, flush, oldSessionId);
        return pkt.getData();
    }

    private synchronized JICPPacket dispatchPacket(JICPPacket pkt, boolean flush, int oldSessionId) throws ICPException {
        Connection inpConnection = this.inpHolder.getConnection(flush);
        if (inpConnection != null && this.active) {
            int status = 0;
            if (flush && oldSessionId != -1) {
                this.inpCnt = oldSessionId;
            }
            pkt.setSessionID((byte)this.inpCnt);
            if (pkt.getType() == 2) {
                if (this.myLogger.isLoggable(Logger.FINER)) {
                    this.myLogger.log(Logger.FINER, this.myID + " - Issuing Keep-alive to FE " + this.inpCnt);
                }
            } else if (this.myLogger.isLoggable(Logger.FINER)) {
                this.myLogger.log(Logger.FINER, this.myID + " - Issuing command to FE " + this.inpCnt);
            }
            try {
                inpConnection.writePacket(pkt);
                status = 1;
                this.inpHolder.startWatchDog(60000L);
                pkt = this.readPacket(inpConnection);
                this.inpHolder.stopWatchDog();
                status = 2;
                if (this.myLogger.isLoggable(Logger.FINER)) {
                    this.myLogger.log(Logger.FINER, this.myID + " - Response received from FE " + pkt.getSessionID());
                }
                if (pkt.getType() == 100) {
                    throw new ICPException(new String(pkt.getData()));
                }
                if ((pkt.getInfo() & 0x40) != 0) {
                    this.shutdown();
                }
                JICPPacket jICPPacket = pkt;
                return jICPPacket;
            }
            catch (IOException ioe) {
                if (this.myLogger.isLoggable(Logger.WARNING)) {
                    this.myLogger.log(Logger.WARNING, this.myID + " - IOException IC[" + status + "]" + ioe);
                }
                this.inpHolder.resetConnection(false);
                throw new ICPDispatchException("Dispatching error.", ioe, this.inpCnt);
            }
            finally {
                this.inpCnt = this.inpCnt + 1 & 0xF;
            }
        }
        throw new ICPException("Unreachable");
    }

    @Override
    public void run() {
        this.lastResponse = null;
        int status = 0;
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, this.myID + " - BIBEDispatcher thread started");
        }
        while (this.active) {
            try {
                while (this.active) {
                    status = 0;
                    Connection outConnection = this.outHolder.getConnection();
                    if (outConnection != null) {
                        JICPPacket pkt = this.readPacket(outConnection);
                        status = 1;
                        if ((pkt = this.handlePacket(pkt)) == null) continue;
                        status = 2;
                        outConnection.writePacket(pkt);
                        status = 3;
                        continue;
                    }
                    this.handlePeerExited("Max disconnection timeout expired");
                }
            }
            catch (IOException ioe) {
                if (!this.active) continue;
                if (this.myLogger.isLoggable(Logger.WARNING)) {
                    this.myLogger.log(Logger.WARNING, this.myID + " - IOException OC[" + status + "]" + ioe);
                }
                this.outHolder.resetConnection();
            }
        }
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, this.myID + " - BIBEDispatcher Thread terminated");
        }
    }

    protected JICPPacket handlePacket(JICPPacket pkt) {
        JICPPacket reply = null;
        if (pkt.getType() == 2) {
            if (this.myLogger.isLoggable(Logger.FINEST)) {
                this.myLogger.log(Logger.FINEST, this.myID + " - Keep-alive received");
            }
            reply = new JICPPacket(1, this.getReconnectInfo(), null);
        } else {
            if ((pkt.getInfo() & 0x40) != 0) {
                this.handlePeerExited("Peer termination notification received");
                return null;
            }
            byte sid = pkt.getSessionID();
            if (sid == this.lastSid && this.lastResponse != null) {
                if (this.myLogger.isLoggable(Logger.WARNING)) {
                    this.myLogger.log(Logger.WARNING, this.myID + " - Duplicated command from FE " + sid);
                }
                reply = this.lastResponse;
            } else {
                if (this.myLogger.isLoggable(Logger.FINER)) {
                    this.myLogger.log(Logger.FINER, this.myID + " - Command from FE received " + sid);
                }
                byte[] rspData = this.mySkel.handleCommand(pkt.getData());
                if (this.myLogger.isLoggable(Logger.FINER)) {
                    this.myLogger.log(Logger.FINER, this.myID + " - Command from FE served " + sid);
                }
                reply = new JICPPacket(1, this.getReconnectInfo(), rspData);
                reply.setSessionID(sid);
                this.lastSid = sid;
                this.lastResponse = reply;
            }
        }
        return reply;
    }

    private byte getReconnectInfo() {
        byte info = 0;
        if (!this.inpHolder.isConnected()) {
            info = (byte)(info | 0x10);
        }
        return info;
    }

    private void handlePeerExited(String msg) {
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, this.myID + " - " + msg);
        }
        this.kill();
    }

    private JICPPacket readPacket(Connection c) throws IOException {
        JICPPacket pkt = c.readPacket();
        this.lastReceivedTime = System.currentTimeMillis();
        return pkt;
    }

    private void close(Connection c) {
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected class OutConnectionHolder {
        private Connection myConnection;
        private boolean connectionRefreshed;

        protected OutConnectionHolder() {
        }

        private synchronized void setConnection(Connection c) {
            if (BIBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                BIBEDispatcher.this.myLogger.log(Logger.FINE, BIBEDispatcher.this.myID + " - New output connection.");
            }
            if (this.myConnection != null) {
                BIBEDispatcher.this.close(this.myConnection);
            }
            this.myConnection = c;
            this.connectionRefreshed = true;
            this.notifyAll();
        }

        private synchronized Connection getConnection() {
            while (this.myConnection == null) {
                try {
                    this.wait(BIBEDispatcher.this.maxDisconnectionTime);
                    if (this.myConnection != null) continue;
                    return null;
                }
                catch (Exception e) {
                    if (!BIBEDispatcher.this.myLogger.isLoggable(Logger.WARNING)) continue;
                    BIBEDispatcher.this.myLogger.log(Logger.WARNING, BIBEDispatcher.this.myID + " - Spurious wake up");
                }
            }
            this.connectionRefreshed = false;
            return this.myConnection;
        }

        public synchronized void resetConnection() {
            if (!this.connectionRefreshed) {
                if (this.myConnection != null) {
                    BIBEDispatcher.this.close(this.myConnection);
                }
                this.myConnection = null;
            }
        }

        private synchronized boolean isConnected() {
            return this.myConnection != null;
        }
    }

    protected class InpConnectionHolder {
        private Connection myConnection;
        private boolean connectionRefreshed;
        private boolean waitingForFlush = false;
        private Thread watchDog = null;

        protected InpConnectionHolder() {
        }

        private synchronized void setConnection(Connection c) {
            if (BIBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                BIBEDispatcher.this.myLogger.log(Logger.FINE, BIBEDispatcher.this.myID + " - New input connection.");
            }
            if (this.myConnection != null) {
                BIBEDispatcher.this.close(this.myConnection);
            }
            this.stopWatchDog();
            this.myConnection = c;
            this.connectionRefreshed = true;
            this.waitingForFlush = BIBEDispatcher.this.myStub.flush();
        }

        private synchronized Connection getConnection(boolean flush) {
            if (this.waitingForFlush && !flush) {
                return null;
            }
            this.waitingForFlush = false;
            this.connectionRefreshed = false;
            return this.myConnection;
        }

        public synchronized void resetConnection(boolean force) {
            if (!this.connectionRefreshed || force) {
                if (this.myConnection != null) {
                    BIBEDispatcher.this.close(this.myConnection);
                }
                this.myConnection = null;
            }
        }

        private synchronized boolean isConnected() {
            return this.myConnection != null;
        }

        private synchronized void startWatchDog(final long timeout) {
            this.watchDog = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(timeout);
                        if (BIBEDispatcher.this.myLogger.isLoggable(Logger.WARNING)) {
                            BIBEDispatcher.this.myLogger.log(Logger.WARNING, BIBEDispatcher.this.myID + " - Response timeout expired");
                        }
                        InpConnectionHolder.this.resetConnection(false);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            this.watchDog.start();
        }

        private synchronized void stopWatchDog() {
            if (this.watchDog != null) {
                this.watchDog.interrupt();
                this.watchDog = null;
            }
        }
    }
}

