/*
 * Decompiled with CFR 0.152.
 */
package jade.gui;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.AMSAgentDescription;
import jade.domain.FIPAAgentManagement.APDescription;
import jade.gui.AgentTreeModel;
import jade.gui.AgentTreePopupManager;
import jade.gui.MyFilterImage;
import jade.gui.NodeDescriptor;
import jade.gui.TreeIconRenderer;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AgentTree
extends JPanel {
    public static final String TREE_ROOT_TYPE = "SUPERCONTAINER";
    public static final String LOCAL_PLATFORM_TYPE = "LOCALPLATFORM";
    public static final String AGENT_TYPE = "FIPAAGENT";
    public static final String FROZEN_AGENT_TYPE = "FROZENAGENT";
    public static final String CONTAINER_TYPE = "FIPACONTAINER";
    public static final String FROZEN_CONTAINER_TYPE = "FROZENCONTAINER";
    public static final String REMOTE_PLATFORMS_FOLDER_TYPE = "REMOTEPLATFORMS";
    public static final String REMOTE_PLATFORM_TYPE = "REMOTEPLATFORM";
    public static final String REMOTE_AGENT_TYPE = "REMOTEAGENT";
    public static final String TREE_ROOT_NAME = "AgentPlatforms";
    public static final String DAFAULT_LOCAL_PLATFORM_NAME = "ThisPlatform";
    public static final String REMOTE_PLATFORMS_FOLDER_NAME = "RemotePlatforms";
    public static final String FROZEN_AGENTS_FOLDER_NAME = "Frozen Agents";
    public JTree tree;
    private Map mapDescriptor = new HashMap();
    private String localPlatformName = "ThisPlatform";

    public AgentTree() {
        this((Font)null);
    }

    public AgentTree(Font f) {
        this.register(TREE_ROOT_TYPE, null, "images/folderyellow.gif");
        this.register(LOCAL_PLATFORM_TYPE, null, "images/folderyellow.gif");
        this.register(CONTAINER_TYPE, null, "images/foldergreen.gif");
        this.register(AGENT_TYPE, null, "images/runtree.gif");
        this.register(FROZEN_CONTAINER_TYPE, null, "images/frozenagents.gif");
        this.register(FROZEN_AGENT_TYPE, null, "images/freezeagent.gif");
        this.register(REMOTE_PLATFORMS_FOLDER_TYPE, null, "images/folderblue.gif");
        this.register(REMOTE_PLATFORM_TYPE, null, "images/folderlightblue.gif");
        this.register(REMOTE_AGENT_TYPE, null, "images/runtree.gif");
        this.tree = new JTree();
        if (f != null) {
            this.tree.setFont(f);
        }
        this.tree.setModel(new AgentTreeModel(new SuperContainer(TREE_ROOT_NAME)));
        this.tree.setLargeModel(false);
        this.tree.getSelectionModel().setSelectionMode(4);
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        LocalPlatformFolderNode localAP = new LocalPlatformFolderNode(this.localPlatformName);
        model.insertNodeInto(localAP, root, root.getChildCount());
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new TreeIconRenderer());
        this.tree.setRowHeight(0);
        this.tree.addMouseListener(new AgentTreePopupManager(this));
    }

    public AgentNode createAgentNode(String name) {
        return new AgentNode(name);
    }

    public ContainerNode createContainerNode(String name) {
        return new ContainerNode(name);
    }

    public Node createNewNode(String name, int i) {
        switch (i) {
            case 0: {
                return new ContainerNode(name);
            }
            case 1: {
                return new AgentNode(name);
            }
        }
        return null;
    }

    public void refreshLocalPlatformName(String newName) {
        String oldName = this.localPlatformName;
        this.localPlatformName = newName;
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        Enumeration<? extends TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            Node node = (Node)children.nextElement();
            String name = node.getName();
            if (!name.equalsIgnoreCase(oldName)) continue;
            node.setName(newName);
            return;
        }
    }

    public void clearLocalPlatform() {
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        Enumeration<? extends TreeNode> folders = root.children();
        while (folders.hasMoreElements()) {
            Node folderNode = (Node)folders.nextElement();
            String folderName = folderNode.getName();
            if (!folderName.equalsIgnoreCase(this.localPlatformName)) continue;
            Enumeration<TreeNode> containers = folderNode.children();
            LinkedList<Node> toRemove = new LinkedList<Node>();
            while (containers.hasMoreElements()) {
                Node container = (Node)containers.nextElement();
                toRemove.add(container);
            }
            for (MutableTreeNode mutableTreeNode : toRemove) {
                model.removeNodeFromParent(mutableTreeNode);
            }
        }
    }

    public void addContainerNode(String containerName, InetAddress addr) {
        ContainerNode node = new ContainerNode(containerName);
        node.setAddress(addr);
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        Enumeration<? extends TreeNode> folders = root.children();
        while (folders.hasMoreElements()) {
            Node folderNode = (Node)folders.nextElement();
            String folderName = folderNode.getName();
            if (!folderName.equalsIgnoreCase(this.localPlatformName)) continue;
            model.insertNodeInto(node, folderNode, folderNode.getChildCount());
            return;
        }
    }

    public void addContainerNode(ContainerNode node, String typeContainer, InetAddress addr) {
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        node.setType(typeContainer);
        Enumeration<? extends TreeNode> folders = root.children();
        while (folders.hasMoreElements()) {
            Node folderNode = (Node)folders.nextElement();
            String folderName = folderNode.getName();
            if (!folderName.equalsIgnoreCase(this.localPlatformName)) continue;
            model.insertNodeInto(node, folderNode, folderNode.getChildCount());
            break;
        }
        node.setAddress(addr);
    }

    public void removeContainerNode(String nameNode) {
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        Enumeration<? extends TreeNode> folders = root.children();
        while (folders.hasMoreElements()) {
            Node folderNode = (Node)folders.nextElement();
            String folderName = folderNode.getName();
            if (!folderName.equalsIgnoreCase(this.localPlatformName)) continue;
            Enumeration<TreeNode> containers = folderNode.children();
            while (containers.hasMoreElements()) {
                Node node = (Node)containers.nextElement();
                String nodeName = node.getName();
                if (!nodeName.equalsIgnoreCase(nameNode)) continue;
                model.removeNodeFromParent(node);
                return;
            }
        }
    }

    public void addRemotePlatformsFolderNode() {
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        Enumeration<? extends TreeNode> children = root.children();
        boolean existing = false;
        while (children.hasMoreElements() & !existing) {
            Node node = (Node)children.nextElement();
            String nodeName = node.getName();
            if (!nodeName.equalsIgnoreCase(REMOTE_PLATFORMS_FOLDER_NAME)) continue;
            existing = true;
        }
        if (!existing) {
            RemotePlatformsFolderNode rpn = new RemotePlatformsFolderNode(REMOTE_PLATFORMS_FOLDER_NAME);
            model.insertNodeInto(rpn, root, root.getChildCount());
        }
    }

    public void addAgentNode(String agentName, String agentAddress, String containerName) {
        this.addAgentNode(agentName, agentAddress, containerName, "Running", null);
    }

    public void addAgentNode(String agentName, String agentAddress, String containerName, String agentState, String ownership) {
        AgentNode node = new AgentNode(agentName);
        node.setAddress(agentAddress);
        node.setState(agentState);
        node.setOwnership(ownership);
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        Enumeration<? extends TreeNode> folders = root.children();
        while (folders.hasMoreElements()) {
            Node folderNode = (Node)folders.nextElement();
            String folderName = folderNode.getName();
            if (!folderName.equalsIgnoreCase(this.localPlatformName)) continue;
            Enumeration<TreeNode> containers = folderNode.children();
            while (containers.hasMoreElements()) {
                Node containerNode = (Node)containers.nextElement();
                String contName = containerNode.getName();
                if (!contName.equalsIgnoreCase(containerName)) continue;
                int position = this.getPosition(node, containerNode);
                model.insertNodeInto(node, containerNode, position);
                return;
            }
        }
    }

    private int getPosition(Node node, Node parentNode) {
        int size = parentNode.getChildCount();
        if (size == 0) {
            return 0;
        }
        int k = node.compareTo((Node)parentNode.getChildAt(0));
        if (k < 0) {
            return 0;
        }
        k = node.compareTo((Node)parentNode.getChildAt(size - 1));
        if (k >= 0) {
            return size;
        }
        return this.getPosition(node, parentNode, 0, size - 1);
    }

    private int getPosition(Node node, Node parentNode, int down, int up) {
        if (up - down == 1) {
            return up;
        }
        int middle = (up + down) / 2;
        int k = node.compareTo((Node)parentNode.getChildAt(middle));
        if (k == 0) {
            return middle + 1;
        }
        if (k < 0) {
            return this.getPosition(node, parentNode, down, middle);
        }
        return this.getPosition(node, parentNode, middle, up);
    }

    public void addAgentNode(AgentNode node, String containerName, String agentName, String agentAddress, String agentType) {
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        node.setType(agentType);
        AgentNode nod = node;
        nod.setAddress(agentAddress);
        nod.setState("Running");
        Enumeration<? extends TreeNode> folders = root.children();
        while (folders.hasMoreElements()) {
            Node folderNode = (Node)folders.nextElement();
            String folderName = folderNode.getName();
            if (!folderName.equalsIgnoreCase(this.localPlatformName)) continue;
            Enumeration<TreeNode> containers = folderNode.children();
            while (containers.hasMoreElements()) {
                Node container = (Node)containers.nextElement();
                String contName = container.getName();
                if (!contName.equalsIgnoreCase(containerName)) continue;
                model.insertNodeInto(node, container, container.getChildCount());
                return;
            }
        }
    }

    public void modifyAgentNode(String containerName, String agentName, String address, String state, String ownership) {
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        Enumeration<? extends TreeNode> folders = root.children();
        while (folders.hasMoreElements()) {
            Node folderNode = (Node)folders.nextElement();
            String folderName = folderNode.getName();
            if (!folderName.equalsIgnoreCase(this.localPlatformName)) continue;
            Enumeration<TreeNode> containers = folderNode.children();
            while (containers.hasMoreElements()) {
                Node container = (Node)containers.nextElement();
                String contName = container.getName();
                if (!contName.equalsIgnoreCase(containerName)) continue;
                Enumeration<TreeNode> agents = container.children();
                while (agents.hasMoreElements()) {
                    Node agent = (Node)agents.nextElement();
                    if (!agent.getName().equalsIgnoreCase(agentName)) continue;
                    if (state != null) {
                        agent.setState(state);
                    }
                    if (ownership != null) {
                        agent.setOwnership(ownership);
                    }
                    agent.changeIcon(state);
                    model.nodeChanged(agent);
                    return;
                }
            }
        }
    }

    public void moveAgentNode(String fromContainerName, String toContainerName, String agentName) {
        AgentTreeModel model = this.getModel();
        Node fromContainer = this.findContainerNode(fromContainerName);
        Node toContainer = this.findContainerNode(toContainerName);
        Node frozenAgents = this.findFrozenAgentsFolder(toContainer, FROZEN_AGENTS_FOLDER_NAME);
        if (frozenAgents != null) {
            Node agent = this.findAgentNode(frozenAgents, agentName);
            if (agent == null) {
                agent = this.findAgentNode(fromContainer, agentName);
                model.removeNodeFromParent(agent);
                model.insertNodeInto(agent, toContainer, toContainer.getChildCount());
            }
        } else {
            Node agent = this.findAgentNode(fromContainer, agentName);
            model.removeNodeFromParent(agent);
            model.insertNodeInto(agent, toContainer, toContainer.getChildCount());
        }
    }

    public void freezeAgentNode(String oldContainerName, String newContainerName, String agentName) {
        AgentTreeModel model = this.getModel();
        Node oldContainer = this.findContainerNode(oldContainerName);
        Node agent = this.findAgentNode(oldContainer, agentName);
        model.removeNodeFromParent(agent);
        agent.setState("frozen");
        agent.changeIcon("frozen");
        Node newContainer = this.findContainerNode(newContainerName);
        Node frozenAgents = this.findFrozenAgentsFolder(newContainer, FROZEN_AGENTS_FOLDER_NAME);
        if (frozenAgents == null) {
            frozenAgents = this.createContainerNode(FROZEN_AGENTS_FOLDER_NAME);
            frozenAgents.setType(FROZEN_CONTAINER_TYPE);
            model.insertNodeInto(frozenAgents, newContainer, 0);
        }
        model.insertNodeInto(agent, frozenAgents, frozenAgents.getChildCount());
    }

    public void thawAgentNode(String oldContainerName, String newContainerName, String agentName) {
        AgentTreeModel model = this.getModel();
        Node oldContainer = this.findContainerNode(oldContainerName);
        Node frozenAgents = this.findFrozenAgentsFolder(oldContainer, FROZEN_AGENTS_FOLDER_NAME);
        Node agent = this.findAgentNode(frozenAgents, agentName);
        model.removeNodeFromParent(agent);
        if (frozenAgents.isLeaf()) {
            model.removeNodeFromParent(frozenAgents);
        }
        agent.setState("active");
        agent.changeIcon("active");
        Node newContainer = this.findContainerNode(newContainerName);
        model.insertNodeInto(agent, newContainer, newContainer.getChildCount());
    }

    public void removeAgentNode(String containerName, String agentName) {
        AgentTreeModel model = this.getModel();
        Node container = this.findContainerNode(containerName);
        if (container != null) {
            Node agent = this.findAgentNode(container, agentName);
            if (agent != null) {
                model.removeNodeFromParent(agent);
            } else {
                Node frozenAgents = this.findFrozenAgentsFolder(container, FROZEN_AGENTS_FOLDER_NAME);
                if (frozenAgents != null) {
                    agent = this.findAgentNode(frozenAgents, agentName);
                    model.removeNodeFromParent(agent);
                    if (frozenAgents.isLeaf()) {
                        model.removeNodeFromParent(frozenAgents);
                    }
                }
            }
        }
    }

    public void addRemotePlatformNode(AID ams2, APDescription desc) {
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        Enumeration<? extends TreeNode> containers = root.children();
        while (containers.hasMoreElements()) {
            Node container = (Node)containers.nextElement();
            String contName = container.getName();
            if (!contName.equalsIgnoreCase(REMOTE_PLATFORMS_FOLDER_NAME)) continue;
            boolean found = false;
            Enumeration<TreeNode> agents = container.children();
            while (agents.hasMoreElements() && !found) {
                RemotePlatformNode platform = (RemotePlatformNode)agents.nextElement();
                String APName = platform.getName();
                if (!APName.equalsIgnoreCase(desc.getName())) continue;
                platform.setAPDescription(desc);
                found = true;
            }
            if (!found) {
                RemotePlatformNode node = new RemotePlatformNode(desc.getName());
                node.setAPDescription(desc);
                node.setAmsAID(ams2);
                model.insertNodeInto(node, container, container.getChildCount());
            }
            return;
        }
    }

    public void removeRemotePlatformNode(String name) {
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        Enumeration<? extends TreeNode> containers = root.children();
        while (containers.hasMoreElements()) {
            Node container = (Node)containers.nextElement();
            String contName = container.getName();
            if (!contName.equalsIgnoreCase(REMOTE_PLATFORMS_FOLDER_NAME)) continue;
            Enumeration<TreeNode> agents = container.children();
            while (agents.hasMoreElements()) {
                Node agent = (Node)agents.nextElement();
                String agName = agent.getName();
                if (!agName.equalsIgnoreCase(name)) continue;
                model.removeNodeFromParent(agent);
                if (container.getChildCount() == 0) {
                    model.removeNodeFromParent(container);
                }
                return;
            }
        }
    }

    public void addRemoteAgentNode(AMSAgentDescription agent, String HAP) {
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        Enumeration<? extends TreeNode> containers = root.children();
        while (containers.hasMoreElements()) {
            Node container = (Node)containers.nextElement();
            String contName = container.getName();
            if (!contName.equalsIgnoreCase(REMOTE_PLATFORMS_FOLDER_NAME)) continue;
            Enumeration<TreeNode> plat_Enum = container.children();
            while (plat_Enum.hasMoreElements()) {
                Node platformNode = (Node)plat_Enum.nextElement();
                String platformNodeName = platformNode.getName();
                if (!platformNodeName.equalsIgnoreCase(HAP)) continue;
                Enumeration<TreeNode> remote_agents = platformNode.children();
                boolean found = false;
                while (remote_agents.hasMoreElements() && !found) {
                    RemoteAgentNode node = (RemoteAgentNode)remote_agents.nextElement();
                    String remoteName = node.getName();
                    if (!remoteName.equalsIgnoreCase(agent.getName().getName())) continue;
                    node.setAMSDescription(agent);
                    found = true;
                }
                if (found) continue;
                RemoteAgentNode newNode = new RemoteAgentNode(agent.getName().getName());
                newNode.setAMSDescription(agent);
                int position = this.getPosition(newNode, platformNode);
                model.insertNodeInto(newNode, platformNode, position);
            }
        }
    }

    public void clearRemotePlatformAgents(String HAP) {
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        Enumeration<? extends TreeNode> containers = root.children();
        while (containers.hasMoreElements()) {
            Node container = (Node)containers.nextElement();
            String contName = container.getName();
            if (!contName.equalsIgnoreCase(REMOTE_PLATFORMS_FOLDER_NAME)) continue;
            Enumeration<TreeNode> plat_Enum = container.children();
            while (plat_Enum.hasMoreElements()) {
                Node platformNode = (Node)plat_Enum.nextElement();
                String platformNodeName = platformNode.getName();
                if (!platformNodeName.equalsIgnoreCase(HAP)) continue;
                Enumeration<TreeNode> en = platformNode.children();
                ArrayList<TreeNode> remoteAgents = new ArrayList<TreeNode>();
                while (en.hasMoreElements()) {
                    remoteAgents.add(en.nextElement());
                }
                for (int i = 0; i < remoteAgents.size(); ++i) {
                    Node remoteAgent = (Node)remoteAgents.get(i);
                    model.removeNodeFromParent(remoteAgent);
                }
            }
        }
    }

    public Node getSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            return (Node)path.getLastPathComponent();
        }
        return null;
    }

    public AgentTreeModel getModel() {
        if (this.tree.getModel() instanceof AgentTreeModel) {
            return (AgentTreeModel)this.tree.getModel();
        }
        System.out.println(this.tree.getModel());
        return null;
    }

    public void register(String key, JPopupMenu popmenu, String pathImage) {
        NodeDescriptor nDescriptor = new NodeDescriptor(popmenu, pathImage);
        this.mapDescriptor.put(key, nDescriptor);
    }

    public JPopupMenu getPopupMenu(String key) {
        NodeDescriptor nDescriptor = (NodeDescriptor)this.mapDescriptor.get(key);
        return nDescriptor.getPopupMenu();
    }

    public void setNewPopupMenu(String key, JPopupMenu pop) {
        if (this.mapDescriptor.containsKey(key)) {
            NodeDescriptor nDescriptor = (NodeDescriptor)this.mapDescriptor.get(key);
            nDescriptor.setNewPopupMenu(pop);
        }
    }

    protected String getIconAgent(String key) {
        NodeDescriptor nDescriptor = (NodeDescriptor)this.mapDescriptor.get(key);
        return nDescriptor.getPathImage();
    }

    private Node findAgentNode(Node container, String name) {
        Enumeration<TreeNode> agents = container.children();
        while (agents.hasMoreElements()) {
            Node agent = (Node)agents.nextElement();
            if (!agent.getName().equalsIgnoreCase(name)) continue;
            return agent;
        }
        return null;
    }

    private Node findContainerNode(String name) {
        AgentTreeModel model = this.getModel();
        MutableTreeNode root = (MutableTreeNode)model.getRoot();
        Enumeration<? extends TreeNode> folders = root.children();
        while (folders.hasMoreElements()) {
            Node folderNode = (Node)folders.nextElement();
            String folderName = folderNode.getName();
            if (!folderName.equalsIgnoreCase(this.localPlatformName)) continue;
            Enumeration<TreeNode> containers = folderNode.children();
            while (containers.hasMoreElements()) {
                Node container = (Node)containers.nextElement();
                String contName = container.getName();
                if (!contName.equalsIgnoreCase(name)) continue;
                return container;
            }
        }
        return null;
    }

    private Node findFrozenAgentsFolder(Node container, String name) {
        Enumeration<TreeNode> agents = container.children();
        while (agents.hasMoreElements()) {
            Node child = (Node)agents.nextElement();
            if (!child.getName().equalsIgnoreCase(name) || !child.getType().equalsIgnoreCase(FROZEN_CONTAINER_TYPE)) continue;
            return child;
        }
        return null;
    }

    public class RemoteAgentNode
    extends AgentNode {
        private AMSAgentDescription amsd;

        public RemoteAgentNode(String name) {
            super(name);
        }

        @Override
        public String getToolTipText() {
            return "Remote Agent";
        }

        @Override
        public void setType(String noType) {
        }

        @Override
        public String getType() {
            return AgentTree.REMOTE_AGENT_TYPE;
        }

        public void setAMSDescription(AMSAgentDescription id) {
            this.amsd = id;
        }

        public AMSAgentDescription getAMSDescription() {
            return this.amsd;
        }
    }

    public class RemotePlatformNode
    extends Node {
        private APDescription AP_Profile;
        private AID amsAID;

        public RemotePlatformNode(String name) {
            super(name);
        }

        @Override
        public String getToolTipText() {
            return "Remote Platform";
        }

        @Override
        public void setType(String noType) {
        }

        @Override
        public String getType() {
            return AgentTree.REMOTE_PLATFORM_TYPE;
        }

        public void setAPDescription(APDescription desc) {
            this.AP_Profile = desc;
        }

        public APDescription getAPDescription() {
            return this.AP_Profile;
        }

        public void setAmsAID(AID id) {
            this.amsAID = id;
        }

        public AID getAmsAID() {
            return this.amsAID;
        }
    }

    public class LocalPlatformFolderNode
    extends Node {
        public LocalPlatformFolderNode(String name) {
            super(name);
        }

        @Override
        public String getToolTipText() {
            return "Local JADE Platform";
        }

        @Override
        public void setType(String noType) {
        }

        @Override
        public String getType() {
            return AgentTree.LOCAL_PLATFORM_TYPE;
        }
    }

    public class RemotePlatformsFolderNode
    extends Node {
        public RemotePlatformsFolderNode(String name) {
            super(name);
        }

        @Override
        public String getToolTipText() {
            return "List of RemotePlatforms";
        }

        @Override
        public void setType(String noType) {
        }

        @Override
        public String getType() {
            return AgentTree.REMOTE_PLATFORMS_FOLDER_TYPE;
        }
    }

    public class SuperContainer
    extends Node {
        public SuperContainer(String name) {
            super(name);
        }

        @Override
        public String getToolTipText() {
            return "Java Agent DEvelopment Framework";
        }

        @Override
        public String getType() {
            return AgentTree.TREE_ROOT_TYPE;
        }

        @Override
        public void setType(String noType) {
        }
    }

    public class ContainerNode
    extends Node {
        private InetAddress addressmachine;
        private String containerType;

        public ContainerNode(String name) {
            super(name);
            this.containerType = AgentTree.CONTAINER_TYPE;
        }

        public void setAddress(InetAddress addr) {
            this.addressmachine = addr;
        }

        @Override
        public void setType(String type) {
            this.containerType = type;
        }

        @Override
        public String getType() {
            return this.containerType;
        }

        @Override
        public String getToolTipText() {
            if (this.addressmachine != null) {
                return this.name + " [" + this.addressmachine.getHostAddress() + "]";
            }
            return this.name + " [???:???:???:???]";
        }
    }

    public class AgentNode
    extends Node {
        private String agentType;
        private String agentAddress;

        public AgentNode(String name) {
            super(name);
            this.agentType = AgentTree.AGENT_TYPE;
        }

        public String getAddress() {
            return this.agentAddress;
        }

        public void setAddress(String address) {
            this.agentAddress = address;
        }

        @Override
        public void setType(String type) {
            this.agentType = type;
        }

        @Override
        public String getType() {
            return this.agentType;
        }

        @Override
        public String getToolTipText() {
            return "Local Agent";
        }
    }

    public abstract class Node
    extends DefaultMutableTreeNode {
        protected Icon img;
        protected String name;
        protected String state;
        protected String ownership;
        protected boolean greyOut = false;

        public Node(String name) {
            this.name = name;
        }

        public Icon getIcon(String typeAgent) {
            Image image = AgentTree.this.getToolkit().getImage(this.getClass().getResource(AgentTree.this.getIconAgent(typeAgent)));
            if (this.greyOut) {
                MyFilterImage colorfilter = new MyFilterImage();
                Image imageFiltered = AgentTree.this.createImage(new FilteredImageSource(image.getSource(), colorfilter));
                return new ImageIcon(imageFiltered);
            }
            return new ImageIcon(image);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getState() {
            return this.state != null ? this.state : "";
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getOwnership() {
            return this.ownership != null ? this.ownership : "";
        }

        public void setOwnership(String ownership) {
            this.ownership = ownership;
        }

        public void changeIcon(String agentState) {
            if (agentState.equalsIgnoreCase("suspended")) {
                this.greyOut = true;
                this.setType(AgentTree.AGENT_TYPE);
            } else if (agentState.equalsIgnoreCase("active")) {
                this.greyOut = false;
                this.setType(AgentTree.AGENT_TYPE);
            } else if (agentState.equalsIgnoreCase("frozen")) {
                this.greyOut = false;
                this.setType(AgentTree.FROZEN_AGENT_TYPE);
            }
        }

        public abstract String getType();

        public abstract void setType(String var1);

        public abstract String getToolTipText();

        @Override
        public String toString() {
            return this.getType() != null ? this.getType() + "-" + this.name : this.name;
        }

        public int compareTo(Node n) {
            return this.name.compareTo(n.getName());
        }
    }
}

