/*
 * Decompiled with CFR 0.152.
 */
package jade.domain.KBManagement;

import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.KBManagement.KB;
import jade.domain.KBManagement.KBIterator;
import jade.domain.KBManagement.LeaseManager;
import jade.lang.acl.ACLMessage;
import jade.proto.SubscriptionResponder;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class MemKB
extends KB {
    protected Map facts = new HashMap();
    protected Hashtable subscriptions = new Hashtable();
    protected LeaseManager lm;
    protected int currentReg = 0;
    protected SubscriptionResponder sr;
    protected static final int MAX_REGISTER_WITHOUT_CLEAN = 100;
    private Logger logger = Logger.getMyLogger(this.getClass().getName());
    int offSetForSubscriptionToReturn = 0;

    public MemKB(int maxResultLimit) {
        super(maxResultLimit);
    }

    @Override
    protected Object insert(Object name, Object fact) {
        ++this.currentReg;
        if (this.currentReg > 100) {
            this.clean();
            this.currentReg = 0;
        }
        return this.facts.put(name, fact);
    }

    @Override
    protected Object remove(Object name) {
        return this.facts.remove(name);
    }

    protected abstract boolean match(Object var1, Object var2);

    protected abstract void clean();

    @Override
    public List search(Object template, int maxResults) {
        ArrayList result = new ArrayList();
        Iterator it = this.facts.values().iterator();
        int found = 0;
        while (it.hasNext() && (maxResults < 0 || found < maxResults)) {
            Object fact = it.next();
            if (!this.match(template, fact)) continue;
            result.add(fact);
            ++found;
        }
        return result;
    }

    @Override
    public KBIterator iterator(Object template) {
        throw new RuntimeException("Iterated search non supported");
    }

    @Override
    public void subscribe(Object dfd, SubscriptionResponder.Subscription s) throws NotUnderstoodException {
        try {
            DFAgentDescription dfdTemplate = (DFAgentDescription)dfd;
            ACLMessage aclSub = s.getMessage();
            this.subscriptions.put(dfdTemplate, s);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Logger.SEVERE)) {
                this.logger.log(Logger.SEVERE, "Subscribe error: " + e.getMessage());
            }
            throw new NotUnderstoodException(e.getMessage());
        }
    }

    public Enumeration getSubscriptionDfAgentDescriptions() {
        return this.subscriptions.keys();
    }

    private SubscriptionResponder.Subscription getSubscription(Object key) {
        SubscriptionResponder.Subscription sub = (SubscriptionResponder.Subscription)this.subscriptions.get(key);
        return sub;
    }

    @Override
    public Enumeration getSubscriptions() {
        return this.subscriptions.elements();
    }

    public Enumeration getSubscriptions(int offset) {
        return null;
    }

    @Override
    public void unsubscribe(SubscriptionResponder.Subscription sub) {
        ACLMessage aclSub = sub.getMessage();
        String convID = aclSub.getConversationId();
        Enumeration e = this.getSubscriptionDfAgentDescriptions();
        if (e != null) {
            while (e.hasMoreElements()) {
                DFAgentDescription dfd = (DFAgentDescription)e.nextElement();
                SubscriptionResponder.Subscription s = this.getSubscription(dfd);
                if (!s.getMessage().getConversationId().equals(convID)) continue;
                this.subscriptions.remove(dfd);
                break;
            }
        }
    }

    public static final boolean matchAID(AID template, AID fact) {
        boolean found;
        String factName;
        String templateName = template.getName();
        if (!(templateName == null || (factName = fact.getName()) != null && templateName.equalsIgnoreCase(factName))) {
            return false;
        }
        Iterator itTemplate = template.getAllAddresses();
        Iterator itFact = fact.getAllAddresses();
        while (itTemplate.hasNext()) {
            String templateAddr = (String)itTemplate.next();
            found = false;
            while (!found && itFact.hasNext()) {
                String factAddr = (String)itFact.next();
                found = templateAddr.equalsIgnoreCase(factAddr);
            }
            if (found) continue;
            return false;
        }
        itTemplate = template.getAllResolvers();
        itFact = fact.getAllResolvers();
        while (itTemplate.hasNext()) {
            AID templateRes = (AID)itTemplate.next();
            found = false;
            while (!found && itFact.hasNext()) {
                AID factRes = (AID)itFact.next();
                found = MemKB.matchAID(templateRes, factRes);
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

