/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.lang.Codec;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.behaviours.CyclicBehaviour;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.KBManagement.KBIterator;
import jade.domain.df;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ConversationList;
import jade.lang.acl.MessageTemplate;
import jade.proto.SSIteratedAchieveREResponder;
import jade.util.Logger;
import jade.util.leap.ArrayList;

class DFIteratedSearchManagementBehaviour
extends CyclicBehaviour {
    private df theDF;
    private MessageTemplate template;
    private ConversationList conversations;
    private Logger logger;

    public DFIteratedSearchManagementBehaviour(df theDF, MessageTemplate mt) {
        super(theDF);
        this.theDF = theDF;
        this.conversations = new ConversationList(theDF);
        this.template = MessageTemplate.and(mt, this.conversations.getMessageTemplate());
        this.logger = Logger.getMyLogger(theDF.getLocalName());
    }

    @Override
    public void action() {
        ACLMessage msg = this.theDF.receive(this.template);
        if (msg != null) {
            if (this.logger.isLoggable(Logger.FINE)) {
                this.logger.log(Logger.FINE, "DF " + this.myAgent.getName() + ": Iterated-search request received from " + msg.getSender().getName() + ". Conv-ID = " + msg.getConversationId());
            }
            this.theDF.addBehaviour(new SSIteratedAchieveREResponder(this.theDF, msg){
                private KBIterator iterator;
                private String myConversationId;
                private int cnt;
                {
                    this.iterator = null;
                    this.myConversationId = null;
                    this.cnt = 0;
                }

                @Override
                protected ACLMessage handleRequest(ACLMessage request) throws RefuseException, FailureException, NotUnderstoodException {
                    ACLMessage reply = null;
                    if (DFIteratedSearchManagementBehaviour.this.logger.isLoggable(Logger.FINE)) {
                        DFIteratedSearchManagementBehaviour.this.logger.log(Logger.FINE, "DF " + this.myAgent.getName() + ": Iterated-search " + request.getConversationId() + ". Serving request # " + this.cnt);
                    }
                    ++this.cnt;
                    try {
                        Action aExpr = (Action)DFIteratedSearchManagementBehaviour.this.theDF.getContentManager().extractContent(request);
                        Search search = (Search)aExpr.getAction();
                        SearchConstraints constraints = search.getConstraints();
                        int maxResult = DFIteratedSearchManagementBehaviour.this.theDF.getActualMaxResults(constraints);
                        if (this.iterator == null) {
                            if (DFIteratedSearchManagementBehaviour.this.logger.isLoggable(Logger.FINER)) {
                                DFIteratedSearchManagementBehaviour.this.logger.log(Logger.FINER, "DF " + this.myAgent.getName() + ": Iterated-search " + request.getConversationId() + ". Initializing KBIterator");
                            }
                            this.iterator = DFIteratedSearchManagementBehaviour.this.theDF.iteratedSearchAction(search, request.getSender());
                            if (DFIteratedSearchManagementBehaviour.this.logger.isLoggable(Logger.FINEST)) {
                                DFIteratedSearchManagementBehaviour.this.logger.log(Logger.FINEST, "DF " + this.myAgent.getName() + ": Iterated-search " + request.getConversationId() + ". KBIterator correctly initialized");
                            }
                        }
                        ArrayList ll = new ArrayList();
                        for (int i = 0; i < maxResult; ++i) {
                            if (!this.iterator.hasNext()) {
                                if (DFIteratedSearchManagementBehaviour.this.logger.isLoggable(Logger.FINER)) {
                                    DFIteratedSearchManagementBehaviour.this.logger.log(Logger.FINER, "DF " + this.myAgent.getName() + ": Iterated-search " + request.getConversationId() + ". Closing KBIterator");
                                }
                                this.iterator.close();
                                this.closeSessionOnNextReply();
                                break;
                            }
                            ll.add(this.iterator.next());
                        }
                        if (DFIteratedSearchManagementBehaviour.this.logger.isLoggable(Logger.FINE)) {
                            DFIteratedSearchManagementBehaviour.this.logger.log(Logger.FINE, "DF " + this.myAgent.getName() + ": Iterated-search " + request.getConversationId() + ". Sending back " + ll.size() + " results");
                        }
                        reply = request.createReply();
                        try {
                            Result result = new Result(aExpr, ll);
                            DFIteratedSearchManagementBehaviour.this.theDF.getContentManager().fillContent(reply, result);
                            reply.setPerformative(7);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new FailureException("internal-error \"" + e.getMessage() + "\"");
                        }
                    }
                    catch (OntologyException oe) {
                        throw new NotUnderstoodException("unrecognised-value content");
                    }
                    catch (Codec.CodecException ce) {
                        throw new NotUnderstoodException("unrecognised-value content");
                    }
                    catch (FailureException fe) {
                        throw fe;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        throw new FailureException("internal-error \"" + t.getMessage() + "\"");
                    }
                    return reply;
                }

                @Override
                protected void handleCancel(ACLMessage cancel) {
                    if (DFIteratedSearchManagementBehaviour.this.logger.isLoggable(Logger.FINE)) {
                        DFIteratedSearchManagementBehaviour.this.logger.log(Logger.FINE, "DF " + this.myAgent.getName() + ": Iterated-search " + cancel.getConversationId() + ". Serving cancel");
                    }
                    if (this.iterator != null) {
                        if (DFIteratedSearchManagementBehaviour.this.logger.isLoggable(Logger.FINER)) {
                            DFIteratedSearchManagementBehaviour.this.logger.log(Logger.FINER, "DF " + this.myAgent.getName() + ": Iterated-search " + cancel.getConversationId() + ". Closing KBIterator");
                        }
                        this.iterator.close();
                    }
                }

                @Override
                protected void afterReply(ACLMessage reply) {
                    if (reply != null) {
                        this.myConversationId = reply.getConversationId();
                        DFIteratedSearchManagementBehaviour.this.conversations.registerConversation(this.myConversationId);
                    }
                }

                @Override
                public int onEnd() {
                    DFIteratedSearchManagementBehaviour.this.conversations.deregisterConversation(this.myConversationId);
                    return super.onEnd();
                }
            });
        } else {
            this.block();
        }
    }
}

