/*
 * Decompiled with CFR 0.152.
 */
package jade.core.sam;

import jade.core.sam.Provider;
import java.io.Serializable;

public class AverageMeasure
implements Serializable,
Provider {
    private static final long serialVersionUID = 423475294834L;
    private double value = Double.NaN;
    private int nSamples = 0;
    private double variance = 0.0;

    public AverageMeasure() {
    }

    public AverageMeasure(double value, int nSamples) {
        this.value = value;
        this.nSamples = nSamples;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public int getNSamples() {
        return this.nSamples;
    }

    public void setNSamples(int nSamples) {
        this.nSamples = nSamples;
    }

    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double variance) {
        this.variance = variance;
    }

    public void update(AverageMeasure am) {
        this.update(am, 0);
    }

    public void update(AverageMeasure am, int aggregation) {
        if (Double.compare(this.value, Double.NaN) == 0) {
            this.value = am.getValue();
            this.nSamples = am.getNSamples();
        } else if (Double.compare(am.getValue(), Double.NaN) != 0) {
            if (aggregation == 1) {
                this.value += am.getValue();
                this.nSamples += am.getNSamples();
            } else {
                double totValue = this.value * (double)this.nSamples + am.getValue() * (double)am.getNSamples();
                int totSamples = this.nSamples + am.getNSamples();
                this.value = totSamples != 0 ? totValue / (double)totSamples : 0.0;
                this.nSamples = totSamples;
            }
        }
    }
}

