/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.Agent;
import jade.core.FEService;
import jade.core.IMTPException;
import jade.core.NotFoundException;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.messaging.TopicManagementHelper;
import jade.core.messaging.TopicUtility;

public class TopicManagementFEService
extends FEService {
    @Override
    public String getName() {
        return "jade.core.messaging.TopicManagement";
    }

    @Override
    public String getBEServiceClassName() {
        return "jade.core.messaging.TopicManagementService";
    }

    @Override
    public ServiceHelper getHelper(Agent a) {
        TopicManagementHelper sh = new TopicManagementHelper(){
            private Agent myAgent;

            @Override
            public void init(Agent a) {
                this.myAgent = a;
            }

            @Override
            public AID createTopic(String topicName) {
                return TopicUtility.createTopic(topicName);
            }

            @Override
            public boolean isTopic(AID id) {
                return TopicUtility.isTopic(id);
            }

            @Override
            public void register(AID topic) throws ServiceException {
                try {
                    TopicManagementFEService.this.invoke(this.myAgent.getLocalName(), "register", new Object[]{topic});
                }
                catch (NotFoundException nfe) {
                    throw new ServiceException("Local agent " + this.myAgent.getLocalName() + " not found on the back-end");
                }
                catch (IMTPException imtpe) {
                    throw new ServiceException("Communication error: " + imtpe.getMessage(), imtpe);
                }
            }

            @Override
            public void register(AID id, AID topic) throws ServiceException {
                try {
                    TopicManagementFEService.this.invoke(this.myAgent.getLocalName(), "register", new Object[]{id, topic});
                }
                catch (NotFoundException nfe) {
                    throw new ServiceException("Local agent " + this.myAgent.getLocalName() + " not found on the back-end");
                }
                catch (IMTPException imtpe) {
                    throw new ServiceException("Communication error: " + imtpe.getMessage(), imtpe);
                }
            }

            @Override
            public void deregister(AID topic) throws ServiceException {
                try {
                    TopicManagementFEService.this.invoke(this.myAgent.getLocalName(), "deregister", new Object[]{topic});
                }
                catch (NotFoundException nfe) {
                    throw new ServiceException("Local agent " + this.myAgent.getLocalName() + " not found on the back-end");
                }
                catch (IMTPException imtpe) {
                    throw new ServiceException("Communication error: " + imtpe.getMessage(), imtpe);
                }
            }

            @Override
            public void deregister(AID id, AID topic) throws ServiceException {
                try {
                    TopicManagementFEService.this.invoke(this.myAgent.getLocalName(), "deregister", new Object[]{id, topic});
                }
                catch (NotFoundException nfe) {
                    throw new ServiceException("Local agent " + this.myAgent.getLocalName() + " not found on the back-end");
                }
                catch (IMTPException imtpe) {
                    throw new ServiceException("Communication error: " + imtpe.getMessage(), imtpe);
                }
            }
        };
        sh.init(a);
        return sh;
    }
}

