/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.CaseInsensitiveString;
import jade.core.IMTPException;
import jade.core.Runtime;
import jade.core.messaging.MessagingSlice;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.Property;
import jade.mtp.MTP;
import jade.mtp.MTPDescriptor;
import jade.mtp.MTPException;
import jade.mtp.OutChannel;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;

class RoutingTable {
    private static final boolean LOCAL = true;
    private static final boolean REMOTE = false;
    private final Map inPorts = new HashMap(2);
    private final Map outPorts = new HashMap(2);
    private final List remoteMTPs = new ArrayList();
    private static final int EXPECTED_PLATFORMADDRESSES_SIZE = 2;
    private final List platformAddresses = new ArrayList(2);
    private String platformInfo = null;

    public RoutingTable(boolean attachPlatformInfo) {
        if (attachPlatformInfo) {
            StringBuilder stringBuilder = new StringBuilder();
            Runtime.instance();
            this.platformInfo = stringBuilder.append(Runtime.getVersionInfo()).append(" (").append(System.getProperty("java.version")).append(", ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append(")").toString();
        }
    }

    public synchronized void addLocalMTP(String url, MTP proto, MTPDescriptor dsc) {
        CaseInsensitiveString urlTmp = new CaseInsensitiveString(url);
        this.inPorts.put(urlTmp, new MTPInfo(proto, dsc));
        OutViaMTP out = new OutViaMTP(proto, this.platformInfo);
        String[] protoNames = proto.getSupportedProtocols();
        for (int i = 0; i < protoNames.length; ++i) {
            this.addOutPort(protoNames[i], out, true);
        }
        this.platformAddresses.add(url);
    }

    public synchronized MTPInfo removeLocalMTP(String url) {
        CaseInsensitiveString urlTmp = new CaseInsensitiveString(url);
        MTPInfo info = (MTPInfo)this.inPorts.remove(urlTmp);
        if (info != null) {
            MTP proto = info.getMTP();
            String[] protoNames = proto.getSupportedProtocols();
            for (int i = 0; i < protoNames.length; ++i) {
                OutViaMTP out = new OutViaMTP(proto, this.platformInfo);
                this.removeOutPort(protoNames[i], out);
            }
        }
        this.platformAddresses.remove(url);
        return info;
    }

    public synchronized boolean addRemoteMTP(MTPDescriptor mtp, String sliceName, MessagingSlice where) {
        if (!this.remoteMTPs.contains(mtp)) {
            this.remoteMTPs.add(mtp);
            OutViaSlice out = new OutViaSlice(sliceName, where);
            String[] protoNames = mtp.getSupportedProtocols();
            for (int i = 0; i < protoNames.length; ++i) {
                this.addOutPort(protoNames[i], out, false);
            }
            String[] mtpAddrs = mtp.getAddresses();
            this.platformAddresses.add(mtpAddrs[0]);
            return true;
        }
        return false;
    }

    public synchronized void removeRemoteMTP(MTPDescriptor mtp, String sliceName, MessagingSlice where) {
        this.remoteMTPs.remove(mtp);
        OutViaSlice ch = new OutViaSlice(sliceName, where);
        String[] protoNames = mtp.getSupportedProtocols();
        for (int i = 0; i < protoNames.length; ++i) {
            this.removeOutPort(protoNames[i], ch);
        }
        String[] mtpAddrs = mtp.getAddresses();
        this.platformAddresses.remove(mtpAddrs[0]);
    }

    public synchronized OutPort lookup(String url) {
        String proto = this.extractProto(url);
        CaseInsensitiveString protoTmp = new CaseInsensitiveString(proto);
        OutPortList l = (OutPortList)this.outPorts.get(protoTmp);
        if (l != null) {
            return l.get();
        }
        return null;
    }

    public synchronized Iterator getAddresses() {
        return this.platformAddresses.iterator();
    }

    public synchronized Iterator getLocalMTPs() {
        return this.inPorts.values().iterator();
    }

    private void addOutPort(String proto, OutPort port, boolean location) {
        CaseInsensitiveString protoTmp = new CaseInsensitiveString(proto);
        OutPortList l = (OutPortList)this.outPorts.get(protoTmp);
        if (l != null) {
            l.add(port, location);
        } else {
            l = new OutPortList();
            l.add(port, location);
            this.outPorts.put(protoTmp, l);
        }
    }

    private void removeOutPort(String proto, OutPort port) {
        CaseInsensitiveString protoTmp = new CaseInsensitiveString(proto);
        OutPortList l = (OutPortList)this.outPorts.get(protoTmp);
        if (l != null) {
            l.remove(port);
        }
    }

    private String extractProto(String address) {
        int colonPos = address.indexOf(58);
        if (colonPos == -1) {
            return null;
        }
        return address.substring(0, colonPos);
    }

    class MTPInfo {
        private MTP mtp;
        private MTPDescriptor dsc;

        public MTPInfo(MTP mtp, MTPDescriptor dsc) {
            this.mtp = mtp;
            this.dsc = dsc;
        }

        public MTP getMTP() {
            return this.mtp;
        }

        public MTPDescriptor getDescriptor() {
            return this.dsc;
        }
    }

    private static class OutPortList {
        private final List local = new ArrayList(1);
        private final List remote = new ArrayList(1);

        private OutPortList() {
        }

        public void add(OutPort port, boolean location) {
            if (location) {
                this.local.add(port);
            } else {
                this.remote.add(port);
            }
        }

        public void remove(OutPort port) {
            this.local.remove(port);
            this.remote.remove(port);
        }

        public OutPort get() {
            if (!this.local.isEmpty()) {
                return (OutPort)this.local.get(0);
            }
            if (!this.remote.isEmpty()) {
                return (OutPort)this.remote.get(0);
            }
            return null;
        }

        public boolean isEmpty() {
            return this.local.isEmpty() && this.remote.isEmpty();
        }

        public String size() {
            return "[ local: " + this.local.size() + "  remote: " + this.remote.size() + " ]";
        }
    }

    private static class OutViaMTP
    implements OutPort {
        private final OutChannel myChannel;
        private String platformInfo;

        public OutViaMTP(OutChannel proto, String platformInfo) {
            this.myChannel = proto;
            this.platformInfo = platformInfo;
        }

        @Override
        public void route(Envelope env, byte[] payload, AID receiver, String address) throws MTPException {
            if (this.platformInfo != null) {
                env.addProperties(new Property("x-sender-platform-identifer", this.platformInfo));
                env.addProperties(new Property("x-sender-mtp-identifer", this.myChannel.getClass().getName()));
            }
            this.myChannel.deliver(address, env, payload);
        }

        public boolean equals(Object o) {
            try {
                OutViaMTP rhs = (OutViaMTP)o;
                OutChannel ch = rhs.myChannel;
                return this.myChannel.equals(ch);
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
    }

    private static class OutViaSlice
    implements OutPort {
        private final String sliceName;
        private final MessagingSlice slice;

        public OutViaSlice(String sn, MessagingSlice ms) {
            this.sliceName = sn;
            this.slice = ms;
        }

        @Override
        public void route(Envelope env, byte[] payload, AID receiver, String address) throws MTPException {
            try {
                this.slice.routeOut(env, payload, receiver, address);
            }
            catch (IMTPException imtpe) {
                throw new MTPException("Container unreachable during routing", imtpe);
            }
        }

        public boolean equals(Object o) {
            try {
                OutViaSlice rhs = (OutViaSlice)o;
                String sn = rhs.sliceName;
                return this.sliceName.equals(sn);
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
    }

    public static interface OutPort {
        public void route(Envelope var1, byte[] var2, AID var3, String var4) throws MTPException;
    }
}

