/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.MainContainer;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ServiceException;
import jade.core.Sink;
import jade.core.Timer;
import jade.core.TimerDispatcher;
import jade.core.TimerListener;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.LocalJVMMessageRouter;
import jade.core.messaging.MessageManager;
import jade.core.messaging.MessagingService;
import jade.core.messaging.MessagingSlice;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.security.JADESecurityException;
import jade.util.Logger;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public abstract class MomMessagingService
extends MessagingService {
    public static final String SEPARATOR = "#";
    private LocalJVMMessageRouter localRouter;
    protected String myLocation;
    private Map<AID, String> locationsCache = new Hashtable<AID, String>();
    private long deliveryCnt = 0L;
    protected boolean active;
    private Map<String, DeliveryContext> ongoingDeliveries = new HashMap<String, DeliveryContext>();
    private long deliveryCompletionTimeout = 60000L;

    @Override
    public void boot(Profile myProfile) throws ServiceException {
        super.boot(myProfile);
        this.myLocation = this.myContainer.getID().getName();
        this.active = true;
        this.localRouter = LocalJVMMessageRouter.getRouter(this.myContainer.getPlatformID());
        this.localRouter.register(this.myLocation, this);
        try {
            this.deliveryCompletionTimeout = Long.parseLong(myProfile.getParameter("delivery-completion-timeout", null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initMom();
    }

    @Override
    public void shutdown() {
        this.active = false;
        this.shutdownMom();
        super.shutdown();
        this.localRouter.deregister(this.myLocation);
    }

    @Override
    public Sink getCommandSink(boolean side) {
        final Sink realSink = super.getCommandSink(side);
        if (!side) {
            if (!this.myProfile.getBooleanProperty("use-message-manager", false)) {
                this.myLogger.log(Logger.INFO, "MessagingService configured to skip MessageManager");
                return new Sink(){

                    @Override
                    public void consume(VerticalCommand cmd) {
                        String name = cmd.getName();
                        if (name.equals("Send-Message")) {
                            Object[] params = cmd.getParams();
                            AID sender = (AID)params[0];
                            GenericMessage msg = (GenericMessage)params[1];
                            AID dest = (AID)params[2];
                            msg.setSenderPrincipal(cmd.getPrincipal());
                            msg.setSenderCredentials(cmd.getCredentials());
                            msg.setSender(sender);
                            MomMessagingService.this.checkTracing(msg);
                            if (msg.getTraceID() != null) {
                                MomMessagingService.this.myLogger.log(Logger.INFO, "MessagingService source sink handling message " + MessageManager.stringify(msg) + " for receiver " + dest.getName() + ". TraceID = " + msg.getTraceID());
                            }
                            MomMessagingService.this.deliverNow(msg, dest);
                        } else {
                            realSink.consume(cmd);
                        }
                    }
                };
            }
            this.myLogger.log(Logger.INFO, "MessagingService configured to use MessageManager");
            return realSink;
        }
        return realSink;
    }

    protected void initMom() {
    }

    protected void shutdownMom() {
    }

    protected synchronized String generateDeliveryID(AID senderID, GenericMessage msg, AID receiverID) {
        return this.myLocation + SEPARATOR + String.valueOf(this.deliveryCnt++);
    }

    protected String extractSource(String deliveryID) {
        int k = deliveryID.indexOf(SEPARATOR);
        return deliveryID.substring(0, k);
    }

    @Override
    protected void deliverInLocalPlatfrom(GenericMessage msg, AID receiverID) throws IMTPException, ServiceException, NotFoundException, JADESecurityException {
        AID senderID = msg.getSender();
        String deliveryID = this.generateDeliveryID(senderID, msg, receiverID);
        MainContainer impl = this.myContainer.getMain();
        try {
            if (impl != null) {
                GADTDeliveryContext context = new GADTDeliveryContext(deliveryID, senderID, msg, receiverID);
                this.registerContext(context);
                String receiverLocation = this.getAgentLocation(receiverID).getName();
                context.setReceiverLocation(receiverLocation);
                this.sendMessage(deliveryID, senderID, msg, receiverID, receiverLocation);
            } else {
                String receiverLocation = this.locationsCache.get(receiverID);
                if (receiverLocation != null) {
                    CacheDeliveryContext context = new CacheDeliveryContext(deliveryID, senderID, msg, receiverID);
                    this.registerContext(context);
                    context.setReceiverLocation(receiverLocation);
                    this.sendMessage(deliveryID, senderID, msg, receiverID, receiverLocation);
                } else {
                    DeliveryContext context = new DeliveryContext(deliveryID, senderID, msg, receiverID);
                    this.registerContext(context);
                    this.defaultDeliver(deliveryID, senderID, msg, receiverID);
                }
            }
        }
        catch (AsynchDelivery receiverLocation) {
        }
        catch (Exception e) {
            this.handleDeliveryResult(deliveryID, e);
        }
    }

    private void defaultDeliver(String deliveryID, AID senderID, GenericMessage msg, AID receiverID) throws IMTPException, NotFoundException, JADESecurityException, ServiceException {
        try {
            DeliveryContext context = this.getContext(deliveryID);
            String receiverLocation = null;
            MessagingSlice mainSlice = (MessagingSlice)this.getSlice("$$$Main-Slice$$$");
            try {
                receiverLocation = mainSlice.getAgentLocation(receiverID).getName();
            }
            catch (IMTPException imtpe) {
                mainSlice = (MessagingSlice)this.getFreshSlice("$$$Main-Slice$$$");
                receiverLocation = mainSlice.getAgentLocation(receiverID).getName();
            }
            context.setReceiverLocation(receiverLocation);
            this.sendMessage(deliveryID, senderID, msg, receiverID, receiverLocation);
        }
        catch (ServiceException se) {
            if (this.myContainer.isLocalAgent(receiverID)) {
                MessagingSlice localSlice = (MessagingSlice)this.getIMTPManager().createSliceProxy(this.getName(), this.getHorizontalInterface(), this.getLocalNode());
                localSlice.dispatchLocally(msg.getSender(), msg, receiverID);
                this.handleDeliveryResult(deliveryID, null);
            }
            throw se;
        }
    }

    protected void handleDeliveryResult(String deliveryID, Throwable t) {
        DeliveryContext context = this.deregisterContext(deliveryID);
        if (context != null) {
            if (t == null) {
                context.success();
            } else if (this.active) {
                context.failure(t);
            }
        } else {
            this.myLogger.log(Logger.WARNING, "Context for delivery " + deliveryID + " not found");
        }
    }

    private synchronized void registerContext(final DeliveryContext context) {
        this.ongoingDeliveries.put(context.deliveryID, context);
        if (this.deliveryCompletionTimeout > 0L) {
            Timer watchDog = TimerDispatcher.getTimerDispatcher().add(new Timer(System.currentTimeMillis() + this.deliveryCompletionTimeout, new TimerListener(){

                @Override
                public void doTimeOut(Timer t) {
                    MomMessagingService.this.timeout(context);
                }
            }));
            context.setWatchDog(watchDog);
        }
    }

    private synchronized DeliveryContext getContext(String deliveryID) {
        return this.ongoingDeliveries.get(deliveryID);
    }

    private synchronized DeliveryContext deregisterContext(String deliveryID) {
        Timer watchDog;
        DeliveryContext context = this.ongoingDeliveries.remove(deliveryID);
        if (context != null && (watchDog = context.getWatchDog()) != null) {
            TimerDispatcher.getTimerDispatcher().remove(watchDog);
        }
        return context;
    }

    private synchronized void timeout(DeliveryContext context) {
        context.setWatchDog(null);
        this.deregisterContext(context.deliveryID);
        context.failure(new IMTPException("Delivery TIMEOUT expired"));
    }

    private void sendMessage(String deliveryID, AID senderID, GenericMessage msg, AID receiverID, String receiverLocation) throws IMTPException {
        boolean sent = this.localRouter.localSendMessage(deliveryID, senderID, msg, receiverID, receiverLocation, this);
        if (!sent) {
            this.sendMessageViaMom(deliveryID, senderID, msg, receiverID, receiverLocation);
            throw new AsynchDelivery();
        }
    }

    Object processIncomingMessage(AID senderID, GenericMessage msg, AID receiverID) {
        GenericCommand cmd = new GenericCommand("1", "jade.core.messaging.Messaging", null);
        cmd.addParam(senderID);
        cmd.addParam(msg);
        cmd.addParam(receiverID);
        long timeStamp = msg.getTimeStamp();
        if (timeStamp > 0L) {
            cmd.addParam(new Long(timeStamp));
        }
        cmd.setPrincipal(msg.getSenderPrincipal());
        cmd.setCredentials(msg.getSenderCredentials());
        try {
            return this.getLocalNode().accept(cmd);
        }
        catch (IMTPException imtpe) {
            return imtpe;
        }
    }

    protected abstract void sendMessageViaMom(String var1, AID var2, GenericMessage var3, AID var4, String var5) throws IMTPException;

    protected abstract void sendReceiptViaMom(String var1, String var2, Throwable var3);

    protected void handleMessageFromMom(String deliveryID, AID senderID, GenericMessage msg, AID receiverID, String senderLocation) {
        Object ret = this.processIncomingMessage(senderID, msg, receiverID);
        this.sendReceiptViaMom(deliveryID, senderLocation, (Throwable)ret);
    }

    protected void handleReceiptFromMom(String deliveryID, Throwable t) {
        this.handleDeliveryResult(deliveryID, t);
    }

    private class CacheDeliveryContext
    extends DeliveryContext {
        CacheDeliveryContext(String deliveryID, AID senderID, GenericMessage msg, AID receiverID) {
            super(deliveryID, senderID, msg, receiverID);
        }

        @Override
        protected void failure(Throwable t) {
            MomMessagingService.this.locationsCache.remove(this.receiverID);
            DeliveryContext context = new DeliveryContext(this.deliveryID, this.senderID, this.msg, this.receiverID);
            MomMessagingService.this.registerContext(context);
            try {
                MomMessagingService.this.defaultDeliver(this.deliveryID, this.senderID, this.msg, this.receiverID);
            }
            catch (AsynchDelivery asynchDelivery) {
            }
            catch (Exception e) {
                MomMessagingService.this.handleDeliveryResult(this.deliveryID, e);
            }
        }
    }

    private class GADTDeliveryContext
    extends DeliveryContext {
        GADTDeliveryContext(String deliveryID, AID senderID, GenericMessage msg, AID receiverID) {
            super(deliveryID, senderID, msg, receiverID);
        }

        @Override
        protected void success() {
        }

        @Override
        protected void retry() {
            this.receiverLocation = null;
            MomMessagingService.this.registerContext(this);
            try {
                String receiverLocation = MomMessagingService.this.getAgentLocation(this.receiverID).getName();
                this.setReceiverLocation(receiverLocation);
                MomMessagingService.this.sendMessage(this.deliveryID, this.senderID, this.msg, this.receiverID, receiverLocation);
            }
            catch (AsynchDelivery receiverLocation) {
            }
            catch (Exception e) {
                MomMessagingService.this.handleDeliveryResult(this.deliveryID, e);
            }
        }
    }

    private class DeliveryContext {
        protected String deliveryID;
        protected GenericMessage msg;
        protected AID senderID;
        protected AID receiverID;
        protected String receiverLocation = null;
        protected int attemptsCnt = 0;
        protected Timer watchDog = null;

        DeliveryContext(String deliveryID, AID senderID, GenericMessage msg, AID receiverID) {
            this.deliveryID = deliveryID;
            this.senderID = senderID;
            this.msg = msg;
            this.receiverID = receiverID;
        }

        void setReceiverLocation(String receiverLocation) {
            this.receiverLocation = receiverLocation;
        }

        void setWatchDog(Timer watchDog) {
            this.watchDog = watchDog;
        }

        Timer getWatchDog() {
            return this.watchDog;
        }

        protected void success() {
            MomMessagingService.this.locationsCache.put(this.receiverID, this.receiverLocation);
        }

        protected void failure(Throwable t) {
            String id;
            String string = id = this.msg.getTraceID() != null ? this.msg.getTraceID() : MessageManager.stringify(this.msg);
            if (t instanceof NotFoundException) {
                if (this.receiverLocation == null) {
                    if (this.msg.getTraceID() != null) {
                        MomMessagingService.this.myLogger.log(Logger.WARNING, this.msg.getTraceID() + " - Receiver " + this.receiverID.getLocalName() + " does not exist.", t);
                    }
                    MomMessagingService.this.notifyFailureToSender(this.msg, this.receiverID, new InternalError("Agent not found: " + t.getMessage()));
                } else {
                    ++this.attemptsCnt;
                    if (this.attemptsCnt < MomMessagingService.this.maxDeliveryRetryAttempts) {
                        this.retry();
                    } else {
                        MomMessagingService.this.myLogger.log(Logger.WARNING, id + " - Max attempts reached trying to deliver message to " + this.receiverID.getLocalName() + ".");
                        MomMessagingService.this.notifyFailureToSender(this.msg, this.receiverID, new InternalError("Service error: Max attempts reached"));
                    }
                }
            } else if (t instanceof JADESecurityException) {
                if (this.msg.getTraceID() != null) {
                    MomMessagingService.this.myLogger.log(Logger.WARNING, this.msg.getTraceID() + " - Not authorized.", t);
                }
                MomMessagingService.this.notifyFailureToSender(this.msg, this.receiverID, new InternalError("Agent not found: " + t.getMessage()));
            } else if (t instanceof ServiceException) {
                MomMessagingService.this.myLogger.log(Logger.WARNING, id + " - Service error delivering message to " + this.receiverID.getLocalName() + ".", t);
                MomMessagingService.this.notifyFailureToSender(this.msg, this.receiverID, new InternalError("Service error: " + t.getMessage()));
            } else if (t instanceof IMTPException) {
                MomMessagingService.this.myLogger.log(Logger.WARNING, id + " - Receiver " + this.receiverID.getLocalName() + " unreachable.", t);
                MomMessagingService.this.notifyFailureToSender(this.msg, this.receiverID, new InternalError("Agent unreachable: " + t.getMessage()));
            } else {
                MomMessagingService.this.myLogger.log(Logger.WARNING, id + " - Unexpected error delivering message to " + this.receiverID.getLocalName(), t);
                MomMessagingService.this.notifyFailureToSender(this.msg, this.receiverID, new InternalError("Agent unreachable: " + t.getMessage()));
            }
        }

        protected void retry() {
            this.receiverLocation = null;
            MomMessagingService.this.registerContext(this);
            try {
                MomMessagingService.this.defaultDeliver(this.deliveryID, this.senderID, this.msg, this.receiverID);
            }
            catch (AsynchDelivery asynchDelivery) {
            }
            catch (Exception e) {
                MomMessagingService.this.handleDeliveryResult(this.deliveryID, e);
            }
        }
    }

    private class AsynchDelivery
    extends RuntimeException {
        public AsynchDelivery() {
            super("");
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

