/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ResourceManager;
import jade.core.Runtime;
import jade.core.UnreachableException;
import jade.core.messaging.DeliveryTracing;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MultipleGenericMessage;
import jade.core.messaging.OutBox;
import jade.core.messaging.QueueFullException;
import jade.core.messaging.StuckDeliverer;
import jade.core.sam.AverageMeasureProviderImpl;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.lang.acl.ACLMessage;
import jade.util.Logger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class MessageManager {
    private static MessageManager theInstance;
    private static final String DUMMY_RECEIVER_NAME = "___DUMMY_";
    private static final int POOL_SIZE_DEFAULT = 5;
    private static final int MAX_POOL_SIZE = 100;
    private static final int DELIVERY_TIME_THRESHOLD_DEFAULT = 1000;
    private static final int DELIVERY_TIME_THRESHOLD2_DEFAULT = 5000;
    private static final int DELIVERY_STUCK_TIME_DEFAULT = 60000;
    private static final int WARNING_QUEUE_SIZE_DEFAULT = 10000000;
    private static final int MAX_QUEUE_SIZE_DEFAULT = 100000000;
    private static final int SLEEP_TIME_FACTOR_DEFAULT = -1;
    private OutBox outBox;
    private Thread[] delivererThreads;
    private Deliverer[] deliverers;
    private boolean active = true;
    private long deliveryTimeThreshold;
    private long deliveryTimeThreshold2;
    private long deliveryStuckTime;
    private long totSubmittedCnt = 0L;
    private long totServedCnt = 0L;
    private long totDiscardedCnt = 0L;
    private long totSlowDeliveryCnt = 0L;
    private long totVerySlowDeliveryCnt = 0L;
    private long totMultipleDeliveryCnt = 0L;
    private AverageMeasureProviderImpl avgMsgCountPerMultipleDelivery = new AverageMeasureProviderImpl();
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    private MessageManager() {
    }

    public static synchronized MessageManager instance(Profile p) {
        if (theInstance == null) {
            theInstance = new MessageManager();
            theInstance.initialize(p);
        }
        return theInstance;
    }

    public void initialize(Profile p) {
        int sleepTimeFactor;
        int maxQueueSize;
        int warningQueueSize;
        int poolSize;
        block24: {
            String tmp;
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    tmp = null;
                                    poolSize = 5;
                                    try {
                                        tmp = p.getParameter("jade_core_messaging_MessageManager_poolsize", null);
                                        poolSize = Integer.parseInt(tmp);
                                    }
                                    catch (Exception e) {
                                        if (tmp == null) break block18;
                                        this.myLogger.log(Logger.WARNING, "\"" + tmp + "\" is not a valid int value for parameter jade_core_messaging_MessageManager_poolsize. Keep default");
                                    }
                                }
                                this.deliveryTimeThreshold = 1000L;
                                try {
                                    tmp = p.getParameter("jade_core_messaging_MessageManager_deliverytimethreshold", null);
                                    this.deliveryTimeThreshold = Long.parseLong(tmp);
                                }
                                catch (Exception e) {
                                    if (tmp == null) break block19;
                                    this.myLogger.log(Logger.WARNING, "\"" + tmp + "\" is not a valid int long for parameter jade_core_messaging_MessageManager_deliverytimethreshold. Keep default");
                                }
                            }
                            this.deliveryTimeThreshold2 = 5000L;
                            try {
                                tmp = p.getParameter("jade_core_messaging_MessageManager_deliverytimethreshold2", null);
                                this.deliveryTimeThreshold2 = Long.parseLong(tmp);
                            }
                            catch (Exception e) {
                                if (tmp == null) break block20;
                                this.myLogger.log(Logger.WARNING, "\"" + tmp + "\" is not a valid long value for parameter jade_core_messaging_MessageManager_deliverytimethreshold2. Keep default");
                            }
                        }
                        this.deliveryStuckTime = 60000L;
                        try {
                            tmp = p.getParameter("jade_core_messaging_MessageManager_deliveryStuckTime", null);
                            this.deliveryStuckTime = Long.parseLong(tmp);
                        }
                        catch (Exception e) {
                            if (tmp == null) break block21;
                            this.myLogger.log(Logger.WARNING, "\"" + tmp + "\" is not a valid long value for parameter jade_core_messaging_MessageManager_deliveryStuckTime. Keep default");
                        }
                    }
                    warningQueueSize = 10000000;
                    try {
                        tmp = p.getParameter("jade_core_messaging_MessageManager_warningqueuesize", null);
                        warningQueueSize = Integer.parseInt(tmp);
                    }
                    catch (Exception e) {
                        if (tmp == null) break block22;
                        this.myLogger.log(Logger.WARNING, "\"" + tmp + "\" is not a valid int value for parameter jade_core_messaging_MessageManager_warningqueuesize. Keep default");
                    }
                }
                maxQueueSize = 100000000;
                try {
                    tmp = p.getParameter("jade_core_messaging_MessageManager_maxqueuesize", null);
                    maxQueueSize = Integer.parseInt(tmp);
                }
                catch (Exception e) {
                    if (tmp == null) break block23;
                    this.myLogger.log(Logger.WARNING, "\"" + tmp + "\" is not a valid int value for parameter jade_core_messaging_MessageManager_maxqueuesize. Keep default");
                }
            }
            sleepTimeFactor = -1;
            try {
                tmp = p.getParameter("jade_core_messaging_MessageManager_sleeptimefactor", null);
                sleepTimeFactor = Integer.parseInt(tmp);
            }
            catch (Exception e) {
                if (tmp == null) break block24;
                this.myLogger.log(Logger.WARNING, "\"" + tmp + "\" is not a valid int value for parameter jade_core_messaging_MessageManager_sleeptimefactor. Keep default");
            }
        }
        boolean enableMultipleDelivery = p.getBooleanProperty("jade_core_messaging_MessageManager_enablemultipledelivery", true);
        this.outBox = new OutBox(warningQueueSize, maxQueueSize, sleepTimeFactor, enableMultipleDelivery, this);
        try {
            ResourceManager rm = p.getResourceManager();
            this.delivererThreads = new Thread[poolSize];
            this.deliverers = new Deliverer[poolSize];
            for (int i = 0; i < poolSize; ++i) {
                String pad = i < 10 ? "0" : "";
                String name = "Deliverer-" + pad + i;
                this.deliverers[i] = new Deliverer(name);
                this.delivererThreads[i] = rm.getThread(2, name, this.deliverers[i]);
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, "Starting deliverer " + name + ". Thread=" + this.delivererThreads[i]);
                }
                this.delivererThreads[i].start();
            }
            Runtime.instance().invokeOnTermination(new Runnable(){

                @Override
                public void run() {
                    MessageManager.this.shutdown();
                }
            });
        }
        catch (ProfileException pe) {
            throw new RuntimeException("Can't get ResourceManager. " + pe.getMessage());
        }
    }

    private void shutdown() {
        this.myLogger.log(Logger.INFO, "MessageManager shutting down ...");
        this.active = false;
        for (int i = 0; i < this.deliverers.length; ++i) {
            this.outBox.addLast(new AID(DUMMY_RECEIVER_NAME + i, true), new GenericMessage(), null);
        }
        theInstance = null;
    }

    private int getDelivererIndex(String name) {
        if (name != null) {
            int length = name.length();
            return (name.charAt(length - 2) - 48) * 10 + (name.charAt(length - 1) - 48);
        }
        return -1;
    }

    boolean isStuck(String name) {
        int index = this.getDelivererIndex(name);
        if (index >= 0 && index < this.deliverers.length) {
            Deliverer d = this.deliverers[index];
            return d.isStuck();
        }
        return false;
    }

    public void deliver(GenericMessage msg, AID receiverID, Channel ch) {
        if (this.active) {
            ++this.totSubmittedCnt;
            try {
                this.outBox.addLast(receiverID, msg, ch);
            }
            catch (Exception e) {
                ++this.totDiscardedCnt;
                if (!(e instanceof QueueFullException)) {
                    if (e instanceof StuckDeliverer) {
                        String name = ((StuckDeliverer)e).getDelivererName();
                        this.myLogger.log(Logger.WARNING, "Deliverer " + name + " appears to be stuck!!!!! Try to interrupt it...");
                        int index = this.getDelivererIndex(name);
                        if (index >= 0 && index < this.delivererThreads.length) {
                            this.delivererThreads[index].interrupt();
                        }
                    }
                    ch.notifyFailureToSender(msg, receiverID, new InternalError(e.getMessage()));
                }
            }
        } else {
            this.myLogger.log(Logger.WARNING, "MessageManager NOT active. Cannot deliver message " + MessageManager.stringify(msg));
        }
    }

    public static final String stringify(GenericMessage m) {
        if (m instanceof MultipleGenericMessage) {
            StringBuffer sb = new StringBuffer("[SET");
            MultipleGenericMessage mm = (MultipleGenericMessage)m;
            List<GenericMessage> l = mm.getMessages();
            int cnt = 0;
            for (GenericMessage gm : l) {
                sb.append(" ");
                sb.append(MessageManager.stringify(gm));
                if (++cnt <= 10 || cnt >= l.size()) continue;
                sb.append("..." + l.size() + " messages in total");
                break;
            }
            sb.append("]");
            return sb.toString();
        }
        ACLMessage msg = m.getACLMessage();
        if (msg != null) {
            return msg.shortToString();
        }
        return "\"Unavailable\"";
    }

    public static void main(String[] args) {
        GenericMessage gm = new GenericMessage();
        ACLMessage msg = new ACLMessage(7);
        msg.setSender(new AID("pippo@P1", true));
        msg.addReceiver(new AID("pluto@P1", true));
        gm.setACLMessage(msg);
        System.out.println(MessageManager.stringify(gm));
        MultipleGenericMessage mgm = new MultipleGenericMessage(200);
        ArrayList<GenericMessage> l = new ArrayList<GenericMessage>();
        l.add(gm);
        l.add(gm);
        mgm.setMessages(l);
        System.out.println(MessageManager.stringify(mgm));
    }

    String[] getQueueStatus() {
        return this.outBox.getStatus();
    }

    int getSize() {
        return this.outBox.getSize();
    }

    int getPendingCnt() {
        return this.outBox.getPendingCnt();
    }

    long getSubmittedCnt() {
        return this.totSubmittedCnt;
    }

    long getServedCnt() {
        return this.totServedCnt;
    }

    long getDiscardedCnt() {
        return this.totDiscardedCnt;
    }

    long getSlowDeliveryCnt() {
        return this.totSlowDeliveryCnt;
    }

    long getVerySlowDeliveryCnt() {
        return this.totVerySlowDeliveryCnt;
    }

    long getMultipleDeliveryCnt() {
        return this.totMultipleDeliveryCnt;
    }

    AverageMeasureProviderImpl getAvgMsgCountPerMultipleDeliveryProvider() {
        return this.avgMsgCountPerMultipleDelivery;
    }

    String getGlobalInfo() {
        return "Submitted-messages = " + this.totSubmittedCnt + ", Served-messages = " + this.totServedCnt + ", Discarded-messages = " + this.totDiscardedCnt + ", Queue-size (byte) = " + this.outBox.getSize() + ", Multiple-delivery-occurrences = " + this.totMultipleDeliveryCnt;
    }

    String[] getThreadPoolStatus() {
        String[] status = new String[this.deliverers.length];
        for (int i = 0; i < this.deliverers.length; ++i) {
            Deliverer d = this.deliverers[i];
            String details = null;
            details = d.isStuck() ? "STUCK!!! last-delivery-start-time=" + this.timeFormat.format(new Date(d.getLastDeliveryStartTime())) : "last-delivery-end-time=" + this.timeFormat.format(new Date(d.getLastDeliveryEndTime()));
            status[i] = "(" + d.name + ": thread-alive=" + this.delivererThreads[i].isAlive() + ", Served-messages=" + d.getServedCnt() + ", " + details + ")";
        }
        return status;
    }

    Thread[] getThreadPool() {
        return this.delivererThreads;
    }

    public static class PendingMsg {
        private GenericMessage msg;
        private final AID receiverID;
        private final Channel channel;
        private long deadline;

        public PendingMsg(GenericMessage msg, AID receiverID, Channel channel, long deadline) {
            this.msg = msg;
            this.receiverID = receiverID;
            this.channel = channel;
            this.deadline = deadline;
        }

        public void setMessage(GenericMessage msg) {
            this.msg = msg;
        }

        public GenericMessage getMessage() {
            return this.msg;
        }

        public AID getReceiver() {
            return this.receiverID;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public long getDeadline() {
            return this.deadline;
        }

        public void setDeadline(long deadline) {
            this.deadline = deadline;
        }
    }

    class Deliverer
    implements Runnable {
        private String name;
        private long lastDeliveryStartTime = -1L;
        private long lastDeliveryEndTime = -1L;
        private boolean delivering = false;
        private long servedCnt = 0L;

        Deliverer(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (MessageManager.this.active) {
                PendingMsg pm = MessageManager.this.outBox.get();
                DeliveryTracing.beginTracing();
                this.lastDeliveryStartTime = System.currentTimeMillis();
                GenericMessage msg = pm.getMessage();
                AID receiverID = pm.getReceiver();
                Channel ch = pm.getChannel();
                if (ch == null) continue;
                this.delivering = true;
                try {
                    ch.deliverNow(msg, receiverID);
                }
                catch (Throwable t) {
                    MessageManager.this.myLogger.log(Logger.WARNING, "MessageManager cannot deliver message " + MessageManager.stringify(msg) + " to agent " + receiverID.getName(), t);
                    ch.notifyFailureToSender(msg, receiverID, new InternalError("Unexpected error: " + t));
                }
                finally {
                    this.delivering = false;
                }
                int k = msg.getMessagesCnt();
                this.servedCnt += (long)k;
                MessageManager.this.totServedCnt += k;
                if (k > 1) {
                    MessageManager.this.totMultipleDeliveryCnt++;
                    MessageManager.this.avgMsgCountPerMultipleDelivery.addSample(k);
                }
                MessageManager.this.outBox.handleServed(receiverID, k);
                this.lastDeliveryEndTime = System.currentTimeMillis();
                long deliveryTime = this.lastDeliveryEndTime - this.lastDeliveryStartTime;
                try {
                    long threshold;
                    if (MessageManager.this.deliveryTimeThreshold <= 0L || deliveryTime <= (threshold = k == 1 ? MessageManager.this.deliveryTimeThreshold : Math.min(MessageManager.this.deliveryTimeThreshold / 2L * (long)k, 10000L))) continue;
                    MessageManager.this.totSlowDeliveryCnt += k;
                    String msgDetail = k == 1 ? "message size = " + msg.length() : "block of " + k + " messages with overall size = " + msg.length();
                    MessageManager.this.myLogger.log(Logger.WARNING, "Deliverer Thread " + this.name + " - Delivery-time over threshold (" + deliveryTime + "). Receiver = " + receiverID.getLocalName() + ", " + msgDetail + ". " + DeliveryTracing.report());
                    long threshold2 = k == 1 ? MessageManager.this.deliveryTimeThreshold2 : Math.min(MessageManager.this.deliveryTimeThreshold2 / 2L * (long)k, 30000L);
                    if (deliveryTime <= threshold2) continue;
                    MessageManager.this.totVerySlowDeliveryCnt++;
                }
                catch (Exception e) {
                    MessageManager.this.myLogger.log(Logger.WARNING, "Unexpected error computing message delivery time", e);
                }
            }
            MessageManager.this.myLogger.log(Logger.CONFIG, "Deliverer Thread " + this.name + " terminated");
        }

        long getServedCnt() {
            return this.servedCnt;
        }

        long getLastDeliveryStartTime() {
            return this.lastDeliveryStartTime;
        }

        long getLastDeliveryEndTime() {
            return this.lastDeliveryEndTime;
        }

        boolean isStuck() {
            if (this.delivering) {
                return System.currentTimeMillis() - this.lastDeliveryStartTime > MessageManager.this.deliveryStuckTime;
            }
            return false;
        }
    }

    public static interface Channel {
        public void deliverNow(GenericMessage var1, AID var2) throws UnreachableException, NotFoundException;

        public void notifyFailureToSender(GenericMessage var1, AID var2, InternalError var3);
    }
}

