/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MomMessagingService;
import java.util.HashMap;
import java.util.Map;

class LocalJVMMessageRouter {
    private static Map<String, LocalJVMMessageRouter> localRouters = new HashMap<String, LocalJVMMessageRouter>();
    private Map<String, MomMessagingService> localServices = new HashMap<String, MomMessagingService>();

    LocalJVMMessageRouter() {
    }

    static synchronized LocalJVMMessageRouter getRouter(String platformID) {
        LocalJVMMessageRouter router = localRouters.get(platformID);
        if (router == null) {
            router = new LocalJVMMessageRouter();
            localRouters.put(platformID, router);
        }
        return router;
    }

    public void register(String location, MomMessagingService mms) {
        this.localServices.put(location, mms);
    }

    public void deregister(String location) {
        this.localServices.remove(location);
    }

    public boolean localSendMessage(String deliveryID, AID senderID, GenericMessage msg, AID receiverID, String receiverLocation, MomMessagingService senderService) {
        MomMessagingService svc = this.localServices.get(receiverLocation);
        if (svc != null) {
            Object ret = svc.processIncomingMessage(senderID, msg, receiverID);
            senderService.handleDeliveryResult(deliveryID, (Throwable)ret);
            return true;
        }
        return false;
    }
}

