/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.Filter;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessagingService;
import jade.core.messaging.MultipleGenericMessage;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.util.leap.Iterator;
import jade.util.leap.Map;

public class IncomingEncodingFilter
extends Filter {
    private Map messageEncodings;
    private MessagingService myService;

    public IncomingEncodingFilter(Map m, MessagingService svc) {
        this.messageEncodings = m;
        this.myService = svc;
        this.setPreferredPosition(50);
    }

    @Override
    public boolean accept(VerticalCommand cmd) {
        String name = cmd.getName();
        if (name.equals("Send-Message")) {
            Object[] params = cmd.getParams();
            GenericMessage gmsg = (GenericMessage)params[1];
            try {
                this.restore(gmsg);
            }
            catch (Exception e) {
                e.printStackTrace();
                cmd.setReturnValue(e);
                return false;
            }
        } else if (name.equals("Inform-Killed")) {
            Object[] params = cmd.getParams();
            this.myService.removeGlobalAliases((AID)params[0]);
            this.myService.replicationHandle.invokeReplicatedMethod("removeGlobalAliases", params);
        }
        return true;
    }

    private void restore(GenericMessage gmsg) throws MessagingService.UnknownACLEncodingException, ACLCodec.CodecException {
        if (gmsg instanceof MultipleGenericMessage) {
            for (GenericMessage g : ((MultipleGenericMessage)gmsg).getMessages()) {
                this.restore(g);
            }
            return;
        }
        byte[] payload = gmsg.getPayload();
        if (payload == null) {
            return;
        }
        Envelope env = gmsg.getEnvelope();
        ACLMessage msg = this.decodeMessage(env, payload);
        msg.setEnvelope(env);
        if (env != null) {
            AID sender = msg.getSender();
            if (sender == null) {
                throw new IllegalArgumentException("Trying to dispatch a message with a null sender.");
            }
            Iterator itSender = sender.getAllAddresses();
            if (!itSender.hasNext()) {
                msg.setSender(env.getFrom());
            }
        }
        gmsg.update(msg, null, null);
    }

    @Override
    public void postProcess(VerticalCommand cmd) {
        String name = cmd.getName();
        if (name.equals("Reattached")) {
            this.myService.notifyLocalMTPs();
            this.myService.notifyLocalAliases();
        }
    }

    public ACLMessage decodeMessage(Envelope env, byte[] payload) throws MessagingService.UnknownACLEncodingException, ACLCodec.CodecException {
        String enc = env != null ? env.getAclRepresentation() : "leap.acl.rep";
        if (enc != null) {
            ACLCodec codec = (ACLCodec)this.messageEncodings.get(enc.toLowerCase());
            if (codec != null) {
                String charset;
                if (env == null || (charset = env.getPayloadEncoding()) == null) {
                    charset = "US-ASCII";
                }
                return codec.decode(payload, charset);
            }
            throw new MessagingService.UnknownACLEncodingException("Unknown ACL encoding: " + enc + ".");
        }
        throw new MessagingService.UnknownACLEncodingException("No ACL encoding set.");
    }
}

