/*
 * Decompiled with CFR 0.152.
 */
package jade.core.management;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentState;
import jade.core.BackEndContainer;
import jade.core.BaseService;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.NameClashException;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.Sink;
import jade.core.UnreachableException;
import jade.core.VerticalCommand;
import jade.core.management.AgentManagementSlice;
import jade.security.Credentials;
import jade.security.JADEPrincipal;
import jade.security.JADESecurityException;
import jade.util.leap.HashMap;
import jade.util.leap.Map;

public class BEAgentManagementService
extends BaseService {
    static final String NAME = "jade.core.management.AgentManagement";
    private static final String[] OWNED_COMMANDS = new String[]{"Request-Create", "Request-Kill", "Request-State-Change", "Inform-Created", "Inform-Killed", "Inform-State-Changed", "Kill-Container"};
    private BackEndContainer myContainer;
    private final ServiceComponent localSlice = new ServiceComponent();
    private final CommandSourceSink senderSink = new CommandSourceSink();
    private final CommandTargetSink receiverSink = new CommandTargetSink();
    private Map pendingImages = new HashMap(1);

    @Override
    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = (BackEndContainer)ac;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class getHorizontalInterface() {
        try {
            return Class.forName("jade.core.management.AgentManagementSlice");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    @Override
    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    @Override
    public Filter getCommandFilter(boolean direction) {
        return null;
    }

    @Override
    public Sink getCommandSink(boolean side) {
        if (!side) {
            return this.senderSink;
        }
        return this.receiverSink;
    }

    @Override
    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        @Override
        public Service getService() {
            return BEAgentManagementService.this;
        }

        @Override
        public Node getNode() throws ServiceException {
            try {
                return BEAgentManagementService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
            }
        }

        @Override
        public VerticalCommand serve(HorizontalCommand cmd) {
            GenericCommand result = null;
            try {
                String cmdName = cmd.getName();
                Object[] params = cmd.getParams();
                if (cmdName.equals("1")) {
                    GenericCommand gCmd = new GenericCommand("Request-Create", BEAgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    String className = (String)params[1];
                    Object[] arguments = (Object[])params[2];
                    String ownership = (String)params[3];
                    Credentials certs = (Credentials)params[4];
                    gCmd.addParam(agentID);
                    gCmd.addParam(className);
                    gCmd.addParam(arguments);
                    gCmd.addParam(ownership);
                    gCmd.addParam(certs);
                    result = gCmd;
                } else if (cmdName.equals("2")) {
                    GenericCommand gCmd = new GenericCommand("Request-Kill", BEAgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    gCmd.addParam(agentID);
                    result = gCmd;
                } else if (cmdName.equals("3")) {
                    GenericCommand gCmd = new GenericCommand("Request-State-Change", BEAgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    Integer newState = (Integer)params[1];
                    gCmd.addParam(agentID);
                    gCmd.addParam(newState);
                    result = gCmd;
                } else if (cmdName.equals("4")) {
                    GenericCommand gCmd = new GenericCommand("Inform-Created", BEAgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    ContainerID cid = (ContainerID)params[1];
                    String ownership = (String)params[2];
                    gCmd.addParam(agentID);
                    gCmd.addParam(cid);
                    gCmd.addParam(ownership);
                    result = gCmd;
                } else if (cmdName.equals("5")) {
                    GenericCommand gCmd = new GenericCommand("Inform-Killed", BEAgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    gCmd.addParam(agentID);
                    result = gCmd;
                } else if (cmdName.equals("6")) {
                    GenericCommand gCmd = new GenericCommand("Inform-State-Changed", BEAgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    gCmd.addParam(agentID);
                    gCmd.addParam("suspended");
                    result = gCmd;
                } else if (cmdName.equals("7")) {
                    GenericCommand gCmd = new GenericCommand("Inform-State-Changed", BEAgentManagementService.NAME, null);
                    AID agentID = (AID)params[0];
                    gCmd.addParam(agentID);
                    gCmd.addParam("active");
                    result = gCmd;
                } else if (cmdName.equals("8")) {
                    GenericCommand gCmd;
                    result = gCmd = new GenericCommand("Kill-Container", BEAgentManagementService.NAME, null);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return result;
        }
    }

    private class CommandTargetSink
    implements Sink {
        private CommandTargetSink() {
        }

        @Override
        public void consume(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Request-Create")) {
                    this.handleRequestCreate(cmd);
                } else if (name.equals("Request-Kill")) {
                    this.handleRequestKill(cmd);
                } else if (name.equals("Request-State-Change")) {
                    this.handleRequestStateChange(cmd);
                } else if (name.equals("Inform-State-Changed")) {
                    this.handleInformStateChanged(cmd);
                } else if (name.equals("Kill-Container")) {
                    this.handleKillContainer(cmd);
                }
            }
            catch (IMTPException imtpe) {
                cmd.setReturnValue(new UnreachableException("Remote container is unreachable", imtpe));
            }
            catch (NotFoundException nfe) {
                cmd.setReturnValue(nfe);
            }
            catch (NameClashException nce) {
                cmd.setReturnValue(nce);
            }
            catch (JADESecurityException ae) {
                cmd.setReturnValue(ae);
            }
            catch (ServiceException se) {
                cmd.setReturnValue(new UnreachableException("A Service Exception occurred", se));
            }
        }

        private void handleRequestCreate(VerticalCommand cmd) throws IMTPException, JADESecurityException, NotFoundException, NameClashException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            String className = (String)params[1];
            Object[] args = (Object[])params[2];
            JADEPrincipal owner = (JADEPrincipal)params[3];
            Credentials initialCredentials = (Credentials)params[4];
            this.createAgent(agentID, className, args, owner, initialCredentials);
        }

        private void handleRequestKill(VerticalCommand cmd) throws IMTPException, JADESecurityException, NotFoundException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            this.killAgent(agentID);
        }

        private void handleRequestStateChange(VerticalCommand cmd) throws IMTPException, JADESecurityException, NotFoundException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            int newState = (Integer)params[1];
            this.changeAgentState(agentID, newState);
        }

        private void handleInformStateChanged(VerticalCommand cmd) throws NotFoundException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            String newState = (String)params[1];
            if (newState.equals("suspended")) {
                this.suspendedAgent(agentID);
            } else if (newState.equals("active")) {
                this.resumedAgent(agentID);
            }
        }

        private void handleKillContainer(VerticalCommand cmd) {
            BEAgentManagementService.this.myContainer.shutDown();
        }

        private void createAgent(AID agentID, String className, Object[] args, JADEPrincipal ownership, Credentials creds) throws IMTPException {
            BackEndContainer.AgentImage image = BEAgentManagementService.this.myContainer.createAgentImage(agentID);
            BackEndContainer.AgentImage previous = (BackEndContainer.AgentImage)BEAgentManagementService.this.pendingImages.put(agentID, image);
            try {
                String[] sargs = null;
                if (args != null) {
                    sargs = new String[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        sargs[i] = (String)args[i];
                    }
                }
                BEAgentManagementService.this.myContainer.createAgentOnFE(agentID.getLocalName(), className, sargs);
            }
            catch (IMTPException imtpe) {
                BEAgentManagementService.this.pendingImages.remove(agentID);
                if (previous != null) {
                    BEAgentManagementService.this.pendingImages.put(agentID, previous);
                }
                throw imtpe;
            }
            catch (ClassCastException cce) {
                BEAgentManagementService.this.pendingImages.remove(agentID);
                if (previous != null) {
                    BEAgentManagementService.this.pendingImages.put(agentID, previous);
                }
                throw new IMTPException("Non-String argument");
            }
        }

        private void killAgent(AID agentID) throws IMTPException, NotFoundException {
            if (BEAgentManagementService.this.myContainer.getAgentImage(agentID) == null) {
                throw new NotFoundException("KillAgent failed to find " + agentID);
            }
            String name = agentID.getLocalName();
            BEAgentManagementService.this.myContainer.killAgentOnFE(name);
        }

        private void changeAgentState(AID agentID, int newState) throws IMTPException, NotFoundException {
            BackEndContainer.AgentImage a = BEAgentManagementService.this.myContainer.getAgentImage(agentID);
            if (a == null) {
                throw new NotFoundException("Change-Agent-State failed to find " + agentID);
            }
            if (newState == 4) {
                BEAgentManagementService.this.myContainer.suspendAgentOnFE(agentID.getLocalName());
            } else if (newState == 2) {
                BEAgentManagementService.this.myContainer.resumeAgentOnFE(agentID.getLocalName());
            }
        }

        private void suspendedAgent(AID name) throws NotFoundException {
        }

        private void resumedAgent(AID name) throws NotFoundException {
        }
    }

    private class CommandSourceSink
    implements Sink {
        private CommandSourceSink() {
        }

        @Override
        public void consume(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Inform-Killed")) {
                    this.handleInformKilled(cmd);
                } else if (name.equals("Inform-State-Changed")) {
                    this.handleInformStateChanged(cmd);
                } else if (name.equals("Inform-Created")) {
                    this.handleInformCreated(cmd);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
        }

        private void handleInformCreated(VerticalCommand cmd) throws IMTPException, NotFoundException, NameClashException, JADESecurityException, ServiceException {
            Object[] params = cmd.getParams();
            AID agentID = (AID)params[0];
            boolean startedOnBE = false;
            Agent previous = null;
            if (params.length > 1 && params[1] instanceof Agent) {
                Agent instance = (Agent)params[1];
                if (!(instance instanceof BackEndContainer.AgentImage)) {
                    previous = BEAgentManagementService.this.myContainer.addLocalAgent(agentID, instance);
                    startedOnBE = true;
                }
            } else {
                BackEndContainer.AgentImage image = (BackEndContainer.AgentImage)BEAgentManagementService.this.pendingImages.remove(agentID);
                if (image == null) {
                    image = BEAgentManagementService.this.myContainer.createAgentImage(agentID);
                }
                previous = BEAgentManagementService.this.myContainer.addAgentImage(agentID, image);
            }
            try {
                ContainerID cid = BEAgentManagementService.this.myContainer.getID();
                AgentManagementSlice mainSlice = (AgentManagementSlice)BEAgentManagementService.this.getSlice("$$$Main-Slice$$$");
                try {
                    mainSlice.bornAgent(agentID, cid, cmd);
                }
                catch (IMTPException imtpe) {
                    mainSlice = (AgentManagementSlice)BEAgentManagementService.this.getFreshSlice("$$$Main-Slice$$$");
                    mainSlice.bornAgent(agentID, cid, cmd);
                }
            }
            catch (IMTPException imtpe) {
                this.rollBack(agentID, previous, startedOnBE);
                throw imtpe;
            }
            catch (NotFoundException nfe) {
                this.rollBack(agentID, previous, startedOnBE);
                throw nfe;
            }
            catch (NameClashException nce) {
                this.rollBack(agentID, previous, startedOnBE);
                throw nce;
            }
            catch (JADESecurityException jse) {
                this.rollBack(agentID, previous, startedOnBE);
                throw jse;
            }
            catch (ServiceException se) {
                this.rollBack(agentID, previous, startedOnBE);
                throw se;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.rollBack(agentID, previous, startedOnBE);
                throw new IMTPException("Error creating agent " + agentID.getLocalName() + ". ", e);
            }
        }

        private void rollBack(AID agentID, Agent previous, boolean startedOnBE) {
            if (startedOnBE) {
                BEAgentManagementService.this.myContainer.removeLocalAgent(agentID);
                if (previous != null) {
                    BEAgentManagementService.this.myContainer.addLocalAgent(agentID, previous);
                }
            } else {
                BEAgentManagementService.this.myContainer.removeAgentImage(agentID);
                if (previous != null) {
                    BEAgentManagementService.this.myContainer.addAgentImage(agentID, (BackEndContainer.AgentImage)previous);
                }
            }
        }

        private void handleInformKilled(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException {
            Object[] params = cmd.getParams();
            AID target = (AID)params[0];
            AgentManagementSlice mainSlice = (AgentManagementSlice)BEAgentManagementService.this.getSlice("$$$Main-Slice$$$");
            try {
                mainSlice.deadAgent(target, cmd);
            }
            catch (IMTPException imtpe) {
                mainSlice = (AgentManagementSlice)BEAgentManagementService.this.getFreshSlice("$$$Main-Slice$$$");
                mainSlice.deadAgent(target, cmd);
            }
            BackEndContainer.AgentImage image = BEAgentManagementService.this.myContainer.removeAgentImage(target);
        }

        private void handleInformStateChanged(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID target = (AID)params[0];
            AgentState from = (AgentState)params[1];
            AgentState to = (AgentState)params[2];
            if (to.equals("suspended")) {
                try {
                    AgentManagementSlice mainSlice = (AgentManagementSlice)BEAgentManagementService.this.getSlice("$$$Main-Slice$$$");
                    try {
                        mainSlice.suspendedAgent(target);
                    }
                    catch (IMTPException imtpe) {
                        mainSlice = (AgentManagementSlice)BEAgentManagementService.this.getFreshSlice("$$$Main-Slice$$$");
                        mainSlice.suspendedAgent(target);
                    }
                }
                catch (IMTPException re) {
                    re.printStackTrace();
                }
                catch (NotFoundException nfe) {
                    nfe.printStackTrace();
                }
                catch (ServiceException se) {
                    se.printStackTrace();
                }
            } else if (from.equals("suspended")) {
                try {
                    AgentManagementSlice mainSlice = (AgentManagementSlice)BEAgentManagementService.this.getSlice("$$$Main-Slice$$$");
                    try {
                        mainSlice.resumedAgent(target);
                    }
                    catch (IMTPException imtpe) {
                        mainSlice = (AgentManagementSlice)BEAgentManagementService.this.getFreshSlice("$$$Main-Slice$$$");
                        mainSlice.resumedAgent(target);
                    }
                }
                catch (IMTPException re) {
                    re.printStackTrace();
                }
                catch (NotFoundException nfe) {
                    nfe.printStackTrace();
                }
                catch (ServiceException se) {
                    se.printStackTrace();
                }
            }
        }
    }
}

