/*
 * Decompiled with CFR 0.152.
 */
package jade.core.event;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainer;
import jade.core.AgentState;
import jade.core.BaseService;
import jade.core.BehaviourID;
import jade.core.Channel;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.MainContainer;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.ServiceHelper;
import jade.core.Sink;
import jade.core.VerticalCommand;
import jade.core.behaviours.Behaviour;
import jade.core.event.AgentEvent;
import jade.core.event.AgentListener;
import jade.core.event.ContainerEvent;
import jade.core.event.ContainerListener;
import jade.core.event.MessageEvent;
import jade.core.event.MessageListener;
import jade.core.event.NotificationHelper;
import jade.core.event.NotificationSlice;
import jade.core.messaging.GenericMessage;
import jade.lang.acl.ACLMessage;
import jade.security.JADEPrincipal;
import jade.tools.ToolNotifier;
import jade.util.SynchList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Map;

public class NotificationService
extends BaseService {
    public static final String NAME = "jade.core.event.Notification";
    private static final String[] OWNED_COMMANDS = new String[]{"Sniff-On", "Sniff-Off", "Debug-On", "Debug-Off", "Notify-Posted", "Notify-Received", "Notify-Changed-Agent-State", "Notify-Changed-Agent-Principal", "Notify-BehaviourAdded", "Notify-Behaviour-Removed", "Notify-Changed-Behaviour-State"};
    private static final String AMS_DEBUG_HELPER = "AMS-debug-helper";
    private AgentContainer myContainer;
    private ServiceComponent localSlice;
    private Sink sourceSink = new NotificationSourceSink();
    private Filter outgoingFilter = new NotificationOutgoingFilter();
    private Filter incomingFilter = new NotificationIncomingFilter();
    private NotificationHelper helper = new NotificationHelperImpl();
    private SynchList messageListeners = new SynchList();
    private SynchList agentListeners = new SynchList();
    private SynchList containerListeners = new SynchList();
    private Map debuggers = new HashMap();

    @Override
    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myContainer = ac;
        this.localSlice = new ServiceComponent();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class getHorizontalInterface() {
        return NotificationSlice.class;
    }

    @Override
    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    @Override
    public Filter getCommandFilter(boolean direction) {
        if (direction) {
            return this.outgoingFilter;
        }
        return this.incomingFilter;
    }

    @Override
    public Sink getCommandSink(boolean side) {
        if (!side) {
            return this.sourceSink;
        }
        return null;
    }

    @Override
    public ServiceHelper getHelper(Agent a) throws ServiceException {
        return this.helper;
    }

    @Override
    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    private void fireSentMessage(ACLMessage msg, AID sender, AID receiver) {
        List l = this.messageListeners.startScanning();
        if (l != null) {
            MessageEvent ev = new MessageEvent(1, msg, sender, receiver, this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                MessageListener ml = (MessageListener)it.next();
                ml.sentMessage(ev);
            }
            this.messageListeners.stopScanning();
        }
    }

    private void firePostedMessage(ACLMessage msg, AID receiver) {
        List l;
        String realSenderName = msg.getUserDefinedParameter("JADE-real-sender");
        AID sender = null;
        if (realSenderName != null) {
            sender = new AID(realSenderName, true);
        }
        if ((l = this.messageListeners.startScanning()) != null) {
            MessageEvent ev = new MessageEvent(2, msg, sender, receiver, this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                MessageListener ml = (MessageListener)it.next();
                ml.postedMessage(ev);
            }
            this.messageListeners.stopScanning();
        }
    }

    private void fireReceivedMessage(ACLMessage msg, AID receiver) {
        List l;
        String realSenderName = msg.getUserDefinedParameter("JADE-real-sender");
        AID sender = null;
        if (realSenderName != null) {
            sender = new AID(realSenderName, true);
        }
        if ((l = this.messageListeners.startScanning()) != null) {
            MessageEvent ev = new MessageEvent(3, msg, sender, receiver, this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                MessageListener ml = (MessageListener)it.next();
                ml.receivedMessage(ev);
            }
            this.messageListeners.stopScanning();
        }
    }

    private void fireRoutedMessage(ACLMessage msg, Channel from, Channel to) {
        List l = this.messageListeners.startScanning();
        if (l != null) {
            MessageEvent ev = new MessageEvent(4, msg, from, to, this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                MessageListener ml = (MessageListener)it.next();
                ml.routedMessage(ev);
            }
            this.messageListeners.stopScanning();
        }
    }

    private void fireAddedBehaviour(AID agentID, Behaviour b) {
        List l = this.agentListeners.startScanning();
        if (l != null) {
            AgentEvent ev = null;
            if (b == b.root()) {
                ev = new AgentEvent(2, agentID, new BehaviourID(b), this.myID());
            }
            Iterator it = l.iterator();
            while (it.hasNext()) {
                AgentListener al = (AgentListener)it.next();
                al.addedBehaviour(ev);
            }
            this.agentListeners.stopScanning();
        }
    }

    private void fireRemovedBehaviour(AID agentID, Behaviour b) {
        List l = this.agentListeners.startScanning();
        if (l != null) {
            AgentEvent ev = new AgentEvent(3, agentID, new BehaviourID(b), this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                AgentListener al = (AgentListener)it.next();
                al.removedBehaviour(ev);
            }
            this.agentListeners.stopScanning();
        }
    }

    private void fireChangedBehaviourState(AID agentID, Behaviour b, String from, String to) {
        List l = this.agentListeners.startScanning();
        if (l != null) {
            AgentEvent ev = new AgentEvent(4, agentID, new BehaviourID(b), from, to, this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                AgentListener al = (AgentListener)it.next();
                al.changedBehaviourState(ev);
            }
            this.agentListeners.stopScanning();
        }
    }

    private void fireChangedAgentPrincipal(AID agentID, JADEPrincipal from, JADEPrincipal to) {
        List l = this.agentListeners.startScanning();
        if (l != null) {
            AgentEvent ev = new AgentEvent(5, agentID, from, to, this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                AgentListener al = (AgentListener)it.next();
                al.changedAgentPrincipal(ev);
            }
            this.agentListeners.stopScanning();
        }
    }

    private void fireChangedAgentState(AID agentID, AgentState from, AgentState to) {
        List l = this.agentListeners.startScanning();
        if (l != null) {
            AgentEvent ev = new AgentEvent(1, agentID, from, to, this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                AgentListener al = (AgentListener)it.next();
                al.changedAgentState(ev);
            }
            this.agentListeners.stopScanning();
        }
    }

    private void fireBornAgent(AID agentID) {
        List l = this.containerListeners.startScanning();
        if (l != null) {
            ContainerEvent ev = new ContainerEvent(1, agentID, this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ContainerListener cl = (ContainerListener)it.next();
                cl.bornAgent(ev);
            }
            this.containerListeners.stopScanning();
        }
    }

    private void fireDeadAgent(AID agentID) {
        List l = this.containerListeners.startScanning();
        if (l != null) {
            ContainerEvent ev = new ContainerEvent(2, agentID, this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ContainerListener cl = (ContainerListener)it.next();
                cl.deadAgent(ev);
            }
            this.containerListeners.stopScanning();
        }
    }

    private void fireReattached() {
        List l = this.containerListeners.startScanning();
        if (l != null) {
            ContainerEvent ev = new ContainerEvent(3, null, this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ContainerListener cl = (ContainerListener)it.next();
                cl.reattached(ev);
            }
            this.containerListeners.stopScanning();
        }
    }

    private void fireReconnected() {
        List l = this.containerListeners.startScanning();
        if (l != null) {
            ContainerEvent ev = new ContainerEvent(4, null, this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ContainerListener cl = (ContainerListener)it.next();
                cl.reconnected(ev);
            }
            this.containerListeners.stopScanning();
        }
    }

    private void fireLeadershipAcquired() {
        List l = this.containerListeners.startScanning();
        if (l != null) {
            ContainerEvent ev = new ContainerEvent(5, null, this.myID());
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ContainerListener cl = (ContainerListener)it.next();
                cl.leadershipAcquired(ev);
            }
            this.containerListeners.stopScanning();
        }
    }

    private ToolNotifier findNotifier(AID observerName) {
        Agent tn = null;
        List l = this.messageListeners.startScanning();
        if (l != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ToolNotifier tni;
                AID id;
                Object obj = it.next();
                if (!(obj instanceof ToolNotifier) || !(id = (tni = (ToolNotifier)obj).getObserver()).equals(observerName)) continue;
                tn = tni;
                break;
            }
            this.messageListeners.stopScanning();
        }
        if (tn != null && tn.getState() == 6) {
            this.helper.deregisterMessageListener((MessageListener)((Object)tn));
            this.helper.deregisterAgentListener((AgentListener)((Object)tn));
            tn = null;
        }
        return tn;
    }

    private ContainerID myID() {
        return (ContainerID)this.myContainer.here();
    }

    private class NotificationHelperImpl
    implements NotificationHelper {
        private NotificationHelperImpl() {
        }

        @Override
        public void init(Agent a) {
        }

        @Override
        public void registerMessageListener(MessageListener ml) {
            List l = NotificationService.this.messageListeners.startModifying();
            l.add(ml);
            NotificationService.this.messageListeners.stopModifying();
        }

        @Override
        public void deregisterMessageListener(MessageListener ml) {
            List l = NotificationService.this.messageListeners.startModifying();
            l.remove(ml);
            NotificationService.this.messageListeners.stopModifying();
        }

        @Override
        public void registerAgentListener(AgentListener al) {
            List l = NotificationService.this.agentListeners.startModifying();
            l.add(al);
            NotificationService.this.agentListeners.stopModifying();
        }

        @Override
        public void deregisterAgentListener(AgentListener al) {
            List l = NotificationService.this.agentListeners.startModifying();
            l.remove(al);
            NotificationService.this.agentListeners.stopModifying();
        }

        @Override
        public void registerContainerListener(ContainerListener cl) {
            List l = NotificationService.this.containerListeners.startModifying();
            l.add(cl);
            NotificationService.this.containerListeners.stopModifying();
        }

        @Override
        public void deregisterContainerListener(ContainerListener cl) {
            List l = NotificationService.this.containerListeners.startModifying();
            l.remove(cl);
            NotificationService.this.containerListeners.stopModifying();
        }
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        @Override
        public Service getService() {
            return NotificationService.this;
        }

        @Override
        public Node getNode() throws ServiceException {
            try {
                return NotificationService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
            }
        }

        @Override
        public VerticalCommand serve(HorizontalCommand cmd) {
            try {
                String cmdName = cmd.getName();
                Object[] params = cmd.getParams();
                if (cmdName.equals("1")) {
                    AID snifferName = (AID)params[0];
                    AID targetName = (AID)params[1];
                    this.sniffOn(snifferName, targetName);
                } else if (cmdName.equals("2")) {
                    AID snifferName = (AID)params[0];
                    AID targetName = (AID)params[1];
                    this.sniffOff(snifferName, targetName);
                } else if (cmdName.equals("3")) {
                    AID introspectorName = (AID)params[0];
                    AID targetName = (AID)params[1];
                    this.debugOn(introspectorName, targetName);
                } else if (cmdName.equals("4")) {
                    AID introspectorName = (AID)params[0];
                    AID targetName = (AID)params[1];
                    this.debugOff(introspectorName, targetName);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return null;
        }

        private void sniffOn(AID snifferName, AID targetName) throws IMTPException {
            ToolNotifier tn = NotificationService.this.findNotifier(snifferName);
            if (tn == null) {
                tn = new ToolNotifier(snifferName);
                try {
                    String platformID = NotificationService.this.myContainer.getPlatformID();
                    AID id = new AID(AID.createGUID(snifferName.getLocalName() + "-on-" + NotificationService.this.myID().getName(), NotificationService.this.myContainer.getPlatformID()), true);
                    NotificationService.this.myContainer.initAgent(id, tn, null, null);
                    NotificationService.this.myContainer.powerUpLocalAgent(id);
                    NotificationService.this.helper.registerMessageListener(tn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            tn.addObservedAgent(targetName);
        }

        private void sniffOff(AID snifferName, AID targetName) throws IMTPException {
            ToolNotifier tn = NotificationService.this.findNotifier(snifferName);
            if (tn != null) {
                tn.removeObservedAgent(targetName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void debugOn(AID introspectorName, AID targetName) throws IMTPException {
            Object id;
            if (targetName.equals(NotificationService.this.myContainer.getAMS()) && !Thread.currentThread().getName().equals(NotificationService.AMS_DEBUG_HELPER)) {
                final AID in = introspectorName;
                final AID tg = targetName;
                Thread helper = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ServiceComponent.this.debugOn(in, tg);
                        }
                        catch (IMTPException imtpe) {
                            imtpe.printStackTrace();
                        }
                    }
                });
                helper.setName(NotificationService.AMS_DEBUG_HELPER);
                helper.start();
                return;
            }
            ToolNotifier tn = NotificationService.this.findNotifier(introspectorName);
            if (tn == null) {
                tn = new ToolNotifier(introspectorName);
                id = new AID(AID.createGUID(introspectorName.getLocalName() + "-on-" + NotificationService.this.myID().getName(), NotificationService.this.myContainer.getPlatformID()), true);
                try {
                    NotificationService.this.myContainer.initAgent((AID)id, tn, null, null);
                    NotificationService.this.myContainer.powerUpLocalAgent((AID)id);
                    if (targetName.equals(NotificationService.this.myContainer.getAMS())) {
                        tn.waitUntilStarted();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception helper) {
                        // empty catch block
                    }
                    NotificationService.this.helper.registerMessageListener(tn);
                    NotificationService.this.helper.registerAgentListener(tn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            tn.addObservedAgent(targetName);
            id = NotificationService.this.debuggers;
            synchronized (id) {
                List l = (List)NotificationService.this.debuggers.get(targetName);
                if (l == null) {
                    l = new LinkedList();
                    NotificationService.this.debuggers.put(targetName, l);
                }
                if (!l.contains(introspectorName)) {
                    l.add(introspectorName);
                }
            }
            Agent a = NotificationService.this.myContainer.acquireLocalAgent(targetName);
            a.setGenerateBehaviourEvents(true);
            AgentState as = a.getAgentState();
            LinkedList messages = new LinkedList();
            NotificationService.this.myContainer.fillListFromMessageQueue(messages, a);
            LinkedList readyBehaviours = new LinkedList();
            NotificationService.this.myContainer.fillListFromReadyBehaviours(readyBehaviours, a);
            LinkedList blockedBehaviours = new LinkedList();
            NotificationService.this.myContainer.fillListFromBlockedBehaviours(blockedBehaviours, a);
            NotificationService.this.myContainer.releaseLocalAgent(targetName);
            NotificationService.this.fireChangedAgentState(targetName, as, as);
            Iterator itReady = readyBehaviours.iterator();
            while (itReady.hasNext()) {
                BehaviourID bid = (BehaviourID)itReady.next();
                AgentEvent ev = new AgentEvent(2, targetName, bid, NotificationService.this.myContainer.getID());
                tn.addedBehaviour(ev);
            }
            Iterator itBlocked = blockedBehaviours.iterator();
            while (itBlocked.hasNext()) {
                BehaviourID bid = (BehaviourID)itBlocked.next();
                AgentEvent ev = new AgentEvent(2, targetName, bid, NotificationService.this.myContainer.getID());
                tn.addedBehaviour(ev);
                ev = new AgentEvent(4, targetName, bid, "READY", "BLOCKED", NotificationService.this.myContainer.getID());
                tn.changedBehaviourState(ev);
            }
            Iterator itMessages = messages.iterator();
            while (itMessages.hasNext()) {
                ACLMessage msg = (ACLMessage)itMessages.next();
                MessageEvent ev = new MessageEvent(2, msg, null, targetName, NotificationService.this.myContainer.getID());
                tn.postedMessage(ev);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void debugOff(AID introspectorName, AID targetName) throws IMTPException {
            ToolNotifier tn = NotificationService.this.findNotifier(introspectorName);
            if (tn != null) {
                tn.removeObservedAgent(targetName);
            }
            boolean resetGenerateBehaviourEvents = true;
            Map map = NotificationService.this.debuggers;
            synchronized (map) {
                List l = (List)NotificationService.this.debuggers.get(targetName);
                if (l != null) {
                    l.remove(introspectorName);
                    if (l.size() > 0) {
                        resetGenerateBehaviourEvents = false;
                    } else {
                        NotificationService.this.debuggers.remove(targetName);
                    }
                }
            }
            if (resetGenerateBehaviourEvents) {
                Agent a = NotificationService.this.myContainer.acquireLocalAgent(targetName);
                if (a != null) {
                    a.setGenerateBehaviourEvents(false);
                }
                NotificationService.this.myContainer.releaseLocalAgent(targetName);
            }
        }
    }

    private class NotificationIncomingFilter
    extends Filter {
        private NotificationIncomingFilter() {
        }

        @Override
        public void postProcess(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Reattached")) {
                    this.handleReattached(cmd);
                } else if (name.equals("Reconnected")) {
                    this.handleReconnected(cmd);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
        }

        private void handleReattached(VerticalCommand cmd) {
            NotificationService.this.fireReattached();
        }

        private void handleReconnected(VerticalCommand cmd) {
            NotificationService.this.fireReconnected();
        }
    }

    private class NotificationOutgoingFilter
    extends Filter {
        private NotificationOutgoingFilter() {
        }

        @Override
        public boolean accept(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Send-Message")) {
                    this.handleSendMessage(cmd);
                } else if (name.equals("Inform-Created")) {
                    this.handleInformCreated(cmd);
                } else if (name.equals("Inform-Killed")) {
                    this.handleInformKilled(cmd);
                } else if (name.equals("Inform-State-Changed")) {
                    this.handleInformStateChanged(cmd);
                } else if (name.equals("Leadership-Acquired")) {
                    this.handleLeadershipAcquired(cmd);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return true;
        }

        private void handleSendMessage(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID sender = (AID)params[0];
            ACLMessage msg = ((GenericMessage)params[1]).getACLMessage();
            AID receiver = (AID)params[2];
            NotificationService.this.fireSentMessage(msg, sender, receiver);
        }

        private void handleInformCreated(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID agent = (AID)params[0];
            NotificationService.this.fireBornAgent(agent);
        }

        private void handleInformKilled(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID agent = (AID)params[0];
            NotificationService.this.fireDeadAgent(agent);
        }

        private void handleInformStateChanged(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID id = (AID)params[0];
            AgentState from = (AgentState)params[1];
            AgentState to = (AgentState)params[2];
            NotificationService.this.fireChangedAgentState(id, from, to);
        }

        private void handleLeadershipAcquired(VerticalCommand cmd) {
            NotificationService.this.fireLeadershipAcquired();
        }
    }

    private class NotificationSourceSink
    implements Sink {
        private NotificationSourceSink() {
        }

        @Override
        public void consume(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Sniff-On")) {
                    this.handleSniffOn(cmd);
                }
                if (name.equals("Sniff-Off")) {
                    this.handleSniffOff(cmd);
                } else if (name.equals("Debug-On")) {
                    this.handleDebugOn(cmd);
                } else if (name.equals("Debug-Off")) {
                    this.handleDebugOff(cmd);
                } else if (name.equals("Notify-Posted")) {
                    this.handleNotifyPosted(cmd);
                } else if (name.equals("Notify-Received")) {
                    this.handleNotifyReceived(cmd);
                } else if (name.equals("Notify-Changed-Agent-Principal")) {
                    this.handleNotifyChangedAgentPrincipal(cmd);
                } else if (name.equals("Notify-BehaviourAdded")) {
                    this.handleNotifyAddedBehaviour(cmd);
                } else if (name.equals("Notify-Behaviour-Removed")) {
                    this.handleNotifyRemovedBehaviour(cmd);
                } else if (name.equals("Notify-Changed-Behaviour-State")) {
                    this.handleNotifyChangedBehaviourState(cmd);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
        }

        private void handleSniffOn(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException {
            Object[] params = cmd.getParams();
            AID sniffer = (AID)params[0];
            List targets = (List)params[1];
            MainContainer impl = NotificationService.this.myContainer.getMain();
            if (impl != null) {
                Iterator it = targets.iterator();
                while (it.hasNext()) {
                    AID target = (AID)it.next();
                    ContainerID cid = impl.getContainerID(target);
                    NotificationSlice slice = (NotificationSlice)NotificationService.this.getSlice(cid.getName());
                    try {
                        slice.sniffOn(sniffer, target);
                    }
                    catch (IMTPException imtpe) {
                        slice = (NotificationSlice)NotificationService.this.getFreshSlice(cid.getName());
                        slice.sniffOn(sniffer, target);
                    }
                }
            }
        }

        private void handleSniffOff(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException {
            Object[] params = cmd.getParams();
            AID sniffer = (AID)params[0];
            List targets = (List)params[1];
            MainContainer impl = NotificationService.this.myContainer.getMain();
            if (impl != null) {
                Iterator it = targets.iterator();
                while (it.hasNext()) {
                    AID target = (AID)it.next();
                    ContainerID cid = impl.getContainerID(target);
                    NotificationSlice slice = (NotificationSlice)NotificationService.this.getSlice(cid.getName());
                    try {
                        slice.sniffOff(sniffer, target);
                    }
                    catch (IMTPException imtpe) {
                        slice = (NotificationSlice)NotificationService.this.getFreshSlice(cid.getName());
                        slice.sniffOff(sniffer, target);
                    }
                }
            }
        }

        private void handleDebugOn(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException {
            Object[] params = cmd.getParams();
            AID introspector = (AID)params[0];
            List targets = (List)params[1];
            MainContainer impl = NotificationService.this.myContainer.getMain();
            if (impl != null) {
                Iterator it = targets.iterator();
                while (it.hasNext()) {
                    AID target = (AID)it.next();
                    ContainerID cid = impl.getContainerID(target);
                    NotificationSlice slice = (NotificationSlice)NotificationService.this.getSlice(cid.getName());
                    try {
                        slice.debugOn(introspector, target);
                    }
                    catch (IMTPException imtpe) {
                        slice = (NotificationSlice)NotificationService.this.getFreshSlice(cid.getName());
                        slice.debugOn(introspector, target);
                    }
                }
            }
        }

        private void handleDebugOff(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException {
            Object[] params = cmd.getParams();
            AID introspector = (AID)params[0];
            List targets = (List)params[1];
            MainContainer impl = NotificationService.this.myContainer.getMain();
            if (impl != null) {
                Iterator it = targets.iterator();
                while (it.hasNext()) {
                    AID target = (AID)it.next();
                    ContainerID cid = impl.getContainerID(target);
                    NotificationSlice slice = (NotificationSlice)NotificationService.this.getSlice(cid.getName());
                    try {
                        slice.debugOff(introspector, target);
                    }
                    catch (IMTPException imtpe) {
                        slice = (NotificationSlice)NotificationService.this.getFreshSlice(cid.getName());
                        slice.debugOff(introspector, target);
                    }
                }
            }
        }

        private void handleNotifyPosted(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            ACLMessage msg = (ACLMessage)params[0];
            AID receiver = (AID)params[1];
            NotificationService.this.firePostedMessage(msg, receiver);
        }

        private void handleNotifyReceived(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            ACLMessage msg = (ACLMessage)params[0];
            AID receiver = (AID)params[1];
            NotificationService.this.fireReceivedMessage(msg, receiver);
        }

        private void handleNotifyChangedAgentPrincipal(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID id = (AID)params[0];
            JADEPrincipal from = (JADEPrincipal)params[1];
            JADEPrincipal to = (JADEPrincipal)params[2];
            NotificationService.this.fireChangedAgentPrincipal(id, from, to);
        }

        private void handleNotifyAddedBehaviour(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID id = (AID)params[0];
            Behaviour b = (Behaviour)params[1];
            NotificationService.this.fireAddedBehaviour(id, b);
        }

        private void handleNotifyRemovedBehaviour(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID id = (AID)params[0];
            Behaviour b = (Behaviour)params[1];
            NotificationService.this.fireRemovedBehaviour(id, b);
        }

        private void handleNotifyChangedBehaviourState(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID id = (AID)params[0];
            Behaviour b = (Behaviour)params[1];
            String from = (String)params[2];
            String to = (String)params[3];
            NotificationService.this.fireChangedBehaviourState(id, b, from, to);
        }
    }
}

