/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.core.Agent;
import jade.core.behaviours.SimpleBehaviour;

public abstract class TickerBehaviour
extends SimpleBehaviour {
    private long wakeupTime;
    private long period;
    private boolean finished;
    private int tickCount = 0;
    private boolean fixedPeriod = false;
    private long startTime;

    public TickerBehaviour(Agent a, long period) {
        super(a);
        if (period <= 0L) {
            throw new IllegalArgumentException("Period must be greater than 0");
        }
        this.period = period;
    }

    @Override
    public void onStart() {
        this.startTime = System.currentTimeMillis();
        this.wakeupTime = this.startTime + this.period;
    }

    @Override
    public final void action() {
        if (!this.finished) {
            long blockTime = this.wakeupTime - System.currentTimeMillis();
            if (blockTime <= 0L) {
                ++this.tickCount;
                this.onTick();
                long currentTime = System.currentTimeMillis();
                this.wakeupTime = this.fixedPeriod ? this.startTime + (long)(this.tickCount + 1) * this.period : currentTime + this.period;
                blockTime = this.wakeupTime - currentTime;
            }
            if (this.myAgent != null && !this.finished && blockTime > 0L) {
                this.block(blockTime);
            }
        }
    }

    @Override
    public final boolean done() {
        return this.finished;
    }

    protected abstract void onTick();

    public void setFixedPeriod(boolean fixedPeriod) {
        this.fixedPeriod = fixedPeriod;
    }

    public void reset(long period) {
        this.reset();
        if (period <= 0L) {
            throw new IllegalArgumentException("Period must be greater than 0");
        }
        this.period = period;
    }

    @Override
    public void reset() {
        super.reset();
        this.finished = false;
        this.tickCount = 0;
    }

    public void stop() {
        this.finished = true;
        this.restart();
    }

    public final int getTickCount() {
        return this.tickCount;
    }

    protected long getPeriod() {
        return this.period;
    }

    private void setTickCount(int tc) {
        this.tickCount = tc;
    }

    private void setPeriod(long p) {
        this.period = p;
    }

    private void setWakeupTime(long wt) {
        this.wakeupTime = wt;
    }

    private long getWakeupTime() {
        return this.wakeupTime;
    }
}

