/*
 * Decompiled with CFR 0.152.
 */
package jade.core.behaviours;

import jade.content.lang.leap.LEAPCodec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.core.AID;
import jade.core.behaviours.OutcomeManager;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.ConversationList;
import jade.proto.AchieveREInitiator;
import jade.util.Logger;
import jade.util.leap.Iterator;
import java.util.Vector;

public abstract class BaseInitiator
extends AchieveREInitiator {
    private static final long serialVersionUID = -6505544004754497428L;
    private AID target;
    private String defaultTargetDescription;
    protected OutcomeManager outcome;
    protected ConversationList conversations;
    private String convId;
    private static int conversationCnt = 0;
    protected Logger myLogger = Logger.getJADELogger(this.getClass().getName());

    public BaseInitiator() {
        this((OutcomeManager)null);
    }

    public BaseInitiator(OutcomeManager om) {
        super(null, null);
        this.outcome = om != null ? om : new OutcomeManager(this);
    }

    public void setActiveConversations(ConversationList conversations) {
        this.conversations = conversations;
    }

    protected void checkLanguage(String languageName) {
        if (this.myAgent.getContentManager().lookupLanguage(languageName) == null) {
            if (languageName.equals("fipa-sl")) {
                this.myAgent.getContentManager().registerLanguage(new SLCodec(true));
            } else if (languageName.equals("LEAP")) {
                this.myAgent.getContentManager().registerLanguage(new LEAPCodec());
            }
        }
    }

    protected void checkOntology(Ontology onto) {
        if (this.myAgent.getContentManager().lookupOntology(onto.getName()) == null) {
            this.myAgent.getContentManager().registerOntology(onto);
        }
    }

    public OutcomeManager getOutcome() {
        return this.outcome;
    }

    public int getExitCode() {
        return this.outcome.getExitCode();
    }

    public String getErrorMsg() {
        return this.outcome.getErrorMsg();
    }

    protected abstract ACLMessage createInitiation();

    protected String getTargetDescription() {
        return this.defaultTargetDescription;
    }

    @Override
    public Vector prepareRequests(ACLMessage msg) {
        Vector<ACLMessage> v = new Vector<ACLMessage>(1);
        try {
            ACLMessage initiation = this.createInitiation();
            if (initiation != null) {
                if (this.conversations != null) {
                    this.convId = initiation.getConversationId();
                    if (this.convId == null) {
                        this.convId = this.buildConversationId();
                        initiation.setConversationId(this.convId);
                    }
                    this.conversations.registerConversation(this.convId);
                }
                v.add(initiation);
                Iterator it = initiation.getAllReceiver();
                if (it.hasNext()) {
                    this.target = (AID)it.next();
                    this.defaultTargetDescription = "Agent " + this.target.getLocalName();
                }
            }
        }
        catch (Exception e) {
            this.outcome.error("Unexpected error creating initiation message: ", e);
        }
        return v;
    }

    @Override
    public void handleRefuse(ACLMessage refuse) {
        this.outcome.error("REFUSE response received from " + refuse.getSender().getLocalName() + ": " + refuse.getContent(), null);
    }

    @Override
    public void handleNotUnderstood(ACLMessage notUnderstood) {
        this.outcome.error("NOT_UNDERSTOOD response received from " + notUnderstood.getSender().getLocalName() + ": " + notUnderstood.getContent(), null);
    }

    @Override
    public void handleFailure(ACLMessage failure) {
        if (failure.getSender().equals(this.myAgent.getAMS()) && !this.target.equals(this.myAgent.getAMS())) {
            this.outcome.error(this.getTargetDescription() + " does not exist or cannot be reached", null);
        } else {
            this.outcome.error("FAILURE response received from " + failure.getSender().getLocalName() + ": " + failure.getContent(), null);
        }
    }

    @Override
    public void handleAllResultNotifications(Vector notifications) {
        ACLMessage reply;
        if (notifications.isEmpty() && ((reply = (ACLMessage)this.getDataStore().get(this.REPLY_KEY)) == null || reply.getPerformative() == 1)) {
            this.handleTimeout();
        }
    }

    public void handleTimeout() {
        this.outcome.error("Timeout expired waiting for response from " + this.getTargetDescription(), null);
    }

    @Override
    public int onEnd() {
        int ret = super.onEnd();
        if (this.conversations != null) {
            this.conversations.deregisterConversation(this.convId);
        }
        return ret;
    }

    private synchronized String buildConversationId() {
        return this.myAgent.getLocalName() + "-" + String.valueOf(++conversationCnt) + "-" + System.currentTimeMillis();
    }
}

