/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Serializable;

class Scheduler
implements Serializable {
    protected List readyBehaviours = new LinkedList();
    protected List blockedBehaviours = new LinkedList();
    private Agent owner;
    private int currentIndex;

    public Scheduler(Agent a) {
        this.owner = a;
        this.currentIndex = 0;
    }

    public synchronized void add(Behaviour b) {
        this.readyBehaviours.add(b);
        this.notify();
        this.owner.notifyAddBehaviour(b);
    }

    public synchronized void block(Behaviour b) {
        if (this.removeFromReady(b)) {
            this.blockedBehaviours.add(b);
            this.owner.notifyChangeBehaviourState(b, "READY", "BLOCKED");
        }
    }

    public synchronized void restart(Behaviour b) {
        if (this.removeFromBlocked(b)) {
            this.readyBehaviours.add(b);
            this.notify();
            this.owner.notifyChangeBehaviourState(b, "BLOCKED", "READY");
        }
    }

    public synchronized void restartAll() {
        Behaviour b;
        Behaviour[] behaviours = new Behaviour[this.readyBehaviours.size()];
        int counter = 0;
        Iterator it = this.readyBehaviours.iterator();
        while (it.hasNext()) {
            behaviours[counter++] = (Behaviour)it.next();
        }
        for (int i = 0; i < behaviours.length; ++i) {
            b = behaviours[i];
            b.restart();
        }
        behaviours = new Behaviour[this.blockedBehaviours.size()];
        counter = 0;
        it = this.blockedBehaviours.iterator();
        while (it.hasNext()) {
            behaviours[counter++] = (Behaviour)it.next();
        }
        for (int i = 0; i < behaviours.length; ++i) {
            b = behaviours[i];
            b.restart();
        }
    }

    public synchronized void remove(Behaviour b) {
        boolean found = this.removeFromBlocked(b);
        if (!found) {
            found = this.removeFromReady(b);
        }
        if (found) {
            this.owner.notifyRemoveBehaviour(b);
        }
    }

    public synchronized Behaviour schedule() throws InterruptedException {
        while (this.readyBehaviours.isEmpty()) {
            this.owner.idle();
        }
        Behaviour b = (Behaviour)this.readyBehaviours.get(this.currentIndex);
        this.currentIndex = (this.currentIndex + 1) % this.readyBehaviours.size();
        return b;
    }

    public synchronized int size() {
        return this.blockedBehaviours.size() + this.readyBehaviours.size();
    }

    public synchronized Behaviour[] getBehaviours() {
        Behaviour[] result = new Behaviour[this.blockedBehaviours.size() + this.readyBehaviours.size()];
        Iterator itReady = this.readyBehaviours.iterator();
        Iterator itBlocked = this.blockedBehaviours.iterator();
        for (int i = 0; i < result.length; ++i) {
            Behaviour b = null;
            b = itReady.hasNext() ? (Behaviour)itReady.next() : (Behaviour)itBlocked.next();
            result[i] = b;
        }
        return result;
    }

    public void setBehaviours(Behaviour[] behaviours) {
        this.readyBehaviours.clear();
        this.blockedBehaviours.clear();
        for (int i = 0; i < behaviours.length; ++i) {
            Behaviour b = behaviours[i];
            if (b.isRunnable()) {
                this.readyBehaviours.add(b);
                continue;
            }
            this.blockedBehaviours.add(b);
        }
        this.currentIndex = 0;
    }

    private boolean removeFromBlocked(Behaviour b) {
        return this.blockedBehaviours.remove(b);
    }

    private boolean removeFromReady(Behaviour b) {
        int index = this.readyBehaviours.indexOf(b);
        if (index != -1) {
            this.readyBehaviours.remove(b);
            if (index < this.currentIndex) {
                --this.currentIndex;
            } else if (index == this.currentIndex && this.currentIndex == this.readyBehaviours.size()) {
                this.currentIndex = 0;
            }
        }
        return index != -1;
    }
}

