/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.CaseInsensitiveString;
import jade.core.CommandProcessor;
import jade.core.IMTPException;
import jade.core.IMTPManager;
import jade.core.MainContainerImpl;
import jade.core.PlatformManager;
import jade.core.PlatformManagerImpl;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.ResourceManager;
import jade.core.ServiceFinder;
import jade.core.ServiceManager;
import jade.core.ServiceManagerImpl;
import jade.core.Specifier;
import jade.util.ExtendedProperties;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import jade.util.leap.Properties;
import java.io.IOException;
import java.util.Vector;

public class ProfileImpl
extends Profile {
    private Properties props = null;
    protected Properties bootProps = null;
    private static final String RESOURCE = "resource";
    private MainContainerImpl myMain = null;
    private PlatformManager myPlatformManager = null;
    private ServiceManager myServiceManager = null;
    private CommandProcessor myCommandProcessor = null;
    private IMTPManager myIMTPManager = null;
    private ResourceManager myResourceManager = null;

    public ProfileImpl(Properties aProp) {
        this.props = aProp;
    }

    public ProfileImpl(boolean isMain) {
        this.props = new ExtendedProperties();
        this.props.setProperty("main", new Boolean(isMain).toString());
    }

    public ProfileImpl() {
        this(true);
    }

    public ProfileImpl(String fileName) throws ProfileException {
        this.props = new Properties();
        if (fileName != null) {
            try {
                this.props.load(fileName);
            }
            catch (IOException ioe) {
                throw new ProfileException("Can't load properties: " + ioe.getMessage());
            }
        }
    }

    public ProfileImpl(String host, int port, String platformID) {
        this(host, port, platformID, true);
    }

    public ProfileImpl(String host, int port, String platformID, boolean isMain) {
        this.props = new ExtendedProperties();
        this.props.setProperty("main", new Boolean(isMain).toString());
        if (host != null) {
            this.props.setProperty("host", host);
        }
        if (port > 0) {
            this.setIntProperty("port", port);
        }
        if (platformID != null) {
            this.props.setProperty("platform-id", platformID);
        }
    }

    void init() {
        String lp;
        String localHost;
        String p;
        boolean containerProp;
        this.bootProps = (Properties)this.props.clone();
        if (this.props.getProperty("jvm") == null) {
            this.props.setProperty("jvm", "j2se");
        }
        this.setPropertyIfNot("main", String.valueOf(!(containerProp = this.getBooleanProperty("container", false))));
        String host = this.props.getProperty("host");
        if (host == null) {
            host = ProfileImpl.getDefaultNetworkName(this.getBooleanProperty("priviledge-logical-name", false));
            this.props.setProperty("host", host);
        }
        if ((p = this.props.getProperty("port")) == null) {
            String localPort = this.props.getProperty("local-port");
            p = this.isMasterMain() ? (localPort != null ? localPort : Integer.toString(1099)) : Integer.toString(1099);
            this.props.setProperty("port", p);
        }
        if ((localHost = this.props.getProperty("local-host")) == null) {
            localHost = this.isMasterMain() ? host : ProfileImpl.getDefaultNetworkName(this.getBooleanProperty("priviledge-logical-name", false));
            this.props.setProperty("local-host", localHost);
        }
        if ((lp = this.props.getProperty("local-port")) == null) {
            lp = this.isMasterMain() ? p : Integer.toString(1099);
            this.props.setProperty("local-port", lp);
        }
        this.setPropertyIfNot("services", "jade.core.mobility.AgentMobilityService;jade.core.event.NotificationService");
        try {
            List agents = this.getSpecifiers("agents");
            String isGui = this.props.getProperty("gui");
            if (isGui != null && CaseInsensitiveString.equalsIgnoreCase(isGui, "true")) {
                Specifier s = new Specifier();
                s.setName("rma");
                s.setClassName("jade.tools.rma.rma");
                agents.add(0, s);
                this.props.put("agents", agents);
            }
        }
        catch (ProfileException pe) {
            pe.printStackTrace();
        }
        if (this.isMain() && !this.getBooleanProperty("nomtp", false) && this.props.getProperty("mtps") == null) {
            Specifier s = new Specifier();
            s.setClassName("jade.mtp.http.MessageTransportProtocol");
            ArrayList l = new ArrayList(1);
            l.add(s);
            this.props.put("mtps", l);
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    @Override
    public Properties getBootProperties() {
        return this.bootProps;
    }

    @Override
    public void setParameter(String key, String value) {
        if (value == null) {
            this.props.remove(key);
        } else {
            this.props.setProperty(key, value);
        }
    }

    @Override
    public void setSpecifiers(String key, List value) {
        this.props.put(key, value);
    }

    @Override
    public String getParameter(String key, String aDefault) {
        String v = this.props.getProperty(key);
        if (v == null) {
            String dottedKey = key.replace('_', '.');
            v = this.props.getProperty(dottedKey);
        }
        if (v == null) {
            String underscoredKey = key.replace('.', '_');
            v = this.props.getProperty(underscoredKey);
        }
        return v != null ? v.trim() : aDefault;
    }

    @Override
    public List getSpecifiers(String key) throws ProfileException {
        Object o = this.props.get(key);
        if (o instanceof List) {
            return (List)o;
        }
        String specsLine = this.getParameter(key, null);
        try {
            Vector v = Specifier.parseSpecifierList(specsLine);
            ArrayList l1 = new ArrayList(v.size());
            for (int i = 0; i < v.size(); ++i) {
                l1.add(v.elementAt(i));
            }
            return l1;
        }
        catch (Exception e) {
            throw new ProfileException("Error parsing specifier list " + specsLine + ".", e);
        }
    }

    @Override
    public boolean getBooleanProperty(String aKey, boolean aDefault) {
        String v = this.props.getProperty(aKey);
        if (v == null) {
            return aDefault;
        }
        if (CaseInsensitiveString.equalsIgnoreCase(v, "true")) {
            return true;
        }
        if (CaseInsensitiveString.equalsIgnoreCase(v, "false")) {
            return false;
        }
        return aDefault;
    }

    public String toString() {
        return this.props.toString();
    }

    protected PlatformManager getPlatformManager() throws ProfileException {
        if (this.myPlatformManager == null) {
            this.createPlatformManager();
        }
        return this.myPlatformManager;
    }

    @Override
    protected ServiceManager getServiceManager() throws ProfileException {
        if (this.myServiceManager == null) {
            this.myServiceManager = new ServiceManagerImpl(this, this.getPlatformManager());
        }
        return this.myServiceManager;
    }

    @Override
    protected ServiceFinder getServiceFinder() throws ProfileException {
        return (ServiceFinder)((Object)this.getServiceManager());
    }

    @Override
    protected CommandProcessor getCommandProcessor() throws ProfileException {
        if (this.myCommandProcessor == null) {
            this.myCommandProcessor = new CommandProcessor();
        }
        return this.myCommandProcessor;
    }

    @Override
    protected MainContainerImpl getMain() throws ProfileException {
        return this.myMain;
    }

    @Override
    protected IMTPManager getIMTPManager() throws ProfileException {
        if (this.myIMTPManager == null) {
            this.createIMTPManager();
        }
        return this.myIMTPManager;
    }

    @Override
    public ResourceManager getResourceManager() throws ProfileException {
        if (this.myResourceManager == null) {
            this.createResourceManager();
        }
        return this.myResourceManager;
    }

    private void createPlatformManager() throws ProfileException {
        try {
            this.myIMTPManager = this.getIMTPManager();
            if (this.isMain()) {
                PlatformManagerImpl pm = new PlatformManagerImpl(this);
                this.myIMTPManager.exportPlatformManager(pm);
                this.myMain = pm.getMain();
                this.myPlatformManager = pm;
                return;
            }
            this.myPlatformManager = this.myIMTPManager.getPlatformManagerProxy();
        }
        catch (IMTPException imtpe) {
            throw new ProfileException("Can't get a proxy to the Platform Manager", imtpe);
        }
    }

    private void createIMTPManager() throws ProfileException {
        String imtp;
        String imtpClass = imtp = this.getParameter("imtp", "LEAP");
        if (imtp.equals("LEAP")) {
            imtpClass = "jade.imtp.leap.LEAPIMTPManager";
        } else if (imtp.equals("RMI")) {
            imtpClass = "jade.imtp.rmi.RMIIMTPManager";
        }
        try {
            this.myIMTPManager = (IMTPManager)Class.forName(imtpClass).newInstance();
        }
        catch (Exception e) {
            throw new ProfileException("Error loading IMTPManager class " + imtpClass);
        }
    }

    private void createResourceManager() throws ProfileException {
        String className = this.getParameter(RESOURCE, "jade.core.FullResourceManager");
        try {
            this.myResourceManager = (ResourceManager)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new ProfileException("Error loading ResourceManager class " + className);
        }
    }

    private void setPropertyIfNot(String key, String value) {
        Object old = this.props.get(key);
        if (old == null) {
            this.props.put(key, value);
        }
    }

    private void setIntProperty(String aKey, int aValue) {
        this.props.setProperty(aKey, Integer.toString(aValue));
    }
}

